package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import java.awt.Point;
import org.netbeans.api.visual.anchor.Anchor;

/**
 * This envelope represents one {@link CompetenceElement}. 
 * @author Honza H
 */
public final class ShedChoiceEnvelope extends SlotEnvelope {
    private final Anchor anchor;

    public ShedChoiceEnvelope(ShedScene scene, ShedWidget slotWidget, ShedTriggerEnvelope triggerEnvelope, ExpandedActionEnvelope expandedActionEnvelope) {
        super(scene, slotWidget, triggerEnvelope, expandedActionEnvelope);
        
        this.anchor = new FixedWidgetAnchor(slotWidget, new Point(0, ShedWidget.height / 2), Anchor.Direction.LEFT);
    }
    
    /**
     * @return Get anchor on the left side of envelope that can be used for arrows.
     */
    public Anchor getCommonAnchor() {
        return this.anchor;
    }
    
}
