/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PrimitiveData
implements Comparable<PrimitiveData> {
    public final String classFQN;
    public final String name;
    public final String description;
    public final String[] tags;
    public final Set<String> parameters;

    public PrimitiveData(String classFQN, String name, String description, String[] tags, Set<String> parameters) {
        this.classFQN = classFQN;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.parameters = Collections.unmodifiableSet(new HashSet<String>(parameters));
    }

    public String getClassName() {
        return this.classFQN.replaceFirst("^.*\\.", "");
    }

    @Override
    public int compareTo(PrimitiveData o) {
        if (this == o) {
            return 0;
        }
        String myName = this.name != null ? this.name : this.getClassName();
        String oName = o.name != null ? o.name : o.getClassName();
        int nameComparison = myName.toLowerCase().compareTo(oName.toLowerCase());
        if (nameComparison != 0) {
            return nameComparison;
        }
        return this.classFQN.compareTo(o.classFQN);
    }

    public String toString() {
        return (this.name != null ? this.name : this.getClassName()) + "(" + this.classFQN + ")";
    }
}

