package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments.Argument;
import org.junit.Assert;
import org.junit.Test;
import org.junit.Before;

/**
 *
 * @author Honza
 */
public class TableParameterTest extends Assert {

    private TableParameter stringParameter;
    private TableParameter nilParameter;
    private TableParameter intParameter;
    private TableParameter boolParameter;

    private TableParameter overridenValue;
    private TableParameter overridenVariable;

    @Before
    public void setUp() {
        overridenValue = new TableParameter("$overridenValueParam", "\"original\"", "\"overriden\"");
        overridenVariable = new TableParameter("$overridenVariableParam", "\"original\"", "$overriding");
        stringParameter = new TableParameter("$stringParam", "\"Hello\"", "");
        nilParameter = new TableParameter("$nilParam", "nil", "");
        intParameter = new TableParameter("$intParam", "15", "");
        boolParameter = new TableParameter("$boolParam", "true", "");
    }

    @Test
    public void stringParam() {
        assertEquals("Hello", stringParameter.getDefaultValue());
    }

    @Test
    public void nilParam() {
        assertEquals(null, nilParameter.getDefaultValue());
    }

    @Test
    public void intParam() {
        assertEquals(15, intParameter.getDefaultValue());
    }

    @Test
    public void boolParam() {
        assertEquals(true, boolParameter.getDefaultValue());
    }
    
    @Test
    public void overridenValueParamArgument() {
        Argument argument = overridenValue.createOverrideArgument();

        assertEquals("$overridenValueParam", argument.getParameterName());
        assertNull(argument.getParameterVariable());
        assertEquals("overriden", argument.getValue());
    }

    @Test
    public void overridenVariableParamArgument() {
        Argument argument = overridenVariable.createOverrideArgument();

        assertEquals("$overridenVariableParam", argument.getParameterName());
        assertEquals("$overriding", argument.getParameterVariable());
    }
    
}
