package cz.cuni.pogamut.posh.palette.external;

import cz.cuni.pogamut.posh.PoshDataObject;
import cz.cuni.pogamut.posh.palette.PaletteRoot;
import cz.cuni.pogamut.posh.palette.external.ExternalBehaviourLoader.BehaviourPrimitives;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.spi.palette.PaletteController;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

/**
 * Take external jars and load them to the palette.
 * @author Honza
 */
final public class ExternalBehaviour2PaletteTask implements Runnable {

    private Lookup lookup;

    public ExternalBehaviour2PaletteTask(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public synchronized void run() {
        // Get palette
        PaletteController paletteController = lookup.lookup(PaletteController.class);
        if (paletteController == null) {
            throw new IllegalArgumentException("Lookup has no PaletteController.");
        }

        // get union of all possible actions and senses that are stored in external jars
        PoshDataObject dataObj = lookup.lookup(PoshDataObject.class);
        if (dataObj == null) {
            return;
        }
        ExternalBehaviourLoader behaviourLoader = new ExternalBehaviourLoader(dataObj);
        Map<Class, BehaviourPrimitives> info = behaviourLoader.createBehaviourInfo();
        BehaviourPrimitives unitedBehaviour = getUnion(info.values());

        testUniqueness(unitedBehaviour.getActions());
        testUniqueness(unitedBehaviour.getSenses());

        // Put it into palette
        PaletteRoot pal = paletteController.getRoot().lookup(PaletteRoot.class);
        pal.getActionsChildren().setExternalActions(unitedBehaviour.getActions());
        pal.getSensesChildren().setExternalSenses(unitedBehaviour.getSenses());

    }

    /**
     * Get union of passed set of behaviour primitives.
     * @return
     */
    private BehaviourPrimitives getUnion(Collection<BehaviourPrimitives> set) {
        Set<Method> actions = new HashSet<Method>();
        for (BehaviourPrimitives bp : set) {
            actions.addAll(bp.getActions());
        }

        Set<Method> senses = new HashSet<Method>();
        for (BehaviourPrimitives bp : set) {
            senses.addAll(bp.getSenses());
        }

        return new BehaviourPrimitives(actions, senses);
    }

    /**
     * Test if all passed methods have unique name and if not, write severe message to log
     * and throw an exception.
     * @param methods list of methods that will be tested for uniqueness
     */
    private void testUniqueness(List<Method> methods) {
        Set<String> names = new HashSet<String>();
        for (Method m : methods) {
            if (names.contains(m.getName())) {
                throw new IllegalArgumentException("Method " + m.getName() + " in class " + m.getDeclaringClass().getCanonicalName() + " has duplicate with same name." );
            }
            names.add(m.getName());
        }
    }
}
