/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.view;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.PoshEditorSupport;
import cz.cuni.pogamut.posh.palette.PaletteRoot;
import cz.cuni.pogamut.posh.palette.PoshPaletteFactory;
import cz.cuni.pogamut.posh.view.TreeCollapseImprint;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.kidview.SimpleDriveCollectionWidget;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.spi.palette.PaletteController;
import org.openide.awt.UndoRedo;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class KidViewElement
implements MultiViewElement {
    private PoshPlan plan;
    private PoshEditorSupport support;
    private TreeCollapseImprint collapseImprint;
    private PoshScene scene;
    private JScrollPane scrollPane;
    private JToolBar toolbar;
    private AbstractLookup lookup;
    private InstanceContent ic;

    public KidViewElement(PoshEditorSupport support) {
        this.support = support;
        this.scene = new PoshScene();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.scene.createView());
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.ic.add((Object)PoshPaletteFactory.createPalette(this.getLookup()));
    }

    public JComponent getVisualRepresentation() {
        return this.scrollPane;
    }

    private void refresh(PoshPlan root) throws ParseException {
        this.plan = root;
        this.scene.clearPoshWidgets();
        this.scene.setRootWidget(new SimpleDriveCollectionWidget(this.scene, root.getDriveCollection(), null));
        this.plan.emitTree();
        this.plan.addGlobalTreeListener((PoshElementListener)new SourceUpdater(this.plan, this.support));
    }

    private void refreshPalette() {
        PaletteController pc = (PaletteController)this.getLookup().lookup(PaletteController.class);
        if (pc != null) {
            PaletteRoot palRoot = (PaletteRoot)((Object)pc.getRoot().lookup(PaletteRoot.class));
            pc.clearSelection();
            this.plan.addGlobalTreeListener((PoshElementListener)palRoot.getAPsChildren());
            this.plan.addGlobalTreeListener((PoshElementListener)palRoot.getComptencesChildren());
            this.plan.addGlobalTreeListener((PoshElementListener)palRoot.getActionsChildren());
            this.plan.addGlobalTreeListener((PoshElementListener)palRoot.getSensesChildren());
            palRoot.getAPsChildren().refresh(this.plan);
            palRoot.getComptencesChildren().refresh(this.plan);
            palRoot.getActionsChildren().refresh(this.plan);
            palRoot.getSensesChildren().refresh(this.plan);
        }
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
        }
        return this.toolbar;
    }

    public Action[] getActions() {
        return this.support.getDataObject().getNodeDelegate().getActions(false);
    }

    public Lookup getLookup() {
        return new ProxyLookup(new Lookup[]{this.support.getDataObject().getNodeDelegate().getLookup(), this.lookup});
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
        this.regenerate();
    }

    public void componentHidden() {
        if (this.scene.getRootWidget() != null) {
            this.collapseImprint = new TreeCollapseImprint(this.scene.getRootWidget());
        }
    }

    public void componentActivated() {
        this.refreshPalette();
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void setMultiViewCallback(MultiViewElementCallback mvec) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void regenerate() {
        try {
            PoshParser parser = new PoshParser(this.support.getInputStream());
            PoshPlan newPlan = parser.parsePlan();
            this.scrollPane.setViewportView(this.scene.getView());
            this.refresh(newPlan);
            if (this.collapseImprint != null) {
                this.collapseImprint.restore(this.scene.getRootWidget());
            }
            this.collapseImprint = null;
        }
        catch (ParseException ex) {
            this.scrollPane.setViewportView(new ParseErrorPane(ex));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class ParseErrorPane
    extends JEditorPane {
        private ParseErrorPane(ParseException exception) {
            super("text/html", "<html><head><style>.errorbox {}.boxtitle {\tbackground-color: rgb(157, 173, 198);\ttext-align: center;}.boxtitle h2 {\tmargin: 0;\tpadding: 15px 30px 5px;\tcolor: white;\tfont-weight: bold;\tfont-size: 1.5em;}.boxtext {\tbackground-color: rgb(230, 230, 230);\tpadding: 5px 50px 31px;}</style></head><body><div class=\"errorbox\">  <div class=\"boxtitle\"><h2>Syntax error</h2></div>  <div class=\"boxtext\">    <p>There is a problem in syntax of supplied posh plan. To remedy this situation, switch to source view and correct syntax error.</p>    <p>The syntax error will be marked by red exclamation mark at the line of error. Description of error will be in tooltip of the exclamation mark.</p>    <p><b>Error:</b> " + exception.getMessage().replace("<", "&lt;").replace(">", "&gt;") + "</p>" + "  </div>" + "</div>" + "</body>" + "</html>");
        }
    }

    private static final class SourceUpdater
    implements PoshElementListener,
    Runnable {
        private PoshEditorSupport support;
        private PoshPlan plan;

        private SourceUpdater(PoshPlan plan, PoshEditorSupport support) {
            this.plan = plan;
            this.support = support;
        }

        public void nodeChanged(PoshTreeEvent event, PoshElement child) {
            NbDocument.runAtomic((StyledDocument)this.support.getDocument(), (Runnable)this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            NbDocument.runAtomic((StyledDocument)this.support.getDocument(), (Runnable)this);
        }

        @Override
        public void run() {
            try {
                String planString = this.plan.toString();
                this.support.getDocument().remove(0, this.support.getDocument().getLength());
                this.support.getDocument().insertString(0, planString, null);
                this.support.setModified();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

