/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.nbparser;

import cz.cuni.amis.pogamut.sposh.elements.Token;
import cz.cuni.pogamut.posh.nbparser.NbPoshParser;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

class SyntaxErrorsHighlightingTask
extends ParserResultTask {
    SyntaxErrorsHighlightingTask() {
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        try {
            Collection<cz.cuni.amis.pogamut.sposh.elements.ParseException> syntaxErrors = ((NbPoshParser.ParserResult)result).getSyntaxErrors();
            Document document = result.getSnapshot().getSource().getDocument(false);
            ArrayList<ErrorDescription> errorHints = new ArrayList<ErrorDescription>();
            for (cz.cuni.amis.pogamut.sposh.elements.ParseException syntaxError : syntaxErrors) {
                Token token = syntaxError.currentToken;
                int start = NbDocument.findLineOffset((StyledDocument)((StyledDocument)document), (int)(token.beginLine < 1 ? 0 : token.beginLine - 1)) + (token.beginColumn < 1 ? 1 : token.beginColumn - 1);
                int end = NbDocument.findLineOffset((StyledDocument)((StyledDocument)document), (int)(token.endLine < 1 ? 0 : token.endLine - 1)) + token.endColumn;
                errorHints.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)syntaxError.getMessage(), (Document)document, (Position)document.createPosition(start), (Position)document.createPosition(end)));
            }
            HintsController.setErrors((Document)document, (String)"posh-errors", errorHints);
        }
        catch (BadLocationException ex1) {
            Exceptions.printStackTrace((Throwable)ex1);
        }
        catch (ParseException ex1) {
            Exceptions.printStackTrace((Throwable)ex1);
        }
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }
}

