package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.nodes.Children;
import org.openide.util.datatransfer.ExTransferable;

/**
 * Representation of "Add DrivePriorityElement" node in palette.
 * @author Honza
 */
class AddDriveActionNode extends PoshPaletteNode {

//	public final static DataFlavor dataFlavor = new DataFlavor(AddDriveActionNode.class, "add-drive");
	static int num = 10;

	AddDriveActionNode() {
		super(Children.LEAF);

		this.setName("((new_drive (trigger((succeed))) doNothing))");
		this.setDisplayName("Drive");
	}

	/**
	 * Ask user for name of drive, create a drive, encapsulate it and return it.
	 * @return Transferable that will create new DrivePriorityElement.
	 */
	@Override
	protected ExTransferable.Single createTransferable() {
		return new ExTransferable.Single(DrivePriorityElement.dataFlavor) {

			@Override
			protected Object getData() throws IOException, UnsupportedFlavorException {
				String driveName = PGSupport.getIdentifierFromDialog("Name of drive");
				if (driveName == null) {
					return null;
				}
				DriveElement driveElement = new DriveElement(driveName, new Triggers(new Sense("succeed")), "doNothing", null);
				DrivePriorityElement drive = new DrivePriorityElement(driveElement);

				return drive;
			}
		};
	}
}

