/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.pogamut.posh.palette.ExternalSenseNode;
import cz.cuni.pogamut.posh.palette.OldSenseNode;
import cz.cuni.pogamut.posh.palette.SenseNode;
import cz.cuni.pogamut.posh.palette.external.BehaviourInterfaceBuilder;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class SensesChildren
extends Children.SortedMap<Sense>
implements PoshElementListener {
    private List<String> undefinedSenses = new ArrayList<String>();
    private List<Sense> externalSenses = new ArrayList<Sense>();
    private List<String> oldSenses = new ArrayList<String>();
    private Lookup lookup;

    public SensesChildren(Lookup lookup) {
        this.lookup = lookup;
    }

    public void nodeChanged(PoshTreeEvent event, PoshElement child) {
        this.refresh(child.getRootNode());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh(((PoshElement)evt.getSource()).getRootNode());
    }

    public synchronized void refresh(PoshPlan plan) {
        List<Sense> senses = this.getAllSenses(plan);
        ArrayList<String> senseNames = new ArrayList<String>();
        for (Sense sense : senses) {
            String senseName = sense.getSenseName();
            if (senseNames.contains(senseName)) continue;
            senseNames.add(senseName);
        }
        this.removeDuplicateSenses(senseNames, this.externalSenses);
        this.oldSenses.addAll(this.undefinedSenses);
        this.oldSenses.removeAll(senseNames);
        this.removeDuplicateSenses(this.oldSenses, this.externalSenses);
        Collections.sort(senseNames);
        for (Sense sense : this.nodes.keySet().toArray(new Sense[0])) {
            this.remove(sense);
        }
        this.undefinedSenses.clear();
        for (String senseName : senseNames) {
            Sense sense = new Sense(senseName);
            this.put(sense, (Node)new SenseNode(sense));
            this.undefinedSenses.add(senseName);
        }
        for (String oldSenseName : this.oldSenses) {
            Sense os = new Sense(oldSenseName);
            this.put(os, (Node)new OldSenseNode(os));
        }
        for (Sense sense : this.externalSenses) {
            this.put(sense, (Node)new ExternalSenseNode(sense));
        }
        this.refresh();
        new Thread(new BehaviourInterfaceBuilder(this.lookup)).start();
    }

    private List<Sense> getAllSenses(PoshPlan plan) {
        LinkedList<Sense> senses = new LinkedList<Sense>();
        DriveCollection dc = plan.getDriveCollection();
        if (dc.getGoal() != null) {
            senses.addAll(dc.getGoal().getSenses());
        }
        for (DrivePriorityElement dpe : dc.getPriorityElements()) {
            for (DriveElement de : dpe.getDriveElements()) {
                senses.addAll(de.getTriggers().getSenses());
            }
        }
        List competences = plan.getCompetences();
        for (Competence competence : competences) {
            if (competence.getGoal() != null) {
                senses.addAll(competence.getGoal().getSenses());
            }
            for (CompetencePriorityElement cpe : competence.getPriorityElements()) {
                for (CompetenceElement ce : cpe.getElements()) {
                    senses.addAll(ce.getTriggerSenses());
                }
            }
        }
        return senses;
    }

    public synchronized void setExternalSenses(List<Method> externalMethods) {
        this.removeSenses(this.externalSenses);
        this.externalSenses.clear();
        for (Method m : externalMethods) {
            Sense sense = new Sense(m.getName());
            this.externalSenses.add(sense);
            this.put(sense, (Node)new ExternalSenseNode(sense));
        }
    }

    private void removeSenses(List<Sense> list) {
        for (Sense sense : list) {
            this.remove(sense);
        }
    }

    private void removeDuplicateSenses(List<String> senseNames, List<Sense> tobeRemoved) {
        for (String senseName : senseNames.toArray(new String[0])) {
            for (Sense sense : tobeRemoved) {
                if (!sense.getSenseName().equals(senseName)) continue;
                senseNames.remove(sense.getSenseName());
            }
        }
    }

    public synchronized List<String> getUndefinedSenses() {
        return Collections.unmodifiableList(this.undefinedSenses);
    }

    synchronized void removeOldSense(Sense oldSense) {
        this.oldSenses.remove(oldSense.getSenseName());
        this.remove(oldSense);
    }
}

