package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.PoshWidgetChildren;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import java.awt.Point;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.widget.Widget;

/**
 *
 * @author Honza
 */
public abstract class StrBasicWidget<T extends PoshElement> extends PoshWidget<T> {

	/**
	 * Create a widget representing dataNode that has a parentwidget parent.
	 *
	 * @param poshScene
	 * @param dataNode
	 * @param parent 
	 */
	protected StrBasicWidget(PoshScene poshScene, T dataNode, PoshWidget parent) {
		super(poshScene, dataNode, parent);
/*
		if (parent != null) {
			parent.getChildNodes().add(this);
			getPoshScene().addPoshWidget(this);
		}*/
	}

	/**
	 * Create actions for context menu.
	 * @return not null, list of actions for context menu
	 */
	abstract protected List<AbstractMenuAction> createMenuActions();

	@Override
	final public JPopupMenu getPopupMenu(Widget arg0, Point arg1) {
		JPopupMenu menu = new JPopupMenu("Popup menu");

		// create action list
		List<AbstractMenuAction> actionList = createMenuActions();

		for (AbstractMenuAction action : actionList) {
			JMenuItem item = new JMenuItem(action.getDescription());
			item.addActionListener(action);
			menu.add(item);
		}

		return menu;
	}

	@Override
	public final void nodeChanged(PoshTreeEvent event, PoshElement dataNode) {
		if (event == PoshTreeEvent.NEW_CHILD_NODE) {
			if (this.getPoshScene().isInMainLayer(this)) {
				this.addChildWidget(dataNode);
			} else {
				throw new RuntimeException(" PoshError: widget not part of layer, but asked for child");
			}
		} else if (event == PoshTreeEvent.NODE_DELETED) {
			this.deleteWidgetFromScene(dataNode);
		} else if (event == PoshTreeEvent.CHILD_NODE_MOVED) {
			this.moveChildWidget(dataNode);
		} else {
			throw new IllegalArgumentException("Event " + event + " shouldn't exist.");
		}
		doRepaint();
	}

	/**
	 * This is called when node is added as child
	 * @param dataNode
	 */
	protected abstract void addChildWidget(PoshElement dataNode);

	/**
	 * DataNode was moved in the tree and this method is responsible for
	 * reflecting the event in the graph representation.
	 * 
	 * @param movedChildDN data node that has moved.
	 */
	protected void moveChildWidget(PoshElement movedChildDN) {
		synchronizeDataNodeWidgets(null);
	}

	/**
	 * 
	 * @param dataNode
	 */
	protected void deleteWidgetFromScene(PoshElement dataNode) {
		if (this.getDataNode() != dataNode) {
			throw new RuntimeException("Associated datanode " +getDataNode().getClass() + " is not matching to passed one" + dataNode.getClass());
		}
		deleteWidgetTree(this);
	}

	/**
	 * Remove all tree from leafs to passed widget.
	 * @param widget
	 */
	protected void deleteWidgetTree(PoshWidget widget) {
		// first remove all its children
		PoshWidget[] children = widget.getChildNodes().toArray(new PoshWidget[0]);
		for (PoshWidget child : children) {
			deleteWidgetTree(child);
		}
		// this should be already cleared, but just for sure
		widget.getChildNodes().clear();
		// remove from the scene
		this.getPoshScene().deletePoshWidget(widget);
		// remove listeners from the tree
		this.getDataNode().getRootNode().removeListenersFromTree(widget);

		PoshWidget widgetParent = widget.getParent();
		if (widgetParent == null)
			return;

		widgetParent.getChildNodes().remove(widget);
	}


    /**
     * Is specified element associated with at least one of widgets?
     * @param element element for which we are looking for
     * @param widgets collection of widgets that are looked through to find the associated element.
     * @return true/false
     */
    private boolean isElementInWidgets(PoshElement element, Collection<PoshWidget> widgets) {
        for (PoshWidget widget : widgets) {
            if (widget.getDataNode() == element) {
                return true;
            }
        }
        return false;
    }

    /**
     * Get list of widgets that aren't associated with some element from elements.
     * @param elements list of elements
     * @param widgets list of widgets to check for association
     * @return list of widgets that aren't associated with some element
     */
    private List<PoshWidget> getUnassociatedWidgets(List<PoshElement> elements, List<PoshWidget> widgets) {
        List<PoshWidget> unassociated = new LinkedList<PoshWidget>();
        for (PoshWidget widget : widgets) {
            if (!elements.contains(widget.getDataNode())) {
                unassociated.add(widget);
            }
        }
        return unassociated;
    }

	/**
	 * Take DN children of associated DN and widget children of the widget and
	 * synchronize it according to DN children .
	 * @param newChild
	 */
	protected void synchronizeDataNodeWidgets(PoshElement newChild) {
		PoshElement dn = this.getDataNode();

		List<PoshElement> dnChildren = dn.getChildDataNodes();

		PoshWidgetChildren widgetChildren = this.getChildNodes();

		// find dn from dnChildren that are not represented in widgetChildren
		List<PoshElement> missingDN = new LinkedList<PoshElement>();
		for (PoshElement dnChild : dnChildren) {
			if (!isElementInWidgets(dnChild, widgetChildren)) {
				missingDN.add(dnChild);
			}
		}

		// DEBUG:
/*		System.out.println("List of missing DN");
		for (PoshElement dnChild : missingDN) {
			System.out.println(" * " + dnChild.getName() + " " + dnChild.getClass().getSimpleName());
		}
		System.out.println("EOL");
*/
		// find widgets from widgetChildren that don't have associated dn in dnChildren
		List<PoshWidget> extraWidgets = getUnassociatedWidgets(dnChildren, widgetChildren);
		// remove widgets that are not supposed to be in the tree
		for (PoshWidget extraWidget : extraWidgets) {
			// remove the widget and its subtree
			deleteWidgetTree(extraWidget);
		}

		// DEBUG:
/*		System.out.println("List of extra widgets");
		for (PoshWidget widget  : extraWidgets) {
			System.out.println(" * " + widget.getHeadlineText() + " " + widget.getCommentText() + " " + widget.getClass().getSimpleName());
		}
		System.out.println("EOL");
*/
		// Create new widgets for extra DN
		for (PoshElement newDN : missingDN) {
			// map DN to Widget
			PoshWidget newWidget = StrWidgetFactory.createWidgetFromDN(getPoshScene(), newDN, this);
			newChildWidget(newWidget);
		}

		if (widgetChildren.size() != dnChildren.size()) {
			throw new RuntimeException("Size is not equal \n" + getDNList() + getWidgetList());
		}

		// DEBUG:
/*		System.out.println("Sorting");
		System.out.println("List of DN");
		for (PoshElement dnChild : dnChildren) {
			System.out.println(" * " + dnChild.getName() + " " + dnChild.getClass().getSimpleName());
		}
		System.out.println("EOL");
		System.out.println("List of widgets");
		for (PoshWidget widget  : widgetChildren) {
			System.out.println(" * " + widget.getHeadlineText() + " " + widget.getCommentText() + " " + widget.getClass().getSimpleName());
		}
		System.out.println("EOL");
*/
		PoshWidget[] widgetsArray = widgetChildren.toArray(new PoshWidget[0]);
		// sort the widgets according to order of DNchildren
		int i=0;
		for (PoshElement dnChild : dnChildren) {
			for (PoshWidget widget : widgetsArray) {
				if (widget.getDataNode() == dnChild) {
					widgetChildren.set(i, widget);
					i++;
				}
			}
//			PoshWidget correspondingWidget = widgetChildren.getAssociatedWidget(dnChild);
		}

		// Test that we are really same.
		this.isSynchronized(); 
	}

	/**
	 * Test if this widget's children are synchronized with DN children
	 * One level only.
	 */
	public void isSynchronized() {
		PoshElement associatedDN = this.getDataNode();

		if (associatedDN == null) {
			throw new RuntimeException("Widget " + this.getName() + " " + this.getCommentText() + " doesn't have an associated data node.");
		}
		List<PoshElement> dnChildren = associatedDN.getChildDataNodes();
		PoshWidgetChildren widgetChildren = this.getChildNodes();

		if (dnChildren.size() != widgetChildren.size()) {
			throw new RuntimeException("Widget " + this.getName() + " " + this.getCommentText() + " doesn't have an associated data node.\n" + getDNList() + getWidgetList());
		}
		int i = 0;
		for (PoshElement dnChild : dnChildren) {
			if (widgetChildren.get(i).getDataNode() != dnChild) {
				throw new RuntimeException(
						"Widget " + this.getName() + " " + this.getCommentText() +
						" has child with widget-datanode michmatch at " + i + "\n" +
						getDNList() + getWidgetList());
			}
			i++;
		}
	}

	protected  String getWidgetList() {
		PoshWidgetChildren widgetChildren = getChildNodes();
		String res = "List of widgets" + widgetChildren.size()  + "(" + this.getClass().getSimpleName() + ")\n";

		for (PoshWidget widget : widgetChildren) {
			res += " * " + widget.getName() + ' ' + widget.getCommentText()+ '(' + widget.getClass().getSimpleName() + ")\n";
		}
		return res;
	}

	protected String getDNList() {
		List<PoshElement> dnChildren = getDataNode().getChildDataNodes();
		String res = "List of data nodes " + dnChildren.size() + "(" + getDataNode().getClass().getSimpleName() +")\n";

		for (PoshElement dn : dnChildren) {
			res += " * " + dn.getDisplayName() + ' ' + dn.getClass().getSimpleName()+ '\n';
		}
		return res;
	}

	protected void newChildWidget(PoshWidget newChild) {
		getChildNodes().add(newChild);
		getPoshScene().addPoshWidget(newChild, true);
	}
}
