package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 *
 * @author havlj3am
 */
public class AcceptComp2Plan extends AbstractAcceptAction<PoshPlan> {

    public AcceptComp2Plan(PoshPlan plan) {
        super(Competence.dataFlavor, plan);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        try {
            Competence cn = (Competence) tr.getTransferData(dataFlavor);
            if (cn != null) {
                dataNode.addCompetence(cn);
            }
        } catch (ParseException ex) {
            NotifyDescriptor.Message error = new NotifyDescriptor.Message(ex.getMessage(), NotifyDescriptor.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(error);
        }
    }
}
