package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;

/**
 * Ancestor for accept providers of widgets.
 * @author Honza
 */
public abstract class AbstractAcceptAction<T extends PoshElement> implements AcceptProvider {

    protected DataFlavor dataFlavor;
    protected T dataNode;
    protected PoshWidget widget;

    /**
     * Create an abstract action in the widget widget that will do something to
     * data node dataNode when transferable of same data flavor as dataFlavor
     * is dropped onto widget.
     *
     * @param dataFlavor data flavor we are accepting, no multiple flavors accepted
     * @param dataNode data node that will be used somehow when accept action happens.
     * @param widget widget transferable is dropped onto for this accept provider to work.
     */
    protected AbstractAcceptAction(DataFlavor dataFlavor, T dataNode, PoshWidget widget) {
        this.dataFlavor = dataFlavor;
        this.dataNode = dataNode;
        this.widget = widget;
    }

    /**
     * same as other constructor, but we don't require widget.
     * @param dataFlavor
     * @param dataNode
     */
    protected AbstractAcceptAction(DataFlavor dataFlavor, PoshElement dataNode) {
        this(dataFlavor, (T) dataNode, null);
    }

    @Override
    public ConnectorState isAcceptable(Widget arg0, Point arg1, Transferable transferable) {
        if (transferable.isDataFlavorSupported(dataFlavor)) {
            return ConnectorState.ACCEPT;
        }
        return ConnectorState.REJECT;
    }

    @Override
    public void accept(Widget arg0, Point arg1, Transferable arg2) {
        try {
            performAction(arg2);
        } catch (UnsupportedFlavorException ex) {
            Exceptions.printStackTrace(ex);
        } catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    /**
     * Get data flavor this accept provider accepts.
     * @return data flavour passed in the constructor
     */
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    /**
     * When deriving from this widget, implement what should actually be done
     * in this function.
     *
     * @param tr Transferable object, basically envelope for object that is going to be dropped.
     * @throws java.awt.datatransfer.UnsupportedFlavorException If transferable is not the type we are looking for (dataFlavour that was passed in construction), throw exception.
     * @throws java.io.IOException if some problem arrises, throw this exception
     */
    abstract protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException;

    /**
     * Get index of object in the list.
     *
     * @param list list of object where this function will look for object o.
     * @param o object whos index we are looking for
     * @return index of object o in the list or length of list if object wasn't found.
     */
    final protected int getIndexInList(List list, Object o) {
        int newlyAddedSenseIndex = 0;
        int index = 0;

        for (Object n : list) {
            if (n == o) {
                newlyAddedSenseIndex = index;
            }
            index++;
        }
        return newlyAddedSenseIndex;
    }
}


