package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

/**
 * Node that display one item in palette - just one sense.
 * 
 * @author Honza
 */
class SenseNode extends AbstractPoshPaletteNode {

    protected Sense sense;

    /**
     * Create new node that represents sense in palette
     * @param sense
     */
    SenseNode(Sense sense) {
        super();

        this.sense = sense;
        this.setDisplayName(sense.getSenseName());

    }

    @Override
    protected Sense getPoshDataNode() {
        return new Sense(sense.getSenseName());
    }
}

class ExternalSenseNode extends SenseNode {

    ExternalSenseNode(Sense sense) {
        super(sense);
        setDisplayName("*" + sense.getSenseName() + "*");

    }
}

class OldSenseNode extends SenseNode {

    OldSenseNode(Sense sense) {
        super(sense);
        setDisplayName("!" + sense.getSenseName() + "!");
    }

    @Override
    public Action[] getActions(boolean ctx) {
        return new Action[]{
                    new AbstractAction("Delete sense") {

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SensesChildren sc = (SensesChildren) getParentNode().getChildren();
                            sc.removeOldSense(sense);
                        }
                    }
                };
    }
}
