package cz.cuni.pogamut.posh.nblexer;

import cz.cuni.pogamut.posh.jcclexer.PoshCharStream;
import cz.cuni.pogamut.posh.jcclexer.PoshLexerTokenManager;
import cz.cuni.pogamut.posh.jcclexer.Token;
import java.util.Deque;
import java.util.LinkedList;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/**
 * Token lexar that reads input and returns tokens for it.
 * @author Honza
 */
public class PoshLexar implements Lexer<PoshTokenId> {

    private LexerRestartInfo<PoshTokenId> info;
    private PoshLexerTokenManager tokenManager;
    private Deque<Token> tokenQueue;

    PoshLexar(LexerRestartInfo<PoshTokenId> info) {
        this.info = info;
        PoshCharStream stream = new PoshCharStream(info.input());
        tokenManager = new PoshLexerTokenManager(stream);
        tokenQueue = new LinkedList<Token>();
    }

    @Override
    public org.netbeans.api.lexer.Token<PoshTokenId> nextToken() {
        PoshTokenId nbToken = PoshLanguageHiearchy.getToken(tokenManager.getNextToken().kind);
        if (info.input().readLength() < 1) {
            return null;
        }
        return info.tokenFactory().createToken(nbToken);
    }

    @Override
    public Object state() {
        return null;
    }

    @Override
    public void release() {
    }
}
