package cz.cuni.pogamut.posh.widget.structure;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptTA2AP;
import cz.cuni.pogamut.posh.widget.menuactions.AddTA2AP;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author Honza
 */
public class StrAPWidget extends StrBasicWidget<ActionPattern> {

	public StrAPWidget(PoshScene poshScene, ActionPattern dataNode, PoshWidget parent) {
		super(poshScene, dataNode, parent);
	}

	@Override
	protected List<AbstractMenuAction> createMenuActions() {
		LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

		list.add(new AddTA2AP(getDataNode()));

		// add delete action, if at least one action is available
		int numTAs = getDataNode().getParent().getNumberOfChildInstances(TriggeredAction.class);

		if (numTAs > 1) {
			list.add(new DeleteNodeAction(
				"Delete action", getDataNode()));
		}

		return list;
	}

	@Override
	protected void addChildWidget(PoshElement dataNode) {
		this.synchronizeDataNodeWidgets(dataNode);
	}

	@Override
	protected List<AbstractAcceptAction> getAcceptProviders() {
		List<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();

		// accept new action to AP, add to the end
		list.add(new AcceptTA2AP(getDataNode()));
		// todo: add AP to move up and down

		return list;
	}

	@Override
	protected PoshNodeType getType() {
		return PoshNodeType.ACTION_PATTERN;
	}

        @Override
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(ActionPattern.apName)) {
			this.setHeadlineText((String) evt.getNewValue());
		}
	}

}
