package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.Freq.FreqUnits;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AcceptDrive2Drive;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.Node.Property;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

/**
 * This is representation of DrivePriorityElement, but it has appearance of DriveElement
 * to save screen space, because we allow only one DriveElement in DrivePriorityElement for now.
 *
 * Basically this widget is representing DrivePriorityElement and if the DrivePriorityElement has DriveElement
 * child, this widget represents it too.
 *
 * @author Honza
 */
class SimpleDriveWidget extends SimpleBasicWidget<DrivePriorityElement> {

    private DriveElement driveElement;

    SimpleDriveWidget(PoshScene scene, DrivePriorityElement associatedDataNode, PoshWidget parent) {
        super(scene, associatedDataNode, parent);
    }

    /**
     * Inplace editor for changing the name of driveelement
     */
    private static class DriveElementInplaceEditor implements TextFieldInplaceEditor {
        private DriveElement de;
        private DriveElementInplaceEditor(DriveElement de) {
            this.de = de;
        }

        @Override
        public boolean isEnabled(Widget widget) {
            return true;
        }

        @Override
        public String getText(Widget widget) {
            return de.getDisplayName();
        }

        @Override
        public void setText(Widget widget, String newDEName) {
            de.setDriveName(newDEName);
        }
    }

    /**
     * Because this Widget is representing two nodes at same time,
     * and the one with interesting properties is not the associated node
     * I have to use special function that returns associted data node, but
     * only if driveelement is not present.
     *
     * @return DriveElement is available, otherwise DrivePriorityElement
     */
    @Override
    protected PropertyNode createPropertiesNode() {
        PoshElement element = getDataNode();
        if (driveElement != null) {
            element = driveElement;
        }
        return new PropertyNode(element, this);
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.DRIVE_ELEMENT;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

        // if more than one drive present, allow deletion
        int numDrives = getDataNode().getParent().getNumberOfChildInstances(DrivePriorityElement.class);

        if (numDrives > 1) {
            list.add(new DeleteNodeAction(
                    "Delete drive", getDataNode()));
        }
        return list;
    }

    /**
     * Create proper child widget of this widget from child data node.
     *
     * @param dataNode DataNode that was added as child
     *                 to associated data node
     */
    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof DriveElement) {
            assert driveElement == null;

            driveElement = (DriveElement) dataNode;
            dataNode.addPoshTreeChangeListener(this);
            this.setHeadlineText(dataNode.getDisplayName());

            getActions().addAction(ActionFactory.createInplaceEditorAction(
                    new DriveElementInplaceEditor(driveElement)));
            
        } else if (dataNode instanceof Triggers) {
            SimpleTriggersWidget triggersWidget = new SimpleTriggersWidget(getPoshScene(), dataNode, this);

            this.getChildNodes().add(triggersWidget);
            this.getPoshScene().addPoshWidget(triggersWidget, true);
        } else if (dataNode instanceof TriggeredAction) {
//			System.out.println(" + Drive " + this.getName() + " got new child: " + dataNode.getClass().getName());
            // TriggeredAction can be either act, AP or competence
            addTriggeredActionWidgets((TriggeredAction) dataNode);
        } else {
            throw new RuntimeException(
                    "Drive "
                    + this.getName()
                    + " got new child: "
                    + dataNode.getClass().getName()
                    + " but no such class accepted.");
        }

    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(DriveElement.deName)) {
            this.setHeadlineText((String) evt.getNewValue());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        List<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();

        list.add(new AcceptDrive2Drive(getDataNode()));

        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);

        try {
            Node.Property nameProp = new PropertySupport.Reflection<String>(driveElement, String.class, "getDriveName", "setDriveName");
            Node.Property freqNumProp = new PropertySupport.Reflection<Double>(driveElement, Double.class, "getFreqNum", "setFreqNum");
            //PropertySupport.Reflection freqUnitsProp = new PropertySupport.Reflection(this, FreqUnits.class, "getFreqUnits", "setFreqUnits");
            Node.Property freqUnitsProp = new PropertySupport.Reflection<Integer>(driveElement, Integer.class, "getFreqUnits", "setFreqUnits");
            Node.Property commentProp = new PropertySupport.Reflection<String>(driveElement, String.class, "getComment", "setComment");


            int[] intValues = new int[FreqUnits.values().length];
            String[] stringKeys = new String[FreqUnits.values().length];

            int index = 0;
            for (FreqUnits unit : FreqUnits.values()) {
                intValues[index] = unit.getId();
                stringKeys[index] = unit.toString();
                index++;
            }

            freqUnitsProp.setValue("intValues", intValues);
            freqUnitsProp.setValue("stringKeys", stringKeys);

            nameProp.setName(DriveElement.deName);
            freqNumProp.setName(DriveElement.deFreqNum);
            freqUnitsProp.setName(DriveElement.deFreqUnits);
            commentProp.setName(DriveElement.deComment);

            nameProp.setDisplayName("Name of drive element");
            freqNumProp.setDisplayName("Frequency ammount");
            freqUnitsProp.setDisplayName("Units of frequency");
            commentProp.setDisplayName("Comment");
            // try to use custom editor for frequency
            //freqUnitsProp.setPropertyEditorClass(FreqUnitsEditor.class);

            set.put(new Property[]{nameProp, freqNumProp, freqUnitsProp, commentProp});
        } catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace(ex);
        }
        return sheet;
    }
}
