package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 *
 * @author Honza
 */
public abstract class AbstractMenuAction<T extends PoshElement> extends AbstractAction {

	protected T dataNode;
	protected PoshWidget widget;

	public AbstractMenuAction(String desc, T dataNode, PoshWidget widget) {
		this.setDescription(desc);
		this.dataNode = dataNode;
		this.widget = widget;
	}

	public AbstractMenuAction(String desc, PoshElement dataNode) {
		this(desc, (T) dataNode, null);
	}

	public String getDescription() {
		return (String) this.getValue(Action.LONG_DESCRIPTION);
	}

	protected void setDescription(String newDesc) {
		this.putValue(Action.LONG_DESCRIPTION, newDesc);
	}

	protected String getIdentifierFromDialog(String purposeTitle) {
		NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine("Please write new identifiew. Name cannot have whitespaces in it.", purposeTitle);
		DialogDisplayer.getDefault().notify(desc);

		if (desc.getValue() != NotifyDescriptor.OK_OPTION) {
			return null;
		}
		if (!Pattern.compile("[a-zA-Z0-9_-]+").matcher(desc.getInputText().trim()).matches()) {
			DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message("Identifier wasn't valid."));
			return null;
		}
		return desc.getInputText().trim();
	}
	
}

