package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 * What to do when sense is dropped onto the goal: add sense to end of
 * list of goal senses.
 * @author havlj3am
 */
public class AcceptSense2Goal extends AbstractAcceptAction<Goal> {

    public AcceptSense2Goal(Goal dataNode) {
        super(Sense.dataFlavor, dataNode);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        Sense sense = (Sense) tr.getTransferData(dataFlavor);
        if (sense == null) {
            return;
        }
        this.dataNode.addUserSense(sense);
    }
}
