package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 * What to do when drive is dropped on drive collection node.
 * Add new drive as last child.
 * @author Honza
 */
public class AcceptDrive2DC extends AbstractAcceptAction<DriveCollection> {

    public AcceptDrive2DC(DriveCollection dataNode) {
        super(DrivePriorityElement.dataFlavor, dataNode);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        DrivePriorityElement drive = (DrivePriorityElement) tr.getTransferData(dataFlavor);
        if (drive == null) {
            return;
        }
        this.dataNode.addDrivePriorityElement(drive);
    }
}
