package cz.cuni.pogamut.posh.view;

import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.PoshEditorSupport;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.structure.StrRootWidget;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/**
 * Posh structure view element.
 * @author Honza
 */
public class StructureEditor implements MultiViewElement {
    private PoshEditorSupport support;
    private PoshScene scene;
    private JScrollPane scrollPane;
    private JToolBar toolbar;

    public StructureEditor(PoshEditorSupport support) {
        this.support = support;
        scene = new PoshScene();
        scrollPane = new JScrollPane();
        scrollPane.setViewportView(scene.createView());
    }

    /**
     * Take the scene and clear all widgets alongside with listeners.
     * Take passed posh plan and create new plan widget tree that will
     * represent it.
     * @param plan Root of new plan.
     */
    public void refresh(PoshPlan plan) {
        scene.clearPoshWidgets();
        scene.setRootWidget(new StrRootWidget(scene, plan, null));
        plan.emitTree();
    }

    @Override
    public JComponent getVisualRepresentation() {
        return scrollPane;
    }

    @Override
    public JComponent getToolbarRepresentation() {
        if (toolbar == null) {
            toolbar = new JToolBar();
        }
        return toolbar;
    }

    @Override
    public Action[] getActions() {
        return support.getDataObject().getNodeDelegate().getActions(false);
    }

    @Override
    public Lookup getLookup() {
        return support.getDataObject().getNodeDelegate().getLookup();
    }

    @Override
    public void componentOpened() {
    }

    @Override
    public void componentClosed() {
    }

    @Override
    public void componentShowing() {
        try {
            PoshParser parser = new PoshParser(support.getInputStream());
            refresh(parser.parsePlan());
        } catch (ParseException ex) {
            Exceptions.printStackTrace(ex);
        } catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    @Override
    public void componentHidden() {
    }

    @Override
    public void componentActivated() {
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public UndoRedo getUndoRedo() {
        return null;
    }

    @Override
    public void setMultiViewCallback(MultiViewElementCallback mvec) {
    }

    @Override
    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }
}