package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.nodes.Children;
import org.openide.util.datatransfer.ExTransferable;

/**
 * Representation of "Add sense" node in palette.
 * 
 * @author Honza
 */
class AddSenseActionNode extends PoshPaletteNode {

//	public final static DataFlavor dataFlavor = new DataFlavor(AddSenseActionNode.class, "add-sense");
	static int num = 10;

	AddSenseActionNode() {
		super(Children.LEAF);

		this.setName("(fail)");
		this.setDisplayName("Sense");
	}

	/**
	 * Create a transferable that will (when asked for data)
	 * ask for name of new sense, crates the sense and returns it.
	 *
	 * If user refuses to fill in name, new sense will be null.
	 *
	 * @return Transferable that will create a new sense.
	 */
	@Override
	protected ExTransferable.Single createTransferable() {
		return new ExTransferable.Single(Sense.dataFlavor) {

			@Override
			protected Object getData() throws IOException, UnsupportedFlavorException {
				String id = PGSupport.getIdentifierFromDialog("Name of sense");
				if (id == null) 
					return null;
				
				return new Sense(id);
			}
		};
	}

}

