/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.pogamut.posh;

import cz.cuni.pogamut.posh.view.KidViewElemDesc;
import cz.cuni.pogamut.posh.view.PoshTextView;
import java.io.IOException;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableTopComponent;

/**
 * Support for associating an editor and a Swing Document to a data object.
 * 
 * @author Honza
 */
public class PoshEditorSupport extends DataEditorSupport
        implements OpenCookie, EditorCookie, EditCookie, EditorCookie.Observable {
    private CloneableTopComponent tc;

    private MultiViewDescription[] descriptions = new MultiViewDescription[] {
        new KidViewElemDesc(this),
//        new StructureDesc(this),
        new PoshTextView(this)
    };

    public PoshEditorSupport(PoshDataObject dataObj) {
        super(dataObj, new PoshEnv(dataObj));
    }

    @Override
    protected CloneableTopComponent createCloneableTopComponent() {
        // create TC with MVs
        tc = MultiViewFactory.createCloneableMultiView(descriptions, descriptions[0]);

        tc.setDisplayName(getDataObject().getPrimaryFile().getNameExt());

        return tc;
    }

    @Override
    protected boolean notifyModified() {
        boolean retValue = super.notifyModified();
        
        if (retValue) {
            PoshDataObject obj = (PoshDataObject)getDataObject();
            obj.ic.add(env);
        }
        return retValue;
    }

    public void setModified() throws IOException {
        env.markModified();
        this.updateTitles();
    }

    @Override
    protected void notifyUnmodified() {
        super.notifyUnmodified();

        PoshDataObject obj = (PoshDataObject)getDataObject();
        obj.ic.remove(env);
    }
}
