/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MyPathRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MyRunStraight
implements IUT2004RunStraight {
    public static final int CLOSE_ENOUGH = 50;
    public static final double AT_PLAYER = 100.0;
    public static final double AT_NAVPOINT = 50.0;
    public static final double MAX_ANGLE = 0.7853981633974483;
    protected UT2004Bot bot;
    protected AgentInfo info;
    protected IUT2004PathRunner runner;
    protected boolean executing;
    protected LogCategory log;
    protected IWorldEventListener<EndMessage> endListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            MyRunStraight.this.runStraight();
        }
    };
    protected List<IStuckDetector> stuckDetectors = new ArrayList<IStuckDetector>();
    protected Location initialLocation;
    protected ILocated currentTarget;
    protected boolean success;
    protected boolean failed;
    protected ILocated lastTarget;
    protected ILocated focus;

    public MyRunStraight(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.info = info;
        this.runner = new MyPathRunner(bot, info, move, (Logger)this.log);
        this.stuckDetectors.add((IStuckDetector)new UT2004TimeStuckDetector(bot, 3000.0, 10000.0));
        this.stuckDetectors.add((IStuckDetector)new UT2004PositionStuckDetector(bot));
        this.stuckDetectors.add((IStuckDetector)new UT2004DistanceStuckDetector(bot));
        bot.getWorldView().addEventListener(EndMessage.class, this.endListener);
    }

    public MyRunStraight(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move, LogCategory log) {
        this(bot, info, move);
        this.log = log;
    }

    public void addStuckDetector(IStuckDetector stuckDetector) {
        this.stuckDetectors.add(stuckDetector);
    }

    public void removeStuckDetector(IStuckDetector stuckDetector) {
        this.stuckDetectors.remove(stuckDetector);
    }

    public void clearStuckDetectors() {
        this.stuckDetectors.clear();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public ILocated getLastTarget() {
        return this.lastTarget;
    }

    public ILocated getCurrentTarget() {
        return this.currentTarget;
    }

    public void setFocus(ILocated focus) {
        this.focus = focus;
    }

    public void runStraight(ILocated target) {
        if (this.executing && this.currentTarget != null && this.currentTarget.getLocation().equals((Object)target.getLocation())) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Run straight to: " + target);
        }
        this.reset();
        this.initialLocation = this.info.getLocation();
        this.currentTarget = target;
        for (IStuckDetector stuckDetector : this.stuckDetectors) {
            stuckDetector.reset();
            stuckDetector.setEnabled(true);
            stuckDetector.setBotTarget(target);
        }
        this.executing = true;
        this.runStraight();
    }

    public void stop(boolean stopMovement) {
        if (!this.executing) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("STOPPED");
        }
        this.reset();
        if (stopMovement) {
            this.bot.getAct().act((CommandMessage)new Stop());
        }
        for (IStuckDetector stuckDetector : this.stuckDetectors) {
            stuckDetector.setEnabled(false);
        }
    }

    protected void reset() {
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("Reset");
        }
        if (this.currentTarget != null) {
            this.lastTarget = this.currentTarget;
        }
        this.initialLocation = null;
        this.currentTarget = null;
        this.success = false;
        this.failed = false;
        this.executing = false;
        this.runner.reset();
    }

    protected void runStraight() {
        if (!this.executing) {
            return;
        }
        for (IStuckDetector stuckDetector : this.stuckDetectors) {
            if (!stuckDetector.isStuck()) continue;
            this.stuck();
            return;
        }
        double distance = this.bot.getLocation().getDistance(this.currentTarget.getLocation());
        if (this.currentTarget instanceof Player) {
            if (distance < 100.0) {
                this.success();
                return;
            }
        } else if (distance < 50.0) {
            this.success();
            return;
        }
        double hDistance = this.bot.getLocation().getDistance2D(this.currentTarget.getLocation());
        double vDistance = this.bot.getLocation().getDistanceZ(this.currentTarget.getLocation());
        double angle = Math.atan(Math.abs(vDistance) / hDistance);
        if (!this.runner.runToLocation(this.initialLocation, this.currentTarget.getLocation(), null, this.focus == null ? this.currentTarget : this.focus, null, angle < 0.7853981633974483)) {
            this.stuck();
            return;
        }
    }

    protected void success() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Target reached.");
        }
        this.stop(false);
        this.success = true;
    }

    protected void stuck() {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Running failed.");
        }
        this.stop(true);
        this.failed = true;
    }
}

