/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.examples.hunterbot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HearNoise;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weapon;
import cz.cuni.amis.pogamut.ut3.bot.impl.UT3BotModuleController;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MapTweaks;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MyGetBackToNavGraph;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MyNavigation;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MyPathExecutor;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MyPathNavigator;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MyPathRunner;
import cz.cuni.amis.pogamut.ut3.examples.hunterbot.navigation.MyRunStraight;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public class UT3HunterBot
extends UT3BotModuleController<UT2004Bot> {
    private UT2004PathAutoFixer autoFixer;
    private LogCategory navigationLog;
    private TabooSet<NavPoint> tabooNavPoints;
    private NavPoint targetNavPoint;

    public void prepareBot(UT2004Bot bot) {
        this.navigationLog = bot.getLogger().getCategory("NAVIGATION");
        this.runStraight = new MyRunStraight(bot, this.info, this.move, this.navigationLog);
        this.pathExecutor = new MyPathExecutor(bot, new MyPathNavigator(bot, new MyPathRunner(bot, this.info, this.move, (Logger)this.navigationLog), (Logger)this.navigationLog), (Logger)this.navigationLog);
        this.navigation = new MyNavigation(bot, this.pathExecutor, (IPathPlanner<NavPoint>)this.fwMap, (IUT2004GetBackToNavGraph)new MyGetBackToNavGraph(bot, this.info, this.move, this.navigationLog), (IUT2004RunStraight)new MyRunStraight(bot, this.info, this.move, this.navigationLog), this.navigationLog);
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(bot, 3000.0, 10000.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionStuckDetector(bot));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004DistanceStuckDetector(bot));
        this.initWeaponPreferences();
    }

    private void initWeaponPreferences() {
        this.weaponPrefs.addGeneralPref(UT3ItemType.STINGER_MINIGUN, false);
        this.weaponPrefs.addGeneralPref(UT3ItemType.LINK_GUN, true);
        this.weaponPrefs.addGeneralPref(UT3ItemType.SNIPER_RIFLE, true);
        this.weaponPrefs.addGeneralPref(UT3ItemType.SHOCK_RIFLE, true);
        this.weaponPrefs.addGeneralPref(UT3ItemType.ROCKET_LAUNCHER, true);
        this.weaponPrefs.addGeneralPref(UT3ItemType.LINK_GUN, true);
        this.weaponPrefs.addGeneralPref(UT3ItemType.ENFORCER, true);
        this.weaponPrefs.addGeneralPref(UT3ItemType.FLAK_CANNON, false);
        this.weaponPrefs.addGeneralPref(UT3ItemType.FLAK_CANNON, true);
        this.weaponPrefs.addGeneralPref(UT3ItemType.BIO_RIFLE, true);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("UT3HunterBot").setDesiredSkill(Integer.valueOf(5));
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        this.tabooNavPoints = new TabooSet(this.bot);
        MapTweaks.tweak(this.navBuilder);
    }

    @EventListener(eventClass=PlayerDamaged.class)
    public void playerDamaged(PlayerDamaged event) {
        UnrealId botHurtId = event.getId();
        if (botHurtId == null) {
            return;
        }
        int damage = event.getDamage();
        Player botHurt = (Player)this.world.get((WorldObjectId)botHurtId);
        this.log.info("OTHER HURT: " + damage + " DMG to " + botHurtId.getStringId() + " [type=" + event.getDamageType() + ", weapon=" + event.getWeaponName() + "]");
    }

    @EventListener(eventClass=BotDamaged.class)
    public void botDamaged(BotDamaged event) {
        int damage = event.getDamage();
        if (event.getInstigator() == null) {
            this.log.info("HURT: " + damage + " DMG done to ME [type=" + event.getDamageType() + ", weapon=" + event.getWeaponName() + "] by UNKNOWN");
        } else {
            UnrealId whoCauseDmgId = event.getInstigator();
            Player player = (Player)this.world.get((WorldObjectId)whoCauseDmgId);
            this.log.info("HURT: " + damage + " DMG done to ME [type=" + event.getDamageType() + ", weapon=" + event.getWeaponName() + "] by " + whoCauseDmgId.getStringId());
        }
    }

    @EventListener(eventClass=PlayerKilled.class)
    public void playerKilled(PlayerKilled event) {
        UnrealId botDiedId = event.getId();
        if (botDiedId == null) {
            return;
        }
        Player botDied = (Player)this.world.get((WorldObjectId)botDiedId);
        if (event.getKiller() == null) {
            this.log.info("OTHER DIED: " + botDiedId.getStringId() + ", UNKNOWN killer");
        } else {
            UnrealId killerId = event.getKiller();
            if (killerId.equals((Object)this.info.getId())) {
                this.log.info("OTHER KILLED: " + botDiedId.getStringId() + " by ME");
            } else {
                Player killer = (Player)this.world.get((WorldObjectId)killerId);
                if (botDiedId.equals((Object)killerId)) {
                    this.log.info("OTHER WAS KILLED: " + botDiedId.getStringId() + " comitted suicide");
                } else {
                    this.log.info("OTHER WAS KILLED: " + botDiedId.getStringId() + " by " + killerId.getStringId());
                }
            }
        }
    }

    public void botKilled(BotKilled event) {
        if (event.getKiller() == null) {
            this.log.info("DEAD");
        } else {
            UnrealId killerId = event.getKiller();
            Player killer = (Player)this.world.get((WorldObjectId)killerId);
            this.log.info("KILLED by" + killerId.getStringId());
        }
    }

    @EventListener(eventClass=Spawn.class)
    public void botSpawned(Spawn event) {
        this.log.info("SPAWNED");
    }

    @EventListener(eventClass=HearNoise.class)
    public void hearNoise(HearNoise event) {
        double noiseDistance = event.getDistance();
        Rotation faceRotation = event.getRotation();
        this.log.info("HEAR NOISE: distance = " + noiseDistance);
    }

    @EventListener(eventClass=ItemPickedUp.class)
    public void itemPickedUp(ItemPickedUp event) {
        UT3ItemType itemType = UT3ItemType.getUT3ItemType(event.getType());
        UT3ItemType.Category itemCategory = itemType.getCategory();
        this.log.info("PICKED " + itemCategory.name + ": " + itemType.getName());
        switch (itemCategory) {
            case AMMO: {
                break;
            }
            case ARMOR: {
                break;
            }
            case HEALTH: {
                break;
            }
            case SHIELD: {
                break;
            }
            case WEAPON: {
                break;
            }
        }
    }

    @ObjectClassEventListener(objectClass=IncomingProjectile.class, eventClass=WorldObjectAppearedEvent.class)
    public void incomingProjectileAppeared(WorldObjectAppearedEvent<IncomingProjectile> event) {
        IncomingProjectile projectile = (IncomingProjectile)event.getObject();
        this.log.info("PROJECTILE APPEARED: " + projectile);
    }

    @ObjectClassEventListener(objectClass=IncomingProjectile.class, eventClass=WorldObjectUpdatedEvent.class)
    public void incomingProjectileUpdated(WorldObjectUpdatedEvent<IncomingProjectile> event) {
        IncomingProjectile projectile = (IncomingProjectile)event.getObject();
        this.log.info("PROJECTILE UPDATED: " + projectile);
    }

    @ObjectClassEventListener(objectClass=IncomingProjectile.class, eventClass=WorldObjectDisappearedEvent.class)
    public void incomingProjectileDisappeared(WorldObjectDisappearedEvent<IncomingProjectile> event) {
        IncomingProjectile projectile = (IncomingProjectile)event.getObject();
        this.log.info("PROJECTILE DISAPPEARED: " + projectile);
    }

    @ObjectClassEventListener(objectClass=Player.class, eventClass=WorldObjectAppearedEvent.class)
    public void playerAppeared(WorldObjectAppearedEvent<Player> event) {
        Player player = (Player)event.getObject();
        this.log.info("PLAYER APPEARED: " + player.getId().getStringId());
    }

    @ObjectClassEventListener(objectClass=Player.class, eventClass=WorldObjectUpdatedEvent.class)
    public void playerUpdated(WorldObjectUpdatedEvent<Player> event) {
        if (this.info.getLocation() == null) {
            return;
        }
        Player player = (Player)event.getObject();
        this.log.info("PLAYER UPDATED: " + player.getId().getStringId());
    }

    @ObjectClassEventListener(objectClass=Player.class, eventClass=WorldObjectDisappearedEvent.class)
    public void playerDisappeared(WorldObjectDisappearedEvent<Player> event) {
        Player player = (Player)event.getObject();
        this.log.info("PLAYER DISAPPEARED: " + player.getId().getStringId());
    }

    @ObjectClassEventListener(objectClass=Item.class, eventClass=WorldObjectAppearedEvent.class)
    public void itemAppeared(WorldObjectAppearedEvent<Item> event) {
        Item item = (Item)event.getObject();
        this.log.info("ITEM APPEARED: " + item.getId().getStringId());
    }

    @ObjectClassEventListener(objectClass=Item.class, eventClass=WorldObjectUpdatedEvent.class)
    public void itemUpdated(WorldObjectUpdatedEvent<Item> event) {
        if (this.info.getLocation() == null) {
            return;
        }
        Item item = (Item)event.getObject();
        this.log.info("ITEM UPDATED: " + item.getId().getStringId());
    }

    @ObjectClassEventListener(objectClass=Item.class, eventClass=WorldObjectDisappearedEvent.class)
    public void itemDisappeared(WorldObjectDisappearedEvent<Item> event) {
        Item item = (Item)event.getObject();
        this.log.info("ITEM DISAPPEARED: " + item.getId().getStringId());
    }

    public void beforeFirstLogic() {
        this.log.setLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logic() {
        long logicStartTime = System.currentTimeMillis();
        try {
            this.log.info("=========================");
            this.log.info("===[ LOGIC ITERATION ]===");
            this.log.info("=========================");
            this.logMind();
            this.log.info("---[ ACTION-SELECTION ]---");
            if (this.players.canSeePlayers()) {
                Player player = this.players.getNearestVisiblePlayer();
                this.log.info("DECISION: SHOOTING AT " + player.getId().getStringId());
                this.shoot.shoot(this.weaponPrefs, (ILocated)player, new UT3ItemType[0]);
                this.log.info("DECISION: face player " + player.getId().getStringId());
                this.navigation.setFocus((ILocated)player);
            } else if (this.info.isShooting().booleanValue()) {
                this.log.info("DECISION: STOP SHOOTING");
                this.shoot.stopShooting();
                this.log.info("DECISION: set focus to path");
                this.navigation.setFocus(null);
            }
            if (this.navigation.isNavigating()) {
                while (this.navigation.getContinueTo() == null && this.navigation.getRemainingDistance() < 400.0) {
                    this.navigation.setContinueTo((ILocated)this.getRandomNavPoint());
                }
                return;
            }
            this.targetNavPoint = this.getRandomNavPoint();
            if (this.targetNavPoint == null) {
                this.log.severe("COULD NOT CHOOSE ANY NAVIGATION POINT TO RUN TO!!!");
                if (this.world.getAll(NavPoint.class).size() == 0) {
                    this.log.severe("world.getAll(NavPoint.class).size() == 0, there are no navigation ponits to choose from! Is exporting of nav points enabled in GameBots2004.ini inside UT2004?");
                }
                return;
            }
            this.tabooNavPoints.add((Object)this.targetNavPoint, 120.0);
            this.log.info("DECISION: RUNNING TO " + this.targetNavPoint.getId().getStringId());
            this.navigation.navigate((ILocated)this.targetNavPoint);
        }
        catch (Exception e) {
            this.log.info(ExceptionToString.process((Throwable)e));
        }
        finally {
            long timeSpentInLogic = System.currentTimeMillis() - logicStartTime;
            this.log.info("Logic time: " + timeSpentInLogic + " ms");
            if (timeSpentInLogic >= 250L) {
                this.log.warning("!!! LOGIC TOO DEMANDING !!!");
            }
            this.log.info("---[ END ] ---");
        }
    }

    public NavPoint getRandomNavPoint() {
        this.log.info("DECISION: Picking new target navpoint.");
        NavPoint chosen = (NavPoint)MyCollections.getRandomFiltered(this.getWorldView().getAll(NavPoint.class).values(), this.tabooNavPoints);
        if (chosen != null) {
            return chosen;
        }
        this.log.warning("DECISION: All navpoints are tabooized at this moment, choosing navpoint randomly!");
        return (NavPoint)MyCollections.getRandom(this.getWorldView().getAll(NavPoint.class).values());
    }

    public void logMind() {
        this.log.info("---[ AGENT ]---");
        this.log.info("My location:    " + this.info.getLocation());
        this.log.info("Looking to:     " + this.info.getRotation().toLocation());
        this.log.info("My health:      " + this.info.getHealth());
        this.log.info("My armor:       " + this.info.getArmor() + " (low:" + this.info.getLowArmor() + " / high:" + this.info.getHighArmor() + ")");
        this.log.info("My weapon:      " + this.weaponry.getCurrentWeapon());
        this.log.info("---[ WEAPONS ]---");
        for (UT3Weapon weap : this.weaponry.getRangedWeapons().values()) {
            this.log.info(weap.getType() + " ammo " + this.weaponry.getAmmo(weap.getType()) + " (max: " + this.weaponry.getMaxAmmo(weap.getType()) + ")");
        }
        this.log.info("---[ ITEMS IN THE MAP ]---");
        Map<UT3ItemType, List<Item>> nearestItems = this.getNearestPossiblySpawnedItemsMap();
        ArrayList<UT3ItemType> keys = new ArrayList<UT3ItemType>(nearestItems.keySet());
        Collections.sort(keys);
        for (UT3ItemType key : keys) {
            List<Item> items = nearestItems.get(key);
            if (items.size() == 0) continue;
            Item item = items.get(0);
            this.log.info(String.format("Nearest %-30s: %-45s / %f", key.getName(), item.getId().getStringId(), Float.valueOf(this.fwMap.getDistance(this.info.getNearestNavPoint(), item.getNavPoint()))));
        }
    }

    public boolean isPossiblySpawned(Item item) {
        return this.items.isPickupSpawned(item);
    }

    public boolean isCurrentlyPickable(Item item) {
        return this.isPossiblySpawned(item) && this.items.isPickable(item);
    }

    public Item getRandomPossiblySpawnedItemOfType(UT3ItemType type) {
        return (Item)MyCollections.getRandom(this.items.getSpawnedItems(type).values());
    }

    public Item getRandomPossiblySpawnedItemOfCategory(UT3ItemType.Category category) {
        return (Item)MyCollections.getRandom(this.items.getSpawnedItems(category).values());
    }

    public Item getRandomPossiblySpawnedWeapon() {
        return this.getRandomPossiblySpawnedItemOfCategory(UT3ItemType.Category.WEAPON);
    }

    public Item getRandomPossiblySpawnedHealth() {
        return this.getRandomPossiblySpawnedItemOfCategory(UT3ItemType.Category.HEALTH);
    }

    public Item getRandomPossiblySpawnedArmor() {
        return this.getRandomPossiblySpawnedItemOfCategory(UT3ItemType.Category.ARMOR);
    }

    public Item getRandomPossiblySpawnedAmmoForWeapon(final UT3ItemType weapon) {
        return (Item)MyCollections.getRandomFiltered(this.items.getSpawnedItems(UT3ItemType.Category.AMMO).values(), (IFilter)new IFilter<Item>(){

            public boolean isAccepted(Item object) {
                UT3ItemType itemType = UT3ItemType.getUT3ItemType(object.getType());
                if (itemType.getCategory() != UT3ItemType.Category.AMMO) {
                    return false;
                }
                return UT3ItemType.getAmmoForWeapon(weapon) == itemType;
            }
        });
    }

    public Map<UT3ItemType, List<Item>> getNearestPossiblySpawnedItemsMap() {
        final NavPoint nearestNavPoint = this.info.getNearestNavPoint();
        List itemsDistanceSortedAscending = DistanceUtils.getDistanceSorted(this.items.getSpawnedItems().values(), (ILocated)this.info.getLocation(), (DistanceUtils.IGetDistance)new DistanceUtils.IGetDistance<Item>(){

            public double getDistance(Item object, ILocated target) {
                return UT3HunterBot.this.fwMap.getDistance(nearestNavPoint, object.getNavPoint());
            }
        });
        LazyMap<UT3ItemType, List<Item>> result = new LazyMap<UT3ItemType, List<Item>>(){

            public List<Item> create(UT3ItemType key) {
                return new ArrayList<Item>();
            }
        };
        for (Item item : itemsDistanceSortedAscending) {
            UT3ItemType itemType = UT3ItemType.getUT3ItemType(item.getType());
            ((List)result.get(itemType)).add(item);
        }
        return result;
    }

    public Item getNearestPossiblySpawnedItemOfType(UT3ItemType type) {
        final NavPoint nearestNavPoint = this.info.getNearestNavPoint();
        List itemsDistanceSortedAscending = DistanceUtils.getDistanceSorted(this.items.getSpawnedItems(type).values(), (ILocated)this.info.getLocation(), (DistanceUtils.IGetDistance)new DistanceUtils.IGetDistance<Item>(){

            public double getDistance(Item object, ILocated target) {
                return UT3HunterBot.this.fwMap.getDistance(nearestNavPoint, object.getNavPoint());
            }
        });
        if (itemsDistanceSortedAscending.size() == 0) {
            return null;
        }
        return (Item)itemsDistanceSortedAscending.get(0);
    }

    public Item getNearestPossiblySpawnedItemOfCategory(UT3ItemType.Category category) {
        final NavPoint nearestNavPoint = this.info.getNearestNavPoint();
        List itemsDistanceSortedAscending = DistanceUtils.getDistanceSorted(this.items.getSpawnedItems(category).values(), (ILocated)this.info.getLocation(), (DistanceUtils.IGetDistance)new DistanceUtils.IGetDistance<Item>(){

            public double getDistance(Item object, ILocated target) {
                return UT3HunterBot.this.fwMap.getDistance(nearestNavPoint, object.getNavPoint());
            }
        });
        if (itemsDistanceSortedAscending.size() == 0) {
            return null;
        }
        return (Item)itemsDistanceSortedAscending.get(0);
    }

    public Item getNearestPossiblySpawnedWeapon() {
        return this.getNearestPossiblySpawnedItemOfCategory(UT3ItemType.Category.WEAPON);
    }

    public Item getNearestPossiblySpawnedHealth() {
        return this.getNearestPossiblySpawnedItemOfCategory(UT3ItemType.Category.HEALTH);
    }

    public Item getNearestPossiblySpawnedArmor() {
        return this.getNearestPossiblySpawnedItemOfCategory(UT3ItemType.Category.ARMOR);
    }

    public Item getNearestPossiblySpawnedAmmoForWeapon(final UT3ItemType weapon) {
        final NavPoint nearestNavPoint = this.info.getNearestNavPoint();
        List ammosForWeaponsDistanceSortedAscending = DistanceUtils.getDistanceSorted(this.items.getSpawnedItems(UT3ItemType.Category.AMMO).values(), (ILocated)this.info.getLocation(), (DistanceUtils.IGetDistance)new DistanceUtils.IGetDistance<Item>(){

            public double getDistance(Item object, ILocated target) {
                return UT3HunterBot.this.fwMap.getDistance(nearestNavPoint, object.getNavPoint());
            }
        }, (DistanceUtils.IDistanceFilter[])new DistanceUtils.IDistanceFilter[]{new DistanceUtils.IDistanceFilter<Item>(){

            public boolean isAccepted(Item object, ILocated target, double distanceToTarget) {
                UT3ItemType itemType = UT3ItemType.getUT3ItemType(object.getType());
                if (itemType.getCategory() != UT3ItemType.Category.AMMO) {
                    return false;
                }
                return UT3ItemType.getAmmoForWeapon(weapon) == itemType;
            }
        }});
        if (ammosForWeaponsDistanceSortedAscending.size() == 0) {
            return null;
        }
        return (Item)ammosForWeaponsDistanceSortedAscending.get(0);
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(UT3HunterBot.class, "UT3HunterBot").setMain(true).setLogLevel(Level.INFO).startAgents(1);
    }
}

