/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.communication.messages;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weapon;
import cz.cuni.amis.utils.maps.HashMapSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class UT3ItemType
implements Serializable,
Comparable<UT3ItemType> {
    public static final HashMapSet<Category, UT3ItemType> CATEGORIES = new HashMapSet();
    public static final HashMapSet<Group, UT3ItemType> GROUPS = new HashMapSet();
    private static HashMap<String, UT3ItemType> protos = new HashMap();
    public static final UT3ItemType TRANSLOCATOR = UT3ItemType.MakePrototype(Category.WEAPON, Group.TRANSLOCATOR, new String[]{"Translocator", "Translocator.WeaponPickup", "UTWeap_Transolcator_Content", "UTWeap_Transolcator"});
    public static final UT3ItemType TRANSLOCATOR_PROJECTILE = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.TRANSLOCATOR, new String[]{"UTProj_TransDisc", "UT_Proj_TransDisc_ContentBlue", "UT_Proj_TransDisc_ContentRed"});
    public static final UT3ItemType IMPACT_HAMMER = UT3ItemType.MakePrototype(Category.WEAPON, Group.IMPACT_HAMMER, new String[]{"ImpactHammer", "ImpactHammer.WeaponPickup", "UTWeap_ImpactHammer"});
    public static final UT3ItemType IMPACT_HAMMER_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.IMPACT_HAMMER, new String[]{"ImpactHammerAmmo", "ImpactHammerAmmo.AmmoPickup"});
    public static final UT3ItemType ENFORCER = UT3ItemType.MakePrototype(Category.WEAPON, Group.ENFORCER, new String[]{"Enforcer", "Enforcer.WeaponPickup", "UTWeap_Enforcer"});
    public static final UT3ItemType ENFORCER_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.ENFORCER, new String[]{"EnforcerAmmo", "EnforcerAmmo.AmmoPickup", "GBAmmo_Enforcer"});
    public static final UT3ItemType BIO_RIFLE = UT3ItemType.MakePrototype(Category.WEAPON, Group.BIO_RIFLE, new String[]{"BioRifle", "BioRifle.WeaponPickup", "UTWeap_BioRifle", "UTWeap_BioRifle_Content"});
    public static final UT3ItemType BIO_RIFLE_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.BIO_RIFLE, new String[]{"BioRifleAmmo", "BioRifleAmmo.AmmoPickup", "GBAmmo_BioRifle", "GBAmmo_BioRifle_Content"});
    public static final UT3ItemType BIO_RIFLE_PROJECTILE = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.BIO_RIFLE, new String[]{"UTProj_BioShot", "UTProj_BioGlob", "UTProj_BioGlobling"});
    public static final UT3ItemType SHOCK_RIFLE = UT3ItemType.MakePrototype(Category.WEAPON, Group.SHOCK_RIFLE, new String[]{"ShockRifle", "ShockRifle.WeaponPickup", "UTWeap_ShockRifle"});
    public static final UT3ItemType SHOCK_RIFLE_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.SHOCK_RIFLE, new String[]{"ShockRifleAmmo", "ShockRifleAmmo.AmmoPickup", "UTAmmo_ShockRifle", "GBAmmo_ShockRifle"});
    public static final UT3ItemType SHOCK_RIFLE_PROJECTILE = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.SHOCK_RIFLE, new String[]{"UTProj_ShockBall", "UTProj_HeroShockBall"});
    public static final UT3ItemType LINK_GUN = UT3ItemType.MakePrototype(Category.WEAPON, Group.LINK_GUN, new String[]{"LinkGun", "LinkGun.WeaponPickup", "UTWeap_LinkGun"});
    public static final UT3ItemType LINK_GUN_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.LINK_GUN, new String[]{"LinkGunAmmo", "LinkGunAmmo.AmmoPickup", "UTAmmo_LinkGun", "GBAmmo_LinkGun"});
    public static final UT3ItemType LINK_GUN_PROJECTILE = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.LINK_GUN, new String[]{"XWeapons.LinkProjectile"});
    public static final UT3ItemType STINGER_MINIGUN = UT3ItemType.MakePrototype(Category.WEAPON, Group.STINGER_MINIGUN, new String[]{"Stinger", "Stinger.WeaponPickup", "UTWeap_Stinger"});
    public static final UT3ItemType STINGER_MINIGUN_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.STINGER_MINIGUN, new String[]{"StingerAmmo", "StingerAmmo.AmmoPickup", "GBAmmo_Stinger", "UTAmmo_Stinger"});
    public static final UT3ItemType STINGER_MINIGUN_SHARD = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.STINGER_MINIGUN, new String[]{"UTProj_StingerShard"});
    public static final UT3ItemType FLAK_CANNON = UT3ItemType.MakePrototype(Category.WEAPON, Group.FLAK_CANNON, new String[]{"FlakCannon", "FlakCannon.WeaponPickup", "UTWeap_FlakCannon"});
    public static final UT3ItemType FLAK_CANNON_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.FLAK_CANNON, new String[]{"FlakCannonAmmo", "FlakCannonAmmo.AmmoPickup", "GBAmmo_FlakCannon", "UTAmmo_FlakCannon"});
    public static final UT3ItemType FLAK_CANNON_CHUNK = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.FLAK_CANNON, new String[]{"UTProj_FlakShard", "UTProj_FlakShardMain"});
    public static final UT3ItemType FLAK_CANNON_SHELL = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.FLAK_CANNON, new String[]{"UTProj_FlakShell"});
    public static final UT3ItemType ROCKET_LAUNCHER = UT3ItemType.MakePrototype(Category.WEAPON, Group.ROCKET_LAUNCHER, new String[]{"RocketLauncher", "RocketLauncher.WeaponPickup", "UTWeap_RocketLauncher"});
    public static final UT3ItemType ROCKET_LAUNCHER_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.ROCKET_LAUNCHER, new String[]{"RocketLauncherAmmo", "RocketLauncherAmmo.AmmoPickup", "GBAmmo_RocketLauncher", "UTAmmo_RocketLauncher"});
    public static final UT3ItemType ROCKET_LAUNCHER_PROJECTILE = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.ROCKET_LAUNCHER, new String[]{"UTProj_Rocket", "UTProj_HeroRocket", "UTProj_LoadedRocket", "UTProj_SeekingRocket"});
    public static final UT3ItemType SNIPER_RIFLE = UT3ItemType.MakePrototype(Category.WEAPON, Group.SNIPER_RIFLE, new String[]{"SniperRifle", "SniperRifle.WeaponPickup", "UTWeap_SniperRifle"});
    public static final UT3ItemType SNIPER_RIFLE_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.SNIPER_RIFLE, new String[]{"SniperRifleAmmo", "SniperRifleAmmo.AmmoPickup", "GBAmmo_SniperRifle", "UTAmmo_SniperRifle"});
    public static final UT3ItemType REDEEMER = UT3ItemType.MakePrototype(Category.WEAPON, Group.REDEEMER, new String[]{"Redeemer", "Redeemer.WeaponPickup", "UTWeap_Redeemer", "UTWeap_Redeemer_Content"});
    public static final UT3ItemType REDEEMER_AMMO = UT3ItemType.MakePrototype(Category.AMMO, Group.REDEEMER, new String[]{"RedeemerAmmo", "RedeemerAmmo.AmmoPickup"});
    public static final UT3ItemType REDEEMER_PROJECTILE = UT3ItemType.MakePrototype(Category.PROJECTILE, Group.REDEEMER, new String[]{"UTProj_Redeemer", "UTProj_RedeemerRed"});
    public static final UT3ItemType MEDIUM_HEALTH = UT3ItemType.MakePrototype(Category.HEALTH, Group.MEDIUM_HEALTH, new String[]{"MediumHealth", "MediumHealth.HealthPickup", "UTHealthPickupFactory", "GBPickupFactory_MeidumHealth"});
    public static final UT3ItemType HEALTH_VIAL = UT3ItemType.MakePrototype(Category.HEALTH, Group.HEALTH_VIAL, new String[]{"HealthVial", "HealthVial.HealthPickup", "UTHealthPickupLight", "GBPickupFactory_HealthVial"});
    public static final UT3ItemType SUPER_HEALTH_PACK = UT3ItemType.MakePrototype(Category.HEALTH, Group.SUPER_HEALTH, new String[]{"SuperHealth", "SuperHealth.HealthPickup", "GBPickupFactory_SuperHealth", "UTPickupFactory_SuperHealth"});
    public static final UT3ItemType ARMOR_HELMET = UT3ItemType.MakePrototype(Category.ARMOR, Group.ARMOR_HELMET, new String[]{"Helmet", "Helmet.ArmorPickup", "GBArmorPickup_Helmet", "UTArmorPickup_Helmet"});
    public static final UT3ItemType ARMOR_SHIELD_BELT = UT3ItemType.MakePrototype(Category.ARMOR, Group.ARMOR_SHIELD_BELT, new String[]{"ShieldBelt", "ShieldBelt.ArmorPickup", "GBArmorPickup_ShieldBelt", "UTArmorPickup_ShieldBelt"});
    public static final UT3ItemType ARMOR_THIGHPADS = UT3ItemType.MakePrototype(Category.ARMOR, Group.ARMOR_THIGHPADS, new String[]{"Thighpads", "Thighpads.ArmorPickup", "GBArmorPickup_Thighpads", "UTArmorPickup_Thighpads"});
    public static final UT3ItemType ARMOR_VEST = UT3ItemType.MakePrototype(Category.ARMOR, Group.ARMOR_VEST, new String[]{"Vest", "Vest.ArmorPickup", "GBArmorPickup_Vest", "UTArmorPickup_Vest"});
    public static final UT3ItemType U_DAMAGE_PACK = UT3ItemType.MakePrototype(Category.OTHER, Group.UDAMAGE, new String[]{"UDamage", "UDamage.Pickup", "UTPickupFactory_UDamage", "UTUDamage"});
    public static final UT3ItemType BERSERK_PACK = UT3ItemType.MakePrototype(Category.OTHER, Group.BERSERK, new String[]{"Berserk", "Berserk.Pickup"});
    public static final UT3ItemType JUMP_BOOTS = UT3ItemType.MakePrototype(Category.OTHER, Group.JUMP_BOOTS, new String[]{"JumpBoots", "JumpBoots.Pickup", "UTPickupFactory_JumpBoots"});
    public static final UT3ItemType KEY = UT3ItemType.MakePrototype(Category.OTHER, Group.KEY, new String[]{"UnrealGame.KeyPickup"});
    public static final UT3ItemType NONE = UT3ItemType.MakePrototype(Category.OTHER, Group.NONE, new String[]{"None", "NONE", "none"});
    private String name;
    private Category category;
    private Group group;
    private UT3ItemType proto;

    public static UT3ItemType getWeaponForAmmo(UT3ItemType itemType) {
        if (itemType == null) {
            return NONE;
        }
        Set mySet = GROUPS.get((Object)itemType.group);
        if (mySet != null) {
            for (UT3ItemType type : mySet) {
                if (type.group != itemType.group || type.category != Category.WEAPON) continue;
                return type;
            }
        }
        return NONE;
    }

    public static UT3ItemType getAmmoForWeapon(UT3ItemType itemType) {
        if (itemType == null) {
            return NONE;
        }
        Set mySet = GROUPS.get((Object)itemType.group);
        if (mySet != null) {
            for (UT3ItemType type : mySet) {
                if (type.group != itemType.group || type.category != Category.AMMO) continue;
                return type;
            }
        }
        return NONE;
    }

    public static UT3ItemType getWeaponItemType(UnrealId id) {
        if (id == null) {
            return null;
        }
        return UT3ItemType.getWeaponItemType(id.getStringId());
    }

    public static UT3ItemType getWeaponItemType(String str) {
        if ((str = str.toLowerCase()).contains("enforcer")) {
            return ENFORCER;
        }
        if (str.contains("impacthammer")) {
            return IMPACT_HAMMER;
        }
        if (str.contains("flakcannon")) {
            return FLAK_CANNON;
        }
        if (str.contains("biorifle")) {
            return BIO_RIFLE;
        }
        if (str.contains("shockrifle")) {
            return SHOCK_RIFLE;
        }
        if (str.contains("linkgun")) {
            return LINK_GUN;
        }
        if (str.contains("sniperrifle")) {
            return SNIPER_RIFLE;
        }
        if (str.contains("rocketlauncher")) {
            return ROCKET_LAUNCHER;
        }
        if (str.contains("minigun")) {
            return STINGER_MINIGUN;
        }
        if (str.contains("translocator")) {
            return TRANSLOCATOR;
        }
        if (str.contains("translauncher")) {
            return TRANSLOCATOR;
        }
        return null;
    }

    public String toString() {
        return "UT3ItemType[name = " + this.name + ", category = " + (Object)((Object)this.category) + ", group = " + (Object)((Object)this.group) + "]";
    }

    public Category getCategory() {
        return this.category == null ? (this.category = this.getProto().category) : this.category;
    }

    public Group getGroup() {
        return this.group == null ? (this.group = this.getProto().group) : this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UT3ItemType getProto() {
        if (this.proto != null) {
            return this.proto;
        }
        HashMap<String, UT3ItemType> hashMap = protos;
        synchronized (hashMap) {
            this.proto = protos.get(this.name);
            return this.proto;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof UT3ItemType && this.getProto() == ((UT3ItemType)obj).getProto();
    }

    public int hashCode() {
        return this.getProto().name.hashCode();
    }

    public UT3ItemType(String name) {
        this.name = name;
        this.category = Category.OTHER;
        this.group = Group.OTHER;
        this.proto = this;
    }

    private UT3ItemType(String name, Category category, Group group) {
        this.name = name;
        this.category = category;
        this.group = group;
        this.proto = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UT3ItemType MakePrototype(Category category, Group group, String[] utNames) {
        UT3ItemType type;
        HashMap<String, UT3ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = new UT3ItemType(utNames[0], category, group);
            for (String utName : utNames) {
                protos.put(utName, type);
            }
            if (category != null) {
                CATEGORIES.get((Object)category).add(type);
            }
            if (group != null) {
                GROUPS.get((Object)group).add(type);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UT3ItemType getUT3ItemTypeFromId(UnrealId utId) {
        UT3ItemType type;
        String utName = utId.getStringId();
        if (utName.contains("INV_")) {
            utName = utName.split("INV_", 2)[1];
        }
        if (utName.contains("_")) {
            String[] split = utName.split("_", 3);
            utName = split.length > 2 ? split[0] + "_" + split[1] : split[0];
        }
        HashMap<String, UT3ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = protos.get(utName);
            if (type != null) {
                return type;
            }
            type = new UT3ItemType(utName);
            protos.put(utName, type);
        }
        return type;
    }

    public static UT3ItemType getUT3ItemType(ItemType ut2004ItemType) {
        if (ut2004ItemType == null) {
            return NONE;
        }
        return UT3ItemType.getUT3ItemType(ut2004ItemType.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UT3ItemType getUT3ItemType(String utName) {
        UT3ItemType type;
        HashMap<String, UT3ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = protos.get(utName);
            if (type != null) {
                return type;
            }
            type = new UT3ItemType(utName);
            protos.put(utName, type);
        }
        return type;
    }

    public static UT3ItemType getUT3ItemType(UT3Weapon weapon) {
        return UT3ItemType.getWeaponItemType(weapon.getInventoryId());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(UT3ItemType o) {
        if (o == null) {
            return 1;
        }
        if (this.getName() == null) {
            if (o.getName() == null) {
                return 0;
            }
            return 1;
        }
        if (o.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public static enum Group {
        TRANSLOCATOR("Translocator"),
        IMPACT_HAMMER("ImpactHammer"),
        ENFORCER("Enforcer"),
        BIO_RIFLE("Biorifle"),
        SHOCK_RIFLE("ShockRifle"),
        LINK_GUN("LinkGun"),
        STINGER_MINIGUN("Stinger"),
        FLAK_CANNON("FlakCannon"),
        ROCKET_LAUNCHER("RocketLauncher"),
        SNIPER_RIFLE("SniperRifle"),
        REDEEMER("Redeemer"),
        MEDIUM_HEALTH("MediumHealth"),
        HEALTH_VIAL("HealthVial"),
        SUPER_HEALTH("SuperHealth"),
        ARMOR_HELMET("Helmet"),
        ARMOR_VEST("Vest"),
        ARMOR_THIGHPADS("Thighpads"),
        ARMOR_SHIELD_BELT("ShieldBelt"),
        JUMP_BOOTS("JumpBoots"),
        UDAMAGE("UDamage"),
        BERSERK("Berserk"),
        KEY("Key"),
        OTHER("Unknown"),
        NONE("None");

        public String name;

        private Group(String name) {
            this.name = name;
        }

        public Set<UT3ItemType> getTypes() {
            return GROUPS.get((Object)this);
        }
    }

    public static enum Category {
        WEAPON("Weapon"),
        AMMO("Ammo"),
        PROJECTILE("Projectile"),
        HEALTH("Health"),
        ARMOR("Armor"),
        SHIELD("Shield"),
        OTHER("Other"),
        NONE("No category");

        public final String name;

        private Category(String name) {
            this.name = name;
        }

        public Set<UT3ItemType> getTypes() {
            return CATEGORIES.get((Object)this);
        }
    }
}

