/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.agent.module.sensor;

import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weapon;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.utils.HashCode;
import cz.cuni.amis.utils.NullCheck;

public class UT3WeaponPref {
    private UT3ItemType weapon;
    private boolean primary;
    private int hashCode;

    public UT3WeaponPref(UT3ItemType weapon, boolean primary) {
        this.weapon = weapon;
        this.primary = primary;
        NullCheck.check((Object)this.weapon, (String)"weapon");
        if (weapon.getCategory() != UT3ItemType.Category.WEAPON) {
            throw new IllegalArgumentException("passed 'weapon' is not of UT3ItemType.Category.WEAPON but " + weapon.getCategory().toString());
        }
        this.hashCode = new HashCode().add((Object)weapon).add(primary).getHash();
    }

    public UT3WeaponPref(UT3ItemType weapon) {
        this.weapon = weapon;
        this.primary = true;
        NullCheck.check((Object)this.weapon, (String)"weapon");
        if (weapon.getCategory() != UT3ItemType.Category.WEAPON) {
            throw new IllegalArgumentException("passed 'weapon' is not of UT3ItemType.Category.WEAPON but " + weapon.getCategory().toString());
        }
        this.hashCode = new HashCode().add((Object)weapon).add(this.primary).getHash();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UT3WeaponPref)) {
            return false;
        }
        UT3WeaponPref pref = (UT3WeaponPref)obj;
        return pref.weapon == this.weapon && pref.primary == this.primary;
    }

    public UT3WeaponPref(UT3Weapon weapon, boolean primary) {
        this.weapon = weapon.getType();
        this.primary = primary;
        NullCheck.check((Object)this.weapon, (String)"weapon");
    }

    public UT3ItemType getWeapon() {
        return this.weapon;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isSecondary() {
        return !this.primary;
    }

    public String toString() {
        return "WeaponPref[type=" + this.weapon.getName() + ", " + (this.primary ? "primary mode" : "secondary mode") + "]";
    }
}

