/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weaponry;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

public class UT3Items
extends SensorModule<UT2004Bot> {
    private Random random = new Random(System.currentTimeMillis());
    private ItemMaps items;
    private HashMap<UT3ItemType, ItemCategory> itemTypeToItemCategory = new HashMap();
    protected ItemsListener itemsListener;
    protected MapPointsListener mapPointsListener;
    protected Map<UnrealId, NavPoint> navPoints = new HashMap<UnrealId, NavPoint>();
    protected List<NavPoint> navPointsToProcess = new ArrayList<NavPoint>();
    protected NavPointListener navPointListener;
    protected EndMessageListener endMessageListener;
    protected ItemPickedUpListener itemPickedUpListener;
    protected AgentInfo agentInfo;
    private UT3Weaponry weaponry;
    private Game game;

    public boolean isPickable(Item item) {
        UT3ItemType itemType = UT3ItemType.getUT3ItemType(item.getType());
        if (itemType == UT3ItemType.MEDIUM_HEALTH && this.agentInfo.isHealthy().booleanValue()) {
            return false;
        }
        if (itemType == UT3ItemType.SUPER_HEALTH_PACK && this.agentInfo.isSuperHealthy().booleanValue()) {
            return false;
        }
        if (itemType == UT3ItemType.HEALTH_VIAL && this.agentInfo.isSuperHealthy().booleanValue()) {
            return false;
        }
        if (itemType.getCategory() == UT3ItemType.Category.WEAPON && this.game.getGameInfo().isWeaponStay()) {
            return !this.weaponry.hasWeapon(itemType);
        }
        return itemType != UT3ItemType.U_DAMAGE_PACK || this.agentInfo.hasUDamage() == false;
    }

    public Item getRandomItem() {
        if (this.getAllItems().size() == 0) {
            return null;
        }
        int num = this.random.nextInt(this.getAllItems().size());
        Iterator<Item> iter = this.getAllItems().values().iterator();
        for (int i = 0; i < num - 1; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public Map<UnrealId, Item> getAllItems() {
        return Collections.unmodifiableMap(this.items.all);
    }

    public Map<UnrealId, Item> getAllItems(UT3ItemType type) {
        return Collections.unmodifiableMap(this.items.allCategories.get((Object)type));
    }

    public Map<UnrealId, Item> getAllItems(UT3ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : category.getTypes()) {
            result.putAll(this.getAllItems(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getAllItems(UT3ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : group.getTypes()) {
            result.putAll(this.getAllItems(type));
        }
        return result;
    }

    public Item getItem(UnrealId id) {
        Item item = (Item)this.items.all.get(id);
        if (item == null) {
            item = (Item)this.items.visible.get(id);
        }
        return item;
    }

    public Item getItem(String stringUnrealId) {
        return this.getItem(UnrealId.get((String)stringUnrealId));
    }

    public Map<UnrealId, Item> getVisibleItems() {
        return Collections.unmodifiableMap(this.items.visible);
    }

    public Map<UnrealId, Item> getVisibleItems(UT3ItemType type) {
        return Collections.unmodifiableMap(this.items.visibleCategories.get((Object)type));
    }

    public Map<UnrealId, Item> getVisibleItems(UT3ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : category.getTypes()) {
            result.putAll(this.getVisibleItems(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getVisibleItems(UT3ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : group.getTypes()) {
            result.putAll(this.getVisibleItems(type));
        }
        return result;
    }

    public Item getVisibleItem(UnrealId id) {
        Item item = (Item)this.items.visible.get(id);
        return item;
    }

    public Item getVisibleItem(String stringUnrealId) {
        return this.getVisibleItem(UnrealId.get((String)stringUnrealId));
    }

    public Map<UnrealId, Item> getKnownPickups() {
        return Collections.unmodifiableMap(this.items.known);
    }

    public Map<UnrealId, Item> getKnownPickups(UT3ItemType type) {
        return Collections.unmodifiableMap(this.items.knownCategories.get((Object)type));
    }

    public Map<UnrealId, Item> getKnownPickups(UT3ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : category.getTypes()) {
            result.putAll(this.getKnownPickups(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getKnownPickups(UT3ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : group.getTypes()) {
            result.putAll(this.getKnownPickups(type));
        }
        return result;
    }

    public Item getKnownPickup(UnrealId id) {
        return (Item)this.items.known.get(id);
    }

    public Item getKnownPickup(String stringUnrealId) {
        return this.getKnownPickup(UnrealId.get((String)stringUnrealId));
    }

    public Map<UnrealId, Item> getSpawnedItems() {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (Item item : this.getAllItems().values()) {
            if (!this.isPickupSpawned(item)) continue;
            result.put(item.getId(), item);
        }
        return result;
    }

    public Map<UnrealId, Item> getSpawnedItems(UT3ItemType type) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (Item item : this.getAllItems(type).values()) {
            if (!this.isPickupSpawned(item)) continue;
            result.put(item.getId(), item);
        }
        return result;
    }

    public Map<UnrealId, Item> getSpawnedItems(UT3ItemType.Category category) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : category.getTypes()) {
            result.putAll(this.getSpawnedItems(type));
        }
        return result;
    }

    public Map<UnrealId, Item> getSpawnedItems(UT3ItemType.Group group) {
        HashMap<UnrealId, Item> result = new HashMap<UnrealId, Item>();
        for (UT3ItemType type : group.getTypes()) {
            result.putAll(this.getSpawnedItems(type));
        }
        return result;
    }

    public double getItemRespawnUT2004Time(Item item) {
        return this.getItemRespawnTime(UT3ItemType.getUT3ItemType(item.getType())) * 1.1;
    }

    public double getItemRespawnUT2004Time(UT3ItemType UT3ItemType2) {
        return this.getItemRespawnTime(UT3ItemType2) * 1.1;
    }

    public double getItemRespawnTime(Item item) {
        return this.getItemRespawnTime(UT3ItemType.getUT3ItemType(item.getType()));
    }

    public double getItemRespawnTime(UT3ItemType ut3ItemType) {
        if (ut3ItemType == UT3ItemType.U_DAMAGE_PACK || ut3ItemType == UT3ItemType.REDEEMER) {
            return 85.5;
        }
        if (ut3ItemType == UT3ItemType.SUPER_HEALTH_PACK || ut3ItemType == UT3ItemType.ARMOR_SHIELD_BELT) {
            return 57.0;
        }
        return 28.5;
    }

    public boolean isPickupSpawned(Item item) {
        if (item == null) {
            return false;
        }
        if (item.isVisible()) {
            return true;
        }
        NavPoint np = item.getNavPoint();
        if (np == null) {
            np = this.navPoints.get(item.getNavPointId());
        }
        if (np != null) {
            if (np.isVisible()) {
                return np.isItemSpawned();
            }
            return !this.items.itemMissing.isTaboo((Object)item);
        }
        return !this.items.itemMissing.isTaboo((Object)item);
    }

    public boolean isPickupSpawned(UnrealId itemId) {
        return this.isPickupSpawned((Item)this.items.all.get(itemId));
    }

    protected ItemsListener createItemsListener(IWorldView worldView) {
        return new ItemsListener(worldView);
    }

    protected MapPointsListener createMapPointsListener(IWorldView worldView) {
        return new MapPointsListener(worldView);
    }

    public UT3Items(UT2004Bot bot) {
        this(bot, new AgentInfo(bot), new Game(bot), new UT3Weaponry(bot), null);
    }

    public UT3Items(UT2004Bot bot, AgentInfo agentInfo, Game game, UT3Weaponry weaponry, Logger log) {
        super((IObservingAgent)bot, log);
        this.agentInfo = agentInfo;
        NullCheck.check((Object)this.agentInfo, (String)"agentInfo");
        this.weaponry = weaponry;
        NullCheck.check((Object)((Object)this.weaponry), (String)"weaponry");
        this.game = game;
        NullCheck.check((Object)this.game, (String)"game");
        this.items = new ItemMaps(bot);
        this.itemsListener = this.createItemsListener(this.worldView);
        this.mapPointsListener = this.createMapPointsListener(this.worldView);
        this.navPointListener = new NavPointListener(this.worldView);
        this.endMessageListener = new EndMessageListener(this.worldView);
        this.itemPickedUpListener = new ItemPickedUpListener(this.worldView);
        this.cleanUp();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.navPoints.clear();
        this.items.clear();
    }

    protected class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, (IWorldEventListener)this);
        }

        public void notify(ItemPickedUp event) {
            UT3Items.this.items.notify(event);
        }
    }

    protected class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, (IWorldEventListener)this);
        }

        public void notify(EndMessage event) {
            UT3Items.this.items.notifyBatchEnd(UT3Items.this.navPointsToProcess);
        }
    }

    protected class NavPointListener
    implements IWorldObjectEventListener<NavPoint, WorldObjectUpdatedEvent<NavPoint>> {
        public NavPointListener(IWorldView worldView) {
            worldView.addObjectListener(NavPoint.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<NavPoint> event) {
            UT3Items.this.items.notify((NavPoint)event.getObject());
            if (((NavPoint)event.getObject()).isVisible()) {
                UT3Items.this.navPointsToProcess.add((NavPoint)event.getObject());
            } else {
                UT3Items.this.navPointsToProcess.remove(event.getObject());
            }
        }
    }

    protected class MapPointsListener
    implements IWorldEventListener<MapPointListObtained> {
        public MapPointsListener(IWorldView worldView) {
            worldView.addEventListener(MapPointListObtained.class, (IWorldEventListener)this);
        }

        public void notify(MapPointListObtained event) {
            UT3Items.this.navPoints = event.getNavPoints();
            UT3Items.this.items.notify(event.getItems());
        }
    }

    protected class ItemsListener
    implements IWorldObjectEventListener<Item, IWorldObjectEvent<Item>> {
        public ItemsListener(IWorldView worldView) {
            worldView.addObjectListener(Item.class, IWorldObjectEvent.class, (IWorldObjectEventListener)this);
        }

        public void notify(IWorldObjectEvent<Item> event) {
            UT3Items.this.items.notify((Item)event.getObject());
        }
    }

    private class ItemMaps {
        private HashMap<UnrealId, Item> all = new HashMap();
        private HashMap<UnrealId, Item> visible = new HashMap();
        private HashMap<UnrealId, Item> reachable = new HashMap();
        private HashMap<UnrealId, Item> known = new HashMap();
        private HashMapMap<UT3ItemType, UnrealId, Item> allCategories = new HashMapMap();
        private HashMapMap<UT3ItemType, UnrealId, Item> visibleCategories = new HashMapMap();
        private HashMapMap<UT3ItemType, UnrealId, Item> reachableCategories = new HashMapMap();
        private HashMapMap<UT3ItemType, UnrealId, Item> knownCategories = new HashMapMap();
        private TabooSet<Item> itemMissing;
        private Set<Item> justPickedUp = new HashSet<Item>();
        private HashMap<UnrealId, Boolean> itemSpawned = new HashMap();

        public ItemMaps(UT2004Bot bot) {
            this.itemMissing = new TabooSet(bot);
        }

        private void notify(NavPoint navPoint) {
            if (navPoint.getItem() == null) {
                return;
            }
            Item item = UT3Items.this.getItem(navPoint.getItem());
            if (item == null) {
                return;
            }
            if (navPoint.isItemSpawned()) {
                this.itemMissing.remove((Object)item);
            } else {
                if (this.itemMissing.isTaboo((Object)item)) {
                    return;
                }
                this.itemMissing.add((Object)item, UT3Items.this.getItemRespawnUT2004Time(item));
            }
        }

        private void notify(Item item) {
            UnrealId uid = item.getId();
            UT3ItemType itemType = UT3ItemType.getUT3ItemType(item.getType());
            if (!this.all.containsKey(uid)) {
                this.all.put(uid, item);
                this.allCategories.put((Object)itemType, (Object)item.getId(), (Object)item);
            }
            boolean wasVisible = this.visible.containsKey(uid);
            boolean isVisible = item.isVisible();
            if (isVisible && !wasVisible) {
                this.visible.put(uid, item);
                this.visibleCategories.put((Object)itemType, (Object)item.getId(), (Object)item);
            } else if (!isVisible && wasVisible) {
                this.visible.remove(uid);
                this.visibleCategories.remove((Object)itemType, (Object)item.getId());
            }
            if (!isVisible && item.isDropped()) {
                this.all.remove(uid);
                this.allCategories.remove((Object)itemType, (Object)item.getId());
            }
        }

        private void notify(Map<UnrealId, Item> items) {
            this.known.putAll(items);
            for (Item item : items.values()) {
                UT3ItemType itemType = UT3ItemType.getUT3ItemType(item.getType());
                this.knownCategories.put((Object)itemType, (Object)item.getId(), (Object)item);
                this.notify(item);
            }
        }

        private void notifyBatchEnd(List<NavPoint> navPoints) {
            this.justPickedUp.clear();
        }

        private void notify(ItemPickedUp event) {
            Item item = this.all.get(event.getId());
            if (item == null) {
                return;
            }
            this.justPickedUp.add(item);
            this.itemMissing.add((Object)item, UT3Items.this.getItemRespawnUT2004Time(item));
        }

        private void clear() {
            this.all.clear();
            this.allCategories.clear();
            this.itemMissing.clear();
            this.justPickedUp.clear();
            this.known.clear();
            this.knownCategories.clear();
            this.reachable.clear();
            this.reachableCategories.clear();
            this.visible.clear();
            this.visibleCategories.clear();
        }
    }
}

