/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.bot.command;

import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeWeapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weapon;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weaponry;
import cz.cuni.amis.pogamut.ut3.agent.module.sensor.UT3WeaponPref;
import cz.cuni.amis.pogamut.ut3.agent.module.sensor.UT3WeaponPrefs;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Logger;

public class UT3ImprovedShooting
extends AdvancedShooting {
    private UT3Weaponry weaponry;
    private UT3ItemType currentWeapon = null;
    private Self self;
    private IWorldObjectListener<Self> selfListener = new IWorldObjectListener<Self>(){

        public void notify(IWorldObjectEvent<Self> event) {
            UT3ImprovedShooting.this.self = (Self)event.getObject();
            if (UT3ImprovedShooting.this.weaponry.getCurrentWeapon() == null) {
                UT3ImprovedShooting.this.currentWeapon = null;
            } else {
                UT3ImprovedShooting.this.currentWeapon = UT3ImprovedShooting.this.weaponry.getCurrentWeapon().getType();
            }
        }
    };
    private long lastChangeWeapon = 0L;
    private long changeWeaponCooldown = 1000L;
    private ICommandListener<ChangeWeapon> changeWeaponListener = new ICommandListener<ChangeWeapon>(){

        public void notify(ChangeWeapon event) {
            UT3ImprovedShooting.this.currentWeapon = UT3ItemType.getWeaponItemType(event.getId());
            UT3ImprovedShooting.this.lastChangeWeapon = System.currentTimeMillis();
        }
    };
    private UT3WeaponPref lastShooting = null;
    private ICommandListener<Shoot> shootListener = new ICommandListener<Shoot>(){

        public void notify(Shoot event) {
            if (UT3ImprovedShooting.this.currentWeapon == null) {
                UT3ImprovedShooting.this.lastShooting = null;
            } else {
                UT3ImprovedShooting.this.lastShooting = new UT3WeaponPref(UT3ImprovedShooting.this.currentWeapon, event.isAlt() == null || event.isAlt() == false);
            }
        }
    };
    private ICommandListener<StopShooting> stopShootingListener = new ICommandListener<StopShooting>(){

        public void notify(StopShooting event) {
            UT3ImprovedShooting.this.lastShooting = null;
        }
    };

    public UT3ImprovedShooting(UT3Weaponry weaponry, UT2004Bot agent, Logger log) {
        super(agent, log);
        NullCheck.check((Object)((Object)weaponry), (String)"weaponry");
        this.weaponry = weaponry;
        agent.getWorldView().addObjectListener(Self.class, this.selfListener);
        agent.getAct().addCommandListener(Shoot.class, this.shootListener);
        agent.getAct().addCommandListener(StopShooting.class, this.stopShootingListener);
        agent.getAct().addCommandListener(ChangeWeapon.class, this.changeWeaponListener);
    }

    public boolean mayChangeWeapon() {
        return System.currentTimeMillis() - this.lastChangeWeapon > this.changeWeaponCooldown;
    }

    public UT3WeaponPref getActualUT3WeaponPref() {
        if (this.lastShooting != null && this.lastShooting.getWeapon() == this.currentWeapon) {
            return this.lastShooting;
        }
        if (this.currentWeapon != null) {
            return new UT3WeaponPref(this.currentWeapon, true);
        }
        return null;
    }

    protected UT3ItemType getActualWeaponType() {
        if (this.currentWeapon != null) {
            return this.currentWeapon;
        }
        return null;
    }

    public boolean changeWeapon(UT3ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (this.currentWeapon == weaponType) {
            return true;
        }
        if (!this.mayChangeWeapon()) {
            return false;
        }
        return this.changeWeaponNow(weaponType);
    }

    public boolean changeWeapon(UT3Weapon weapon) {
        if (weapon == null) {
            return false;
        }
        if (this.currentWeapon == weapon.getType()) {
            return true;
        }
        if (!this.mayChangeWeapon()) {
            return false;
        }
        return this.changeWeaponNow(weapon);
    }

    public boolean changeWeapon(UT3WeaponPref pref) {
        if (pref == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon()) {
            return true;
        }
        if (!this.mayChangeWeapon()) {
            return false;
        }
        return this.changeWeaponNow(pref);
    }

    public UT3WeaponPref changeWeapon(UT3WeaponPrefs UT3WeaponPrefs2, UT3ItemType ... forbiddenWeapons) {
        UT3WeaponPref chosen = UT3WeaponPrefs2.getWeaponPreference(forbiddenWeapons);
        if (this.changeWeapon(chosen)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public UT3WeaponPref changeWeapon(UT3WeaponPrefs UT3WeaponPrefs2, double distance, UT3ItemType ... forbiddenWeapons) {
        UT3WeaponPref chosen = UT3WeaponPrefs2.getWeaponPreference(distance, forbiddenWeapons);
        if (this.changeWeapon(chosen)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public UT3WeaponPref changeWeapon(UT3WeaponPrefs UT3WeaponPrefs2, ILocated target, UT3ItemType ... forbiddenWeapons) {
        UT3WeaponPref chosen = UT3WeaponPrefs2.getWeaponPreference(target, forbiddenWeapons);
        if (this.changeWeapon(chosen)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public boolean changeWeaponNow(UT3ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        return this.weaponry.changeWeapon(weaponType);
    }

    public boolean changeWeaponNow(UT3Weapon weapon) {
        if (weapon == null) {
            return false;
        }
        return this.weaponry.changeWeapon(weapon);
    }

    public boolean changeWeaponNow(UT3WeaponPref pref) {
        if (pref == null) {
            return false;
        }
        if (this.weaponry.hasPrimaryLoadedWeapon(pref.getWeapon())) {
            return this.changeWeaponNow(pref.getWeapon());
        }
        this.log.info("Can't change to weapon-primary " + pref.getWeapon() + " as we do not have the weapon/or ammo for doing so.");
        return false;
    }

    public UT3WeaponPref changeWeaponNow(UT3WeaponPrefs UT3WeaponPrefs2, UT3ItemType ... forbiddenWeapons) {
        UT3WeaponPref chosen = UT3WeaponPrefs2.getWeaponPreference(forbiddenWeapons);
        if (this.changeWeaponNow(chosen)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public UT3WeaponPref changeWeaponNow(UT3WeaponPrefs UT3WeaponPrefs2, double distance, UT3ItemType ... forbiddenWeapons) {
        UT3WeaponPref chosen = UT3WeaponPrefs2.getWeaponPreference(distance, forbiddenWeapons);
        if (this.changeWeaponNow(chosen)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public UT3WeaponPref changeWeaponNow(UT3WeaponPrefs UT3WeaponPrefs2, ILocated target, UT3ItemType ... forbiddenWeapons) {
        UT3WeaponPref chosen = UT3WeaponPrefs2.getWeaponPreference(target, forbiddenWeapons);
        if (this.changeWeaponNow(chosen)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public boolean shoot(UT3WeaponPref pref, UnrealId target) {
        if (pref == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon()) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        if (!this.mayChangeWeapon()) {
            if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
                if (this.lastShooting.isPrimary()) {
                    this.shoot(target);
                } else {
                    this.shootSecondary(target);
                }
            } else {
                this.shoot(target);
            }
            return true;
        }
        return this.shootNow(pref, target);
    }

    public boolean shoot(UT3WeaponPref pref, ILocated target) {
        if (pref == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon()) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        if (!this.mayChangeWeapon()) {
            if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
                if (this.lastShooting.isPrimary()) {
                    this.shoot(target);
                } else {
                    this.shootSecondary(target);
                }
            } else {
                this.shoot(target);
            }
            return true;
        }
        return this.shootNow(pref, target);
    }

    public boolean shoot(UT3Weapon weapon, boolean usePrimaryMode, UnrealId target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shoot(new UT3WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public boolean shoot(UT3Weapon weapon, boolean usePrimaryMode, ILocated target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shoot(new UT3WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public UT3WeaponPref shoot(UT3WeaponPrefs prefs, ILocated target, UT3ItemType ... forbiddenWeapon) {
        NullCheck.check((Object)prefs, (String)"prefs");
        if (target == null) {
            return null;
        }
        UT3WeaponPref chosen = prefs.getWeaponPreference(target, forbiddenWeapon);
        if (this.shoot(chosen, target)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public boolean shootNow(UT3WeaponPref pref, UnrealId target) {
        if (pref == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon() || this.changeWeaponNow(pref)) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
        } else if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
            if (this.lastShooting.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
        } else {
            this.shoot(target);
        }
        return true;
    }

    public boolean shootNow(UT3WeaponPref pref, ILocated target) {
        if (pref == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon() || this.changeWeaponNow(pref)) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
            if (this.lastShooting.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        this.shoot(target);
        return true;
    }

    public boolean shootNow(UT3Weapon weapon, boolean usePrimaryMode, UnrealId target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shootNow(new UT3WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public boolean shootNow(UT3Weapon weapon, boolean usePrimaryMode, ILocated target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shootNow(new UT3WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public UT3WeaponPref shootNow(UT3WeaponPrefs prefs, ILocated target, UT3ItemType ... forbiddenWeapon) {
        NullCheck.check((Object)prefs, (String)"prefs");
        if (target == null) {
            return null;
        }
        UT3WeaponPref chosen = prefs.getWeaponPreference(target, forbiddenWeapon);
        if (this.shootNow(chosen, target)) {
            return chosen;
        }
        return this.getActualUT3WeaponPref();
    }

    public UT3WeaponPref getLastShooting() {
        return this.lastShooting;
    }

    public long getLastChangeWeapon() {
        return this.lastChangeWeapon;
    }

    public long getChangeWeaponCooldown() {
        return this.changeWeaponCooldown;
    }

    public void setChangeWeaponCooldown(long changeWeaponCooldownMillis) {
        this.changeWeaponCooldown = changeWeaponCooldownMillis;
    }
}

