/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.agent.module.sensor;

import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weapon;
import cz.cuni.amis.pogamut.ut3.agent.module.sensor.UT3WeaponPref;
import cz.cuni.amis.pogamut.ut3.agent.module.sensor.UT3WeaponPrefs;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class UT3WeaponPrefsRange {
    private double maxDistance;
    private UT3WeaponPrefs owner;
    private List<UT3WeaponPref> prefs = new ArrayList<UT3WeaponPref>();

    protected UT3WeaponPrefsRange(UT3WeaponPrefs owner, double maxDistance) {
        NullCheck.check((Object)owner, (String)"owner");
        this.owner = owner;
        this.maxDistance = maxDistance;
    }

    public UT3WeaponPrefsRange(UT3WeaponPrefs owner, UT3WeaponPrefsRange prefs) {
        NullCheck.check((Object)prefs, (String)"prefs");
        NullCheck.check((Object)owner, (String)"owner");
        this.prefs.addAll(prefs.prefs);
        this.owner = owner;
        this.maxDistance = prefs.maxDistance;
    }

    public UT3WeaponPrefsRange add(UT3ItemType weapon, boolean usePrimaryMode) {
        NullCheck.check((Object)weapon, (String)"weapon");
        this.prefs.add(new UT3WeaponPref(weapon, usePrimaryMode));
        return this;
    }

    public UT3WeaponPrefsRange add(UT3Weapon weapon, boolean usePrimaryMode) {
        NullCheck.check((Object)weapon, (String)"weapon");
        this.add(weapon.getType(), usePrimaryMode);
        return this;
    }

    public double getMinDistance() {
        UT3WeaponPrefsRange next = this.owner.getPreviousRange(this);
        if (next == null) {
            return 0.0;
        }
        return next.getMaxDistance();
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public UT3WeaponPref getWeaponPreference() {
        return this.getWeaponPreference((UT3ItemType[])null);
    }

    public UT3WeaponPref getWeaponPreference(UT3ItemType ... forbiddenWeapons) {
        List<Object> forbidden = forbiddenWeapons == null ? new ArrayList(0) : Arrays.asList(forbiddenWeapons);
        for (UT3WeaponPref pref : this.prefs) {
            if (forbidden.contains(pref.getWeapon()) || !this.owner.weaponry.hasPrimaryLoadedWeapon(pref.getWeapon())) continue;
            return pref;
        }
        return null;
    }

    public UT3WeaponPref getWeaponPreference(UT3WeaponPref ... forbiddenWeapons) {
        HashSet<UT3WeaponPref> forbidden = new HashSet<UT3WeaponPref>();
        if (forbiddenWeapons != null) {
            for (UT3WeaponPref pref : forbiddenWeapons) {
                forbidden.add(pref);
            }
        }
        for (UT3WeaponPref pref : this.prefs) {
            if (forbidden.contains(pref) || !this.owner.weaponry.hasPrimaryLoadedWeapon(pref.getWeapon())) continue;
            return pref;
        }
        return null;
    }

    public void clear() {
        this.prefs.clear();
    }

    public List<UT3WeaponPref> getPrefs() {
        return this.prefs;
    }

    public void setPrefs(List<UT3WeaponPref> prefs) {
        this.prefs = prefs;
    }

    public UT3WeaponPrefs getOwner() {
        return this.owner;
    }
}

