/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weapon;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weaponry;
import cz.cuni.amis.pogamut.ut3.agent.module.sensor.UT3WeaponPref;
import cz.cuni.amis.pogamut.ut3.agent.module.sensor.UT3WeaponPrefsRange;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UT3WeaponPrefs {
    protected List<UT3WeaponPrefsRange> prefs = new ArrayList<UT3WeaponPrefsRange>();
    protected UT3Weaponry weaponry;
    protected UT2004Bot bot;
    protected UT3WeaponPrefsRange generalPrefs;
    protected UT3WeaponPrefs onlyGeneral;

    public UT3WeaponPrefs(UT3Weaponry weaponry, UT2004Bot bot) {
        this.weaponry = weaponry;
        this.bot = bot;
        this.generalPrefs = new UT3WeaponPrefsRange(this, 0.0);
        this.onlyGeneral = new UT3WeaponPrefs(weaponry, bot, new UT3WeaponPrefsRange(this, 0.0)){

            @Override
            public UT3WeaponPrefsRange newPrefsRange(double minDistance) {
                throw new IllegalStateException("Can't invoke the method on 'generalOnly' preferences!");
            }

            @Override
            public UT3WeaponPrefs addGeneralPref(UT3ItemType weapon, boolean usePrimaryMode) {
                throw new IllegalStateException("Can't invoke the method on 'generalOnly' preferences!");
            }

            @Override
            public UT3WeaponPrefs addGeneralPref(UT3Weapon weapon, boolean usePrimaryMode) {
                throw new IllegalStateException("Can't invoke the method on 'generalOnly' preferences!");
            }
        };
    }

    protected UT3WeaponPrefs(UT3Weaponry weaponry, UT2004Bot bot, UT3WeaponPrefsRange generalPrefs) {
        this.weaponry = weaponry;
        this.bot = bot;
        this.generalPrefs = new UT3WeaponPrefsRange(this, generalPrefs);
        this.onlyGeneral = this;
    }

    public UT3WeaponPrefs asGeneralOnly() {
        return this.onlyGeneral;
    }

    public void clearAllPrefs() {
        this.prefs.clear();
        this.generalPrefs.clear();
        this.onlyGeneral.generalPrefs.clear();
    }

    public UT3WeaponPrefs addGeneralPref(UT3ItemType weapon, boolean usePrimaryMode) {
        this.generalPrefs.add(weapon, usePrimaryMode);
        this.onlyGeneral.generalPrefs.add(weapon, usePrimaryMode);
        return this;
    }

    public UT3WeaponPrefs addGeneralPref(UT3Weapon weapon, boolean usePrimaryMode) {
        this.generalPrefs.add(weapon, usePrimaryMode);
        this.onlyGeneral.generalPrefs.add(weapon, usePrimaryMode);
        return this;
    }

    public UT3WeaponPrefsRange newPrefsRange(double maxDistance) {
        UT3WeaponPrefsRange newPrefs = new UT3WeaponPrefsRange(this, maxDistance);
        this.prefs.add(newPrefs);
        Collections.sort(this.prefs, new Comparator<UT3WeaponPrefsRange>(){

            @Override
            public int compare(UT3WeaponPrefsRange o1, UT3WeaponPrefsRange o2) {
                double diff = o1.getMaxDistance() - o2.getMaxDistance();
                if (diff > 0.0) {
                    return 1;
                }
                if (diff < 0.0) {
                    return -1;
                }
                return 0;
            }
        });
        return newPrefs;
    }

    public UT3WeaponPrefsRange getWeaponPreferences(double distance) {
        if (distance < 0.0) {
            return this.generalPrefs;
        }
        if (this.prefs.size() == 0) {
            return this.generalPrefs;
        }
        int i = 0;
        for (UT3WeaponPrefsRange pref : this.prefs) {
            double minDistance = pref.getMinDistance();
            if (minDistance > distance) {
                if (i == 0) {
                    return null;
                }
                return this.prefs.get(i - 1);
            }
            ++i;
        }
        return this.prefs.get(this.prefs.size() - 1);
    }

    protected UT3WeaponPrefsRange getPreviousRange(UT3WeaponPrefsRange weaponPrefsRange) {
        if (weaponPrefsRange == this.generalPrefs) {
            return null;
        }
        int index = this.prefs.indexOf(weaponPrefsRange);
        if (index < 1) {
            return null;
        }
        return this.prefs.get(index - 1);
    }

    public UT3WeaponPref getWeaponPreference(double distance, UT3ItemType ... forbiddenWeapons) {
        UT3WeaponPrefsRange range;
        UT3WeaponPref pref = null;
        if (distance >= 0.0 && this.prefs.size() != 0 && (pref = (range = this.getWeaponPreferences(distance)).getWeaponPreference(forbiddenWeapons)) != null) {
            return pref;
        }
        pref = this.generalPrefs.getWeaponPreference(forbiddenWeapons);
        if (pref != null) {
            return pref;
        }
        pref = this.generalPrefs.getWeaponPreference();
        if (pref != null) {
            return pref;
        }
        if (this.weaponry.getCurrentWeapon() != null) {
            return new UT3WeaponPref(this.weaponry.getCurrentWeapon().getType(), true);
        }
        return null;
    }

    public UT3WeaponPref getWeaponPreference(ILocated target, UT3ItemType ... forbiddenWeapons) {
        if (target == null) {
            return this.getWeaponPreference(-1.0, forbiddenWeapons);
        }
        return this.getWeaponPreference(this.bot.getLocation().getDistance(target.getLocation()), forbiddenWeapons);
    }

    public UT3WeaponPref getWeaponPreference(UT3ItemType ... forbiddenWeapons) {
        return this.getWeaponPreference(-1.0, forbiddenWeapons);
    }

    public UT3WeaponPref getWeaponPreference(double distance, UT3WeaponPref ... forbiddenWeapons) {
        UT3WeaponPrefsRange range;
        UT3WeaponPref pref = null;
        if (distance >= 0.0 && this.prefs.size() != 0 && (pref = (range = this.getWeaponPreferences(distance)).getWeaponPreference(forbiddenWeapons)) != null) {
            return pref;
        }
        pref = this.generalPrefs.getWeaponPreference(forbiddenWeapons);
        if (pref != null) {
            return pref;
        }
        pref = this.generalPrefs.getWeaponPreference();
        if (pref != null) {
            return pref;
        }
        if (this.weaponry.getCurrentWeapon() != null) {
            return new UT3WeaponPref(this.weaponry.getCurrentWeapon().getType(), true);
        }
        return null;
    }

    public UT3WeaponPref getWeaponPreference(ILocated target, UT3WeaponPref ... forbiddenWeapons) {
        if (target == null) {
            return this.getWeaponPreference(-1.0, forbiddenWeapons);
        }
        return this.getWeaponPreference(this.bot.getLocation().getDistance(target.getLocation()), forbiddenWeapons);
    }

    public UT3WeaponPref getWeaponPreference(UT3WeaponPref ... forbiddenWeapons) {
        return this.getWeaponPreference(-1.0, forbiddenWeapons);
    }

    public UT3WeaponPref getWeaponPreference(double distance) {
        return this.getWeaponPreference(distance, (UT3ItemType[])null);
    }

    public UT3WeaponPref getWeaponPreference(ILocated target) {
        return this.getWeaponPreference(target, (UT3ItemType[])null);
    }

    public UT3WeaponPref getWeaponPreference() {
        return this.getWeaponPreference(-1.0, (UT3ItemType[])null);
    }
}

