/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeWeapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Thrown;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WeaponUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric.UT3Weapon;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class UT3Weaponry
extends SensomotoricModule<UT2004Bot> {
    private Ammunition ammo = new Ammunition();
    WeaponsByKey<UT3ItemType.Group> weaponsByGroup = new WeaponsByKey();
    WeaponsByKey<UT3ItemType> weaponsByUT3ItemType = new WeaponsByKey();
    WeaponsByKey<UnrealId> weaponsById = new WeaponsByKey();
    private Map<UT3ItemType, UnrealId> weaponTypeToInventoryUnrealId = new HashMap<UT3ItemType, UnrealId>();
    private Map<UT3ItemType, ItemCategory> weaponAmmoTypeToItemCategory = new HashMap<UT3ItemType, ItemCategory>();
    AddInventoryMsgListener addInventoryMsgListener = new AddInventoryMsgListener(this.worldView);
    ItemCategoriesMsgListener itemCategoriesMsgListener = new ItemCategoriesMsgListener(this.worldView);
    ItemPickedUpListener itemPickedUpListener = new ItemPickedUpListener(this.worldView);
    WeaponUpdateListener weaponUpdateListener = new WeaponUpdateListener(this.worldView);
    SelfUpdateListener selfUpdateListener = new SelfUpdateListener(this.worldView);
    ThrownListener thrownListener = new ThrownListener(this.worldView);
    BotKilledListener botKilledListener = new BotKilledListener(this.worldView);
    private Self self = null;

    public UnrealId getWeaponInventoryId(UT3ItemType weaponType) {
        return this.weaponTypeToInventoryUnrealId.get(weaponType);
    }

    public UnrealId getWeaponInventoryId(WeaponDescriptor weaponDescriptor) {
        if (weaponDescriptor == null) {
            return null;
        }
        if (weaponDescriptor.getPickupType() == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("getWeaponInventoryId(): WeaponDescriptor does not have PickupType assigned!");
            }
            return null;
        }
        return this.weaponTypeToInventoryUnrealId.get(weaponDescriptor.getPickupType());
    }

    public boolean changeWeapon(UT3ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return false;
        }
        UT3Weapon weapon = this.getWeapon(weaponType);
        return this.changeWeapon(this.getWeapon(weaponType));
    }

    public boolean changeWeapon(UT3Weapon weapon) {
        if (weapon == null) {
            return false;
        }
        if (weapon == this.getCurrentWeapon()) {
            return true;
        }
        if (weapon.getAmmo() <= 0) {
            return false;
        }
        if (((WeaponsByKey)this.weaponsByUT3ItemType).all.get(weapon.getType()) == null) {
            return false;
        }
        this.act.act((CommandMessage)new ChangeWeapon().setId(weapon.getInventoryId().getStringId()));
        return true;
    }

    public int getAmmo(UT3ItemType ammoOrWeaponType) {
        if (ammoOrWeaponType == null) {
            return 0;
        }
        if (ammoOrWeaponType.getCategory() == UT3ItemType.Category.WEAPON) {
            return this.getPrimaryWeaponAmmo(ammoOrWeaponType);
        }
        if (ammoOrWeaponType.getCategory() == UT3ItemType.Category.AMMO) {
            return this.ammo.getAmmo(ammoOrWeaponType);
        }
        return 0;
    }

    public int getPrimaryWeaponAmmo(UT3ItemType weaponType) {
        if (weaponType == null) {
            return 0;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return 0;
        }
        return this.ammo.getPriAmmoForWeapon(weaponType);
    }

    public int getSecondaryWeaponAmmo(UT3ItemType weaponType) {
        if (weaponType == null) {
            return 0;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return 0;
        }
        return this.ammo.getSecAmmoForWeapon(weaponType);
    }

    public int getWeaponAmmo(UT3ItemType weaponType) {
        if (weaponType == null) {
            return 0;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return 0;
        }
        return this.ammo.getAmmoForWeapon(weaponType);
    }

    public boolean hasLowAmmoForWeapon(UT3ItemType weaponType, double lowRatio) {
        return this.hasPrimaryLowAmmoForWeapon(weaponType, lowRatio);
    }

    public boolean hasPrimaryLowAmmoForWeapon(UT3ItemType weaponType, double lowRatio) {
        int ammo = this.getPrimaryWeaponAmmo(weaponType);
        ItemCategory weaponCat = this.weaponAmmoTypeToItemCategory.get(weaponType);
        if (weaponCat != null) {
            return (double)ammo / (double)weaponCat.getPriMaxAmount() < lowRatio;
        }
        return false;
    }

    public boolean hasAmmo(UT3ItemType ammoType) {
        if (ammoType == null) {
            return false;
        }
        if (ammoType.getCategory() != UT3ItemType.Category.AMMO) {
            return false;
        }
        return this.ammo.getAmmo(ammoType) > 0;
    }

    public boolean hasAmmoForWeapon(UT3ItemType weaponType) {
        return this.hasWeaponAmmo(weaponType);
    }

    public boolean hasWeaponAmmo(UT3ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return false;
        }
        return this.ammo.getAmmoForWeapon(weaponType) > 0;
    }

    public boolean hasPrimaryWeaponAmmo(UT3ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return false;
        }
        return this.ammo.getPriAmmoForWeapon(weaponType) > 0;
    }

    public boolean hasWeapon(UT3ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByUT3ItemType).all.containsKey(weaponType);
    }

    public boolean hasWeapon(UT3ItemType.Group weaponGroup) {
        if (weaponGroup == null) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByGroup).all.containsKey((Object)weaponGroup);
    }

    public boolean isLoaded(UT3ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByUT3ItemType).allLoaded.containsKey(weaponType);
    }

    public boolean isLoaded(UT3ItemType.Group weaponGroup) {
        if (weaponGroup == null) {
            return false;
        }
        return ((WeaponsByKey)this.weaponsByGroup).allLoaded.containsKey((Object)weaponGroup);
    }

    public UT3Weapon getCurrentWeapon() {
        if (this.self == null) {
            return null;
        }
        if (this.self.getWeapon() == null) {
            return null;
        }
        return (UT3Weapon)((WeaponsByKey)this.weaponsByUT3ItemType).all.get(UT3ItemType.getWeaponItemType(this.self.getWeapon()));
    }

    public int getCurrentAmmo() {
        if (this.getCurrentWeapon() == null) {
            return 0;
        }
        return this.getCurrentPrimaryAmmo();
    }

    public int getCurrentPrimaryAmmo() {
        if (this.self == null) {
            return 0;
        }
        return this.self.getPrimaryAmmo();
    }

    public Map<UT3ItemType, UT3Weapon> getWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByUT3ItemType).all);
    }

    public UT3Weapon getWeapon(UT3ItemType weaponType) {
        if (weaponType == null) {
            return null;
        }
        if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            return null;
        }
        return (UT3Weapon)((WeaponsByKey)this.weaponsByUT3ItemType).all.get(weaponType);
    }

    public Map<UT3ItemType, UT3Weapon> getLoadedWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByUT3ItemType).allLoaded);
    }

    public Map<UT3ItemType, UT3Weapon> getMeleeWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByUT3ItemType).allMelee);
    }

    public Map<UT3ItemType, UT3Weapon> getRangedWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByUT3ItemType).allRanged);
    }

    public Map<UT3ItemType, UT3Weapon> getLoadedMeleeWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByUT3ItemType).allLoadedMelee);
    }

    public Map<UT3ItemType, UT3Weapon> getLoadedRangedWeapons() {
        return Collections.unmodifiableMap(((WeaponsByKey)this.weaponsByUT3ItemType).allLoadedRanged);
    }

    public Map<UT3ItemType, Integer> getAmmos() {
        return Collections.unmodifiableMap(this.ammo.ammo);
    }

    public boolean hasLoadedWeapon() {
        return !this.getLoadedWeapons().isEmpty();
    }

    public boolean hasLoadedRangedWeapon() {
        return !this.getLoadedRangedWeapons().isEmpty();
    }

    public boolean hasLoadedMeleeWeapon() {
        return !this.getLoadedMeleeWeapons().isEmpty();
    }

    public boolean hasLoadedWeapon(UT3ItemType weapon) {
        return this.hasPrimaryLoadedWeapon(weapon);
    }

    public boolean hasPrimaryLoadedWeapon(UT3ItemType weapon) {
        UT3Weapon w = this.getWeapon(weapon);
        if (w == null) {
            return false;
        }
        return w.getPrimaryAmmo() > 0;
    }

    public UT3ItemType getWeaponForAmmo(UT3ItemType priOrSecAmmoType) {
        return UT3ItemType.getWeaponForAmmo(priOrSecAmmoType);
    }

    public UT3ItemType getPrimaryWeaponAmmoType(UT3ItemType weaponType) {
        return UT3ItemType.getAmmoForWeapon(weaponType);
    }

    public UT3ItemType getSecondaryWeaponAmmoType(UT3ItemType weaponType) {
        return UT3ItemType.getAmmoForWeapon(weaponType);
    }

    public UT3Weaponry(UT2004Bot bot) {
        this(bot, null);
    }

    public UT3Weaponry(UT2004Bot bot, LogCategory moduleLog) {
        super((IEmbodiedAgent)bot);
        this.cleanUp();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.ammo.botKilled();
        this.weaponsByGroup.botKilled();
        this.weaponsByUT3ItemType.botKilled();
        this.weaponsById.botKilled();
        this.weaponTypeToInventoryUnrealId.clear();
    }

    public int getMaxAmmo(UT3ItemType ammoType) {
        ItemCategory cat = this.weaponAmmoTypeToItemCategory.get(ammoType);
        if (cat != null) {
            return cat.getPriMaxAmount();
        }
        return 0;
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public void notify(BotKilled event) {
            UT3Weaponry.this.ammo.botKilled();
            UT3Weaponry.this.weaponsByGroup.botKilled();
            UT3Weaponry.this.weaponsByUT3ItemType.botKilled();
            UT3Weaponry.this.weaponsById.botKilled();
            UT3Weaponry.this.weaponTypeToInventoryUnrealId.clear();
        }

        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, (IWorldEventListener)this);
        }
    }

    private class ThrownListener
    implements IWorldEventListener<Thrown> {
        public void notify(Thrown event) {
            UT3ItemType weaponType = UT3ItemType.getWeaponItemType(event.getId());
            if (weaponType != null) {
                UT3Weaponry.this.weaponsByGroup.remove(weaponType.getGroup());
                UT3Weaponry.this.weaponsByUT3ItemType.remove(weaponType);
            }
        }

        public ThrownListener(IWorldView worldView) {
            worldView.addEventListener(Thrown.class, (IWorldEventListener)this);
        }
    }

    private class SelfUpdateListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        public void notify(WorldObjectUpdatedEvent<Self> event) {
            UT3Weapon weaponToUpdate;
            if (event == null) {
                return;
            }
            if (UT3Weaponry.this.self == null) {
                UT3Weaponry.this.self = (Self)event.getObject();
            }
            if ((weaponToUpdate = UT3Weaponry.this.getCurrentWeapon()) != null) {
                UT3ItemType ammoToUpdate = UT3ItemType.getAmmoForWeapon(weaponToUpdate.getType());
                if (ammoToUpdate != null) {
                    UT3Weaponry.this.ammo.weaponUpdate(ammoToUpdate, UT3Weaponry.this.self.getPrimaryAmmo());
                }
                UT3Weaponry.this.ammo.updateWeaponAmmo(weaponToUpdate);
            }
        }

        public SelfUpdateListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }
    }

    private class WeaponUpdateListener
    implements IWorldEventListener<WeaponUpdate> {
        public void notify(WeaponUpdate event) {
            UT3Weapon weapon;
            if (event == null) {
                return;
            }
            UT3ItemType itemType = UT3ItemType.getUT3ItemType(event.getInventoryType());
            if (itemType == null) {
                return;
            }
            UT3ItemType ammoType = UT3ItemType.getAmmoForWeapon(itemType);
            if (ammoType != null) {
                UT3Weaponry.this.ammo.weaponUpdate(ammoType, event.getPrimaryAmmo());
            }
            if ((weapon = (UT3Weapon)((WeaponsByKey)UT3Weaponry.this.weaponsByUT3ItemType).all.get(itemType)) != null) {
                UT3Weaponry.this.ammo.updateWeaponAmmo(weapon);
            }
        }

        public WeaponUpdateListener(IWorldView worldView) {
            worldView.addEventListener(WeaponUpdate.class, (IWorldEventListener)this);
        }
    }

    private class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public void notify(ItemPickedUp event) {
            if (event == null) {
                return;
            }
            UT3ItemType invType = UT3ItemType.getUT3ItemType(event.getType());
            if (invType.getCategory() == UT3ItemType.Category.AMMO || invType.getCategory() == UT3ItemType.Category.WEAPON) {
                UT3Weapon weapon;
                UT3Weaponry.this.ammo.itemPickedUp(event);
                if (invType.getCategory() == UT3ItemType.Category.AMMO) {
                    UT3ItemType weaponType = UT3ItemType.getWeaponForAmmo(invType);
                    if (weaponType == null) {
                        if (UT3Weaponry.this.log.isLoggable(Level.WARNING)) {
                            UT3Weaponry.this.log.warning("ItemPickedUpListener.notify(): There is no weapon for the ammo " + event.getType() + ", the weapon probably can not be found in this map.");
                        }
                        return;
                    }
                    weapon = (UT3Weapon)((WeaponsByKey)UT3Weaponry.this.weaponsByUT3ItemType).all.get(weaponType);
                } else {
                    UT3ItemType weaponType = invType;
                    weapon = (UT3Weapon)((WeaponsByKey)UT3Weaponry.this.weaponsByUT3ItemType).all.get(weaponType);
                }
                if (weapon != null) {
                    UT3Weaponry.this.ammo.updateWeaponAmmo(weapon);
                }
            }
        }

        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, (IWorldEventListener)this);
        }
    }

    private class ItemCategoriesMsgListener
    implements IWorldEventListener<ItemCategory> {
        public void notify(ItemCategory event) {
            if (event == null) {
                return;
            }
            UT3ItemType invType = UT3ItemType.getUT3ItemType(event.getInventoryType());
            if (invType == null) {
                return;
            }
            if (invType.getCategory() == UT3ItemType.Category.WEAPON || invType.getCategory() == UT3ItemType.Category.AMMO) {
                UT3Weaponry.this.weaponAmmoTypeToItemCategory.put(invType, event);
            }
        }

        public ItemCategoriesMsgListener(IWorldView worldView) {
            worldView.addEventListener(ItemCategory.class, (IWorldEventListener)this);
        }
    }

    private class AddInventoryMsgListener
    implements IWorldEventListener<AddInventoryMsg> {
        public void notify(AddInventoryMsg event) {
            if (event == null) {
                return;
            }
            UT3ItemType invType = UT3ItemType.getUT3ItemType(event.getPickupType());
            if (invType == null) {
                return;
            }
            if (invType.getCategory() != UT3ItemType.Category.WEAPON) {
                return;
            }
            UT3Weapon weapon = new UT3Weapon(event, UT3Weaponry.this.ammo.getPriAmmoForWeapon(invType), UT3Weaponry.this.ammo.getSecAmmoForWeapon(invType));
            UT3Weaponry.this.weaponsByGroup.add(invType.getGroup(), weapon);
            UT3Weaponry.this.weaponsByUT3ItemType.add(invType, weapon);
            UT3Weaponry.this.weaponsById.add(event.getId(), weapon);
            UT3Weaponry.this.weaponTypeToInventoryUnrealId.put(invType, event.getId());
        }

        public AddInventoryMsgListener(IWorldView worldView) {
            worldView.addEventListener(AddInventoryMsg.class, (IWorldEventListener)this);
        }
    }

    private class WeaponsByKey<KEY> {
        private HashMap<KEY, UT3Weapon> all = new HashMap();
        private HashMap<KEY, UT3Weapon> allLoaded = new HashMap();
        private HashMap<KEY, UT3Weapon> allMelee = new HashMap();
        private HashMap<KEY, UT3Weapon> allRanged = new HashMap();
        private HashMap<KEY, UT3Weapon> allLoadedMelee = new HashMap();
        private HashMap<KEY, UT3Weapon> allLoadedRanged = new HashMap();

        private WeaponsByKey() {
        }

        public void add(KEY key, UT3Weapon inv) {
            if (key == null || inv == null) {
                return;
            }
            this.all.put(key, inv);
            if (inv.getType() == UT3ItemType.IMPACT_HAMMER) {
                this.allMelee.put(key, inv);
                this.allLoadedMelee.put(key, inv);
                this.allLoaded.put(key, inv);
            } else {
                this.allRanged.put(key, inv);
                if (inv.getAmmo() > 0) {
                    this.allLoadedRanged.put(key, inv);
                    this.allLoaded.put(key, inv);
                }
            }
        }

        public void remove(KEY key) {
            this.all.remove(key);
            this.allLoaded.remove(key);
            this.allMelee.remove(key);
            this.allRanged.remove(key);
            this.allLoadedMelee.remove(key);
            this.allLoadedRanged.remove(key);
        }

        public void ammoChanged(KEY key) {
            if (key == null) {
                return;
            }
            UT3Weapon weapon = this.all.get(key);
            if (weapon == null) {
                return;
            }
            if (weapon.getAmmo() > 0) {
                if (!this.allLoaded.containsKey(key)) {
                    this.allLoaded.put(key, weapon);
                    this.allLoadedRanged.put(key, weapon);
                }
            } else if (this.allLoaded.containsKey(key)) {
                this.allLoaded.remove(key);
                this.allLoadedMelee.remove(key);
                this.allLoadedRanged.remove(key);
            }
        }

        public void botKilled() {
            this.all.clear();
            this.allLoaded.clear();
            this.allLoadedMelee.clear();
            this.allLoadedRanged.clear();
            this.allMelee.clear();
            this.allRanged.clear();
        }
    }

    private class Ammunition {
        private LazyMap<UT3ItemType, Integer> ammo = new LazyMap<UT3ItemType, Integer>(){

            protected Integer create(UT3ItemType key) {
                return 0;
            }
        };

        private Ammunition() {
        }

        public int getAmmo(UT3ItemType ammoType) {
            if (ammoType == null) {
                return 0;
            }
            if (ammoType.getCategory() != UT3ItemType.Category.AMMO) {
                return 0;
            }
            if (ammoType == UT3ItemType.IMPACT_HAMMER_AMMO) {
                return 5;
            }
            return (Integer)this.ammo.get((Object)ammoType);
        }

        public int getPriAmmoForWeapon(UT3ItemType weapon) {
            if (weapon == null) {
                return 0;
            }
            if (weapon.getCategory() != UT3ItemType.Category.WEAPON) {
                return 0;
            }
            return this.getAmmo(UT3ItemType.getAmmoForWeapon(weapon));
        }

        public int getSecAmmoForWeapon(UT3ItemType weaponType) {
            return this.getPriAmmoForWeapon(weaponType);
        }

        public int getAmmoForWeapon(UT3ItemType weaponType) {
            if (weaponType == null) {
                return 0;
            }
            if (weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
                return 0;
            }
            return this.getPriAmmoForWeapon(weaponType);
        }

        public void itemPickedUp(ItemPickedUp pickedUp) {
            if (pickedUp == null) {
                return;
            }
            UT3ItemType invType = UT3ItemType.getUT3ItemType(pickedUp.getType());
            if (invType.getCategory() == UT3ItemType.Category.AMMO) {
                int current = this.getAmmo(invType);
                int amount = pickedUp.getAmount();
                ItemCategory cat = (ItemCategory)UT3Weaponry.this.weaponAmmoTypeToItemCategory.get(invType);
                if (cat != null && current + (amount = cat.getAmount()) > cat.getPriMaxAmount()) {
                    this.ammo.put((Object)invType, (Object)cat.getPriMaxAmount());
                    return;
                }
                this.ammo.put((Object)invType, (Object)(current + amount));
            } else if (invType.getCategory() == UT3ItemType.Category.WEAPON) {
                ItemCategory weaponCat = (ItemCategory)UT3Weaponry.this.weaponAmmoTypeToItemCategory.get(invType);
                UT3ItemType ammoType = UT3ItemType.getAmmoForWeapon(invType);
                if (ammoType != null) {
                    int priAmmo = (Integer)this.ammo.get((Object)ammoType);
                    int priWeaponAmmoPlus = pickedUp.getAmount();
                    int priWeaponMaxAmmo = -1;
                    ItemCategory cat = (ItemCategory)UT3Weaponry.this.weaponAmmoTypeToItemCategory.get(ammoType);
                    if (weaponCat != null) {
                        priWeaponMaxAmmo = weaponCat.getPriMaxAmount();
                    } else if (cat != null) {
                        priWeaponMaxAmmo = cat.getPriMaxAmount();
                        priWeaponAmmoPlus = cat.getAmount();
                    }
                    if (priWeaponMaxAmmo > 0 && priAmmo + priWeaponAmmoPlus > priWeaponMaxAmmo) {
                        this.ammo.put((Object)ammoType, (Object)priWeaponMaxAmmo);
                        return;
                    }
                    this.ammo.put((Object)ammoType, (Object)(priAmmo + priWeaponAmmoPlus));
                }
            }
        }

        public void weaponUpdate(UT3ItemType ammoType, int amount) {
            if (ammoType == null) {
                return;
            }
            if (ammoType.getCategory() != UT3ItemType.Category.AMMO) {
                if (UT3Weaponry.this.log.isLoggable(Level.SEVERE)) {
                    UT3Weaponry.this.log.severe("Ammunition.weaponUpdate: Can't update weapon ammo, unknown ammo type=" + ammoType.getName() + ", category=" + (Object)((Object)ammoType.getCategory()) + ", group=" + (Object)((Object)ammoType.getGroup()));
                }
                return;
            }
            this.ammo.put((Object)ammoType, (Object)amount);
        }

        public void botKilled() {
            this.ammo.clear();
        }

        public void updateWeaponAmmo(UT3Weapon weapon) {
            if (weapon == null) {
                return;
            }
            weapon.primaryAmmo = this.getAmmo(UT3ItemType.getAmmoForWeapon(weapon.getType()));
            UT3Weaponry.this.weaponsByGroup.ammoChanged(weapon.getGroup());
            UT3Weaponry.this.weaponsByUT3ItemType.ammoChanged(weapon.getType());
            UT3Weaponry.this.weaponsById.ammoChanged(weapon.getInventoryId());
        }
    }
}

