/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut3.communication.messages.UT3ItemType;
import cz.cuni.amis.utils.exception.PogamutException;

public class UT3Weapon {
    protected UT3ItemType weaponType = null;
    protected int primaryAmmo = 0;
    protected int secondaryAmmo = 0;
    protected UnrealId inventoryId;

    protected UT3Weapon(AddInventoryMsg weaponGained, int primaryAmmo, int secondaryAmmo) {
        this.weaponType = UT3ItemType.getUT3ItemType(weaponGained.getPickupType());
        if (this.weaponType.getCategory() != UT3ItemType.Category.WEAPON) {
            throw new PogamutException("Could not create Weapon class out of inventory item that is not a weapon.", (Object)this);
        }
        this.inventoryId = weaponGained.getId();
        this.primaryAmmo = primaryAmmo;
        this.secondaryAmmo = secondaryAmmo;
    }

    public UT3ItemType getType() {
        return this.weaponType;
    }

    public UT3ItemType.Group getGroup() {
        return this.weaponType.getGroup();
    }

    public int getPrimaryAmmo() {
        return this.primaryAmmo;
    }

    public int getSecondaryAmmo() {
        return this.secondaryAmmo;
    }

    public UnrealId getInventoryId() {
        return this.inventoryId;
    }

    public boolean hasSecondaryAmmoType() {
        return false;
    }

    public int getAmmo() {
        return this.getPrimaryAmmo() + this.getSecondaryAmmo();
    }

    public String toString() {
        if (this.getType() == null) {
            return "Weapon[type=UNKNOWN, primary ammo=" + this.getPrimaryAmmo() + ", secondary ammo=" + this.getSecondaryAmmo() + "]";
        }
        if (this.hasSecondaryAmmoType()) {
            return "Weapon[type=" + this.getType().getName() + ", primary ammo=" + this.getPrimaryAmmo() + ", secondary ammo=" + this.getSecondaryAmmo() + "]";
        }
        return "Weapon[type=" + this.getType().getName() + ", ammo=" + this.getPrimaryAmmo() + "]";
    }
}

