/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.tournament;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.execution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStats;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.result.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameResult;
import cz.cuni.amis.pogamut.ut2004.vip.server.CSBotRecord;
import cz.cuni.amis.pogamut.ut2004.vip.server.CSTeamsRecord;
import cz.cuni.amis.pogamut.ut2004.vip.server.UT2004VIPServer;
import cz.cuni.amis.pogamut.ut2004.vip.server.UT2004VIPServerModule;
import cz.cuni.amis.pogamut.ut2004.vip.tournament.UT2004VIPConfig;
import cz.cuni.amis.pogamut.ut2004.vip.tournament.UT2004VIPResult;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004VIP
extends UT2004Match<UT2004VIPConfig, UT2004VIPResult> {
    private String origFixedVIPNamePrefix = null;

    public UT2004VIP(UT2004VIPConfig config, LogCategory log) {
        super(false, (UT2004MatchConfig)config, log);
    }

    protected void changeBotTeam(UT2004Server server, UnrealId botId, int desiredTeam) {
    }

    protected UT2004MatchResult waitMatchFinish(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, long timeoutInMillis) {
        Object object;
        FlagListener<IAgentState> serverObs;
        HashMap<IToken, 1> customBotObservers;
        block31: {
            long minTimeoutMillis;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Waiting for the match to finish...");
            }
            if ((minTimeoutMillis = Math.round((double)((UT2004VIPConfig)this.config).getVIPConfig().getRoundCount() * ((UT2004VIPConfig)this.config).getVIPConfig().getRoundTimeUT() * 1000.0 + (double)(((UT2004VIPConfig)this.config).getVIPConfig().getRoundCount() * 60 * 1000) + 300000.0)) > timeoutInMillis) {
                timeoutInMillis = minTimeoutMillis;
                this.log.warning(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": match global timeout set to " + minTimeoutMillis / 1000L + " seconds");
            }
            customBotObservers = new HashMap<IToken, 1>(((UT2004VIPConfig)this.config).getBots().size());
            serverObs = null;
            FlagListener<Boolean> uccObs = null;
            FlagListener<Boolean> hsGameRunning = null;
            final CountDownLatch waitLatch = new CountDownLatch(1);
            final AdaptableProvider oneOfBotsDiedOut = new AdaptableProvider((Object)false);
            final AdaptableProvider serverDiedOut = new AdaptableProvider((Object)false);
            boolean exception = false;
            try {
                for (UT2004BotConfig botConfig : ((UT2004VIPConfig)this.config).getBots().values()) {
                    FlagListener<Boolean> obs = new FlagListener<Boolean>(){

                        public void flagChanged(Boolean changedValue) {
                            if (!changedValue.booleanValue()) {
                                oneOfBotsDiedOut.set((Object)true);
                                waitLatch.countDown();
                            }
                        }
                    };
                    ((UT2004BotExecution)bots.bots.get(botConfig.getBotId())).getRunning().addListener((FlagListener)obs);
                    customBotObservers.put(botConfig.getBotId(), obs);
                    if (((Boolean)((UT2004BotExecution)bots.bots.get(botConfig.getBotId())).getRunning().getFlag()).booleanValue()) continue;
                    oneOfBotsDiedOut.set((Object)true);
                    waitLatch.countDown();
                    throw new PogamutException("One of custom bots died out from the start, failure!", (Logger)this.log, (Object)this);
                }
                serverObs = new FlagListener<IAgentState>(){

                    public void flagChanged(IAgentState changedValue) {
                        if (changedValue instanceof IAgentStateDown) {
                            serverDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                server.getState().addListener((FlagListener)serverObs);
                if (server.notInState(new Class[]{IAgentStateUp.class})) {
                    serverDiedOut.set((Object)true);
                    waitLatch.countDown();
                    throw new PogamutException("Server is dead from the start, failure!", (Logger)this.log, (Object)this);
                }
                if (!((Boolean)((UT2004VIPServer)server).isGameRunning().getFlag()).booleanValue()) {
                    serverDiedOut.set((Object)true);
                    waitLatch.countDown();
                    throw new PogamutException("Hide&Seek game is not running at the beginning, invalid!", (Logger)this.log, (Object)this);
                }
                hsGameRunning = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (!changedValue.booleanValue()) {
                            waitLatch.countDown();
                        }
                    }
                };
                ((UT2004VIPServer)server).isGameRunning().addListener((FlagListener)hsGameRunning);
                uccObs = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (changedValue.booleanValue()) {
                            serverDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                ucc.getGameEnding().addListener((FlagListener)uccObs);
                waitLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                if (waitLatch.getCount() > 0L) {
                    throw new PogamutException("TIMEOUT! The match did not end in " + timeoutInMillis / 1000L + " secs.", (Logger)this.log, (Object)this);
                }
                bots.matchEnd = System.currentTimeMillis();
                if (((Boolean)oneOfBotsDiedOut.get()).booleanValue()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new PogamutInterruptedException("Interrupted while giving GB2004 time to tear down its connection.", (Logger)this.log, (Object)this);
                    }
                    try {
                        server.getAct().act((CommandMessage)new StartPlayers());
                    }
                    catch (Exception e) {
                        serverDiedOut.set((Object)true);
                    }
                    if (!((Boolean)serverDiedOut.get()).booleanValue()) {
                        this.log.warning("ONE OF BOTS HAS DIED OUT, BUT SERVER IS STILL RUNNING ... POSSIBLE MATCH FAILURE!");
                    }
                }
                if (((Boolean)((UT2004VIPServer)server).getGameFailed().getFlag()).booleanValue()) {
                    throw new PogamutException("UT2004HSServer reported failure!", (Logger)this.log, (Object)this);
                }
                if (!((Boolean)serverDiedOut.get()).booleanValue() && server.inState(new Class[]{IAgentStateUp.class})) {
                    server.kill();
                }
                if (ucc != null) {
                    try {
                        if (this.log != null && this.log.isLoggable(Level.INFO)) {
                            this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        ucc.stop();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                UT2004VIPServer vipServer = (UT2004VIPServer)server;
                HashMap<IToken, CSBotRecord<PlayerMessage>> botRecordMap = new HashMap<IToken, CSBotRecord<PlayerMessage>>();
                ArrayList<CSBotRecord<PlayerMessage>> botRecords = new ArrayList<CSBotRecord<PlayerMessage>>();
                for (Map.Entry<UnrealId, CSBotRecord<PlayerMessage>> entryRecord : vipServer.getBotRecords().entrySet()) {
                    if (entryRecord.getValue().getPlayer() == null || entryRecord.getValue().getPlayer().getJmx() == null) continue;
                    IToken botId = (IToken)bots.unrealId2BotId.get(entryRecord.getKey());
                    botRecordMap.put(botId, entryRecord.getValue());
                    botRecords.add(entryRecord.getValue());
                }
                CSTeamsRecord teamsRecord = vipServer.getTeamsRecord();
                VIPGameResult result = teamsRecord.getResult();
                ArrayList<IToken> winners = new ArrayList<IToken>(1);
                int maxScore = teamsRecord.getScore(result.team);
                for (Map.Entry entry : botRecordMap.entrySet()) {
                    if (((PlayerMessage)((CSBotRecord)entry.getValue()).getPlayer()).getTeam() != result.team.ut2004Team) continue;
                    winners.add((IToken)entry.getKey());
                }
                if (result != VIPGameResult.DRAW && winners.size() == 0) {
                    throw new PogamutException("Result " + (Object)((Object)result) + ", but no WINNERs, impossible! **puzzled**", (Logger)this.log, (Object)this);
                }
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": MATCH FINISHED!");
                }
                object = this.processResults(ucc, server, analyzer, bots, winners, botRecordMap, teamsRecord);
                if (hsGameRunning == null) break block31;
            }
            catch (Exception e) {
                try {
                    exception = true;
                    throw new PogamutException("Failed to perform the match!", (Throwable)e, (Logger)this.log, (Object)this);
                }
                catch (Throwable throwable) {
                    if (hsGameRunning != null) {
                        ((UT2004VIPServer)server).isGameRunning().removeListener(hsGameRunning);
                        hsGameRunning = null;
                    }
                    for (Map.Entry entry : customBotObservers.entrySet()) {
                        ((UT2004BotExecution)bots.bots.get(entry.getKey())).getRunning().removeListener((FlagListener)entry.getValue());
                    }
                    server.getState().removeListener(serverObs);
                    throw throwable;
                }
            }
            ((UT2004VIPServer)server).isGameRunning().removeListener((FlagListener)hsGameRunning);
            hsGameRunning = null;
        }
        for (Map.Entry entry : customBotObservers.entrySet()) {
            ((UT2004BotExecution)bots.bots.get(entry.getKey())).getRunning().removeListener((FlagListener)entry.getValue());
        }
        server.getState().removeListener((FlagListener)serverObs);
        return object;
    }

    protected UT2004VIPResult processResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, List<IToken> winners, Map<IToken, CSBotRecord<PlayerMessage>> botRecords, CSTeamsRecord teamsRecord) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Processing results...");
        }
        ((UT2004VIPConfig)this.config).getVIPConfig().setFixedVIPNamePrefix(this.origFixedVIPNamePrefix);
        UT2004VIPResult result = new UT2004VIPResult();
        result.setGameResult(teamsRecord.getResult());
        result.setTeamsRecord(teamsRecord);
        result.setBots(MyCollections.asList(bots.botId2UnrealId.keySet()));
        result.setBotIds(bots.botId2UnrealId);
        for (Map.Entry entry : bots.botObservers.entrySet()) {
            if (!(entry.getValue() instanceof UT2004AnalyzerObsStats)) {
                throw new PogamutException("There is an observer of wrong class, expecting UT2004AnalyzerObsStats, got " + ((IUT2004AnalyzerObserver)entry.getValue()).getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
            }
            result.getBotObservers().put((IToken)entry.getKey(), (UT2004AnalyzerObsStats)entry.getValue());
        }
        result.setWinnerBotIds(winners);
        result.setMatchTime(((double)bots.matchEnd - (double)bots.matchStart) / 1000.0);
        result.setScoreDetails(botRecords);
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Results processed, " + (Object)((Object)result.getGameResult()) + ", #Winners = " + result.getWinnerBotIds().size() + ", Winners score = " + result.getWinnerScore());
        }
        return result;
    }

    protected void outputResults_step1(UT2004VIPResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Outputting match result into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004VIPConfig)this.config).getMatchId().getToken() + "-result.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            writer.format("MatchId;GameResult;WinnerScore;MatchTimeSecs;" + ((UT2004VIPConfig)this.config).getVIPConfig().getCSVHeader() + "", new Object[0]);
            for (int i = 0; i < result.getWinnerBotIds().size(); ++i) {
                writer.format(";Winner" + (i + 1), new Object[0]);
            }
            writer.format("\n", new Object[0]);
            writer.format("%s;%d;%.3f;", new Object[]{((UT2004VIPConfig)this.config).getMatchId().getToken(), result.getGameResult(), result.getWinnerScore(), result.getMatchTime()});
            ((UT2004VIPConfig)this.config).getVIPConfig().formatCSVLine(writer);
            for (IToken winner : result.getWinnerBotIds()) {
                writer.format(";%s", winner.getToken());
            }
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Match result output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults_step2(UT2004VIPResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Outputting match scores into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004VIPConfig)this.config).getMatchId().getToken() + "-bot-scores.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            ArrayList<IToken> bots = new ArrayList<IToken>(result.getBots());
            Collections.sort(bots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            writer.format("BotId;Team;Rounds;VIPCount;CounterTerroristCount;TerroristCount", new Object[0]);
            for (IToken token1 : bots) {
                writer.format("\n", new Object[0]);
                writer.format(token1.getToken(), new Object[0]);
                CSBotRecord<PlayerMessage> record = result.getScoreDetails().get(token1);
                writer.format(";%d", new Object[]{record.getMyTeam()});
                writer.format(";%d", record.getVIPCount() + record.getCTCount() + record.getTCount());
                writer.format(";%d", record.getVIPCount());
                writer.format(";%d", record.getCTCount());
                writer.format(";%d", record.getTCount());
            }
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Match scores output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, UT2004MatchResult result, File outputDirectory) {
        if (!(result instanceof UT2004VIPResult)) {
            throw new PogamutException("Can't out results! Expected results of class UT2004HideAndSeekResult and got " + result.getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
        }
        this.outputResults_step1((UT2004VIPResult)result, outputDirectory);
        this.outputResults_step2((UT2004VIPResult)result, outputDirectory);
    }

    protected UT2004Server startControlServer(UCCWrapper ucc) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Starting UT2004Server...");
        }
        NullCheck.check((Object)ucc, (String)"ucc");
        UT2004VIPServerModule module = new UT2004VIPServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory((UT2004ServerModule)module);
        UT2004Server server = (UT2004Server)factory.newAgent((IAgentParameters)new UT2004AgentParameters().setAgentId((IAgentId)new AgentId(((UT2004VIPConfig)this.config).getMatchId().getToken() + "-UT2004Server")).setWorldAddress((IWorldConnectionAddress)ucc.getServerAddress()));
        server.start();
        if (!server.inState(new Class[]{IAgentStateRunning.class})) {
            throw new PogamutException("Failed to start UT2004VIP!", (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": UT2004VIP started.");
        }
        return server;
    }

    protected void matchIsAboutToBegin(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots) {
        super.matchIsAboutToBegin(ucc, server, analyzer, bots);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException((Throwable)e, (Object)this);
        }
        ((UT2004VIPConfig)this.config).getVIPConfig().setObserverPort(ucc.getObserverPort());
        UT2004VIPServer vipServer = (UT2004VIPServer)server;
        vipServer.startGame(((UT2004VIPConfig)this.config).getVIPConfig());
    }

    public UT2004VIPResult execute() {
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Executing!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        UCCWrapper ucc = null;
        UT2004Server server = null;
        UT2004Match.Bots bots = null;
        UT2004Analyzer analyzer = null;
        String recordFileName = ((UT2004VIPConfig)this.config).getMatchId().getToken() + "-replay-" + UT2004Match.getCurrentDate();
        boolean exception = false;
        try {
            this.setupLogger();
            this.validate();
            this.createUT2004Ini();
            this.createGB2004Ini();
            ucc = this.startUCC();
            server = this.startControlServer(ucc);
            bots = this.startBots(ucc, server);
            analyzer = this.startAnalyzer(ucc, bots, this.getOutputPath("bots"), ((UT2004VIPConfig)this.config).isHumanLikeLogEnabled());
            this.restartMatch(server, bots);
            this.recordReplay(server, recordFileName);
            this.matchIsAboutToBegin(ucc, server, analyzer, bots);
            UT2004VIPResult result = (UT2004VIPResult)this.waitMatchFinish(ucc, server, analyzer, bots, 0L);
            this.copyReplay(ucc, recordFileName, this.getOutputPath());
            this.outputResults(ucc, server, analyzer, bots, result, this.getOutputPath());
            this.shutdownAll(ucc, server, analyzer, bots);
            ucc = null;
            server = null;
            analyzer = null;
            bots = null;
            UT2004VIPResult uT2004VIPResult = result;
            return uT2004VIPResult;
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": EXCEPTION!"), (Throwable)e));
            }
            exception = true;
            if (e instanceof PogamutException) {
                throw (PogamutException)e;
            }
            throw new PogamutException((Throwable)e, (Logger)this.log, (Object)this);
        }
        finally {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Cleaning up...");
                }
            }
            catch (Exception exception2) {}
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                    }
                }
                catch (Exception exception3) {}
                try {
                    ucc.stop();
                }
                catch (Exception exception4) {}
            }
            if (server != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Killing UT2004Server...");
                    }
                }
                catch (Exception exception5) {}
                try {
                    server.kill();
                }
                catch (Exception exception6) {}
            }
            if (bots != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Killing Custom bots...");
                    }
                }
                catch (Exception exception7) {}
                for (UT2004BotExecution exec : bots.bots.values()) {
                    try {
                        exec.stop();
                    }
                    catch (Exception exception8) {}
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Killing Custom bot observers...");
                    }
                }
                catch (Exception exception9) {}
                for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                    try {
                        obs.kill();
                    }
                    catch (Exception exception10) {}
                }
                if (analyzer != null) {
                    // empty if block
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Killing UT2004Analyzer...");
                    }
                }
                catch (Exception exception11) {}
                try {
                    analyzer.kill();
                }
                catch (Exception exception12) {}
            }
            try {
                this.restoreUT2004IniBackup();
            }
            catch (Exception exception13) {}
            try {
                this.restoreGB2004IniBackup();
            }
            catch (Exception exception14) {}
            try {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    if (exception) {
                        this.log.warning(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Cleaned up, MATCH FAILED!");
                    } else {
                        this.log.warning(((UT2004VIPConfig)this.config).getMatchId().getToken() + ": Cleaned up, match finished successfully.");
                    }
                }
            }
            catch (Exception exception15) {}
            try {
                this.closeLogger();
            }
            catch (Exception exception16) {}
        }
    }
}

