/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.tournament;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameConfig;
import cz.cuni.amis.pogamut.ut2004.vip.tournament.UT2004VIP;
import cz.cuni.amis.pogamut.ut2004.vip.tournament.UT2004VIPConfig;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class UT2004VIPConsole {
    private static final char ARG_UT2004_HOME_DIR_SHORT = 'u';
    private static final String ARG_UT2004_HOME_DIR_LONG = "ut2004-home-dir";
    private static final char ARG_BOT_JARs_SHORT = 'a';
    private static final String ARG_BOT_JARs_LONG = "bot-jars";
    private static final char ARG_BOT_NAMEs_SHORT = 'b';
    private static final String ARG_BOT_NAMEs_LONG = "bot-names";
    private static final char ARG_BOT_TEAMs_SHORT = 'c';
    private static final String ARG_BOT_TEAMs_LONG = "bot-teams";
    private static final char ARG_MAP_NAME_SHORT = 'm';
    private static final String ARG_MAP_NAME_LONG = "map-name";
    private static final char ARG_MATCH_NAME_SHORT = 'n';
    private static final String ARG_MATCH_NAME_LONG = "match-name";
    private static final char ARG_RESULT_DIR_SHORT = 'r';
    private static final String ARG_RESULT_DIR_LONG = "result-directory";
    private static final char ARG_SERVER_NAME_SHORT = 's';
    private static final String ARG_SERVER_NAME_LONG = "server-name";
    private static final char ARG_HUMAN_LIKE_LOG_SHORT = 'h';
    private static final String ARG_HUMAN_LIKE_LOG_LONG = "human-like-log";
    private static final char ARG_UT2004_PORT_SHORT = 'p';
    private static final String ARG_UT2004_PORT_LONG = "ut2004-port";
    private static final char ARG_CT_SPAWN_AREAS_SHORT = 'i';
    private static final String ARG_CT_SPAWN_AREAS_LONG = "ct-spawn-areas";
    private static final char ARG_T_SPAWN_AREAS_SHORT = 'j';
    private static final String ARG_T_SPAWN_AREAS_LONG = "t-spawn-areas";
    private static final char ARG_VIP_SAFE_AREAS_SHORT = 'k';
    private static final String ARG_VIP_SAFE_AREAS_LONG = "vip-safe-areas";
    private static final char ARG_VIP_SAFE_AREA_RADIUS_SHORT = 'l';
    private static final String ARG_VIP_SAFE_AREA_RADIUS_LONG = "vip-safe-area-radius";
    private static final char ARG_ROUND_COUNT_SHORT = 'd';
    private static final String ARG_ROUND_COUNT_LONG = "round-count";
    private static final char ARG_ROUND_TIME_SECS_SHORT = 't';
    private static final String ARG_ROUND_TIME_SECS_LONG = "round-time-secs";
    private static final char ARG_FIXED_VIP_NAME_SHORT = 'x';
    private static final String ARG_FIXED_VIP_NAME_LONG = "fixed-vip-name-prefix";
    private static final char ARG_SCORE_VIP_KILLED_CT_SHORT = '1';
    private static final String ARG_SCORE_VIP_KILLED_CT_LONG = "score-vip-killed-counter-terrorists";
    private static final char ARG_SCORE_VIP_KILLED_T_SHORT = '2';
    private static final String ARG_SCORE_VIP_KILLED_T_LONG = "score-vip-killed-terrorists";
    private static final char ARG_SCORE_VIP_SAFE_CT_SHORT = '3';
    private static final String ARG_SCORE_VIP_SAFE_CT_LONG = "score-vip-safe-counter-terrorists";
    private static final char ARG_SCORE_VIP_SAFE_T_SHORT = '4';
    private static final String ARG_SCORE_VIP_SAFE_T_LONG = "score-vip-safe-terrorists";
    private static JSAP jsap;
    private static JSAPResult config;
    private static boolean headerOutput;
    private static String ut2004HomeDir;
    private static String botJars;
    private static String[] botJarsSeparated;
    private static String botNames;
    private static String[] botNamesSeparated;
    private static String botTeams;
    private static String[] botTeamsSeparated;
    private static String ctSpawnAreas;
    private static String[] ctSpawnAreasSeparated;
    private static String tSpawnAreas;
    private static String[] tSpawnAreasSeparated;
    private static String vipSafeAreas;
    private static String[] vipSafeAreasSeparated;
    private static String map;
    private static String serverName;
    private static String resultDir;
    private static String matchName;
    private static File ut2004HomeDirFile;
    private static File[] botJarFiles;
    private static File mapsDirFile;
    private static File mapFile;
    private static File ut2004SystemDirFile;
    private static File ut2004IniFile;
    private static boolean humanLikeLog;
    private static int ut2004Port;
    private static VIPGameConfig gameConfig;

    static {
        headerOutput = false;
    }

    private static void fail(String errorMessage) {
        UT2004VIPConsole.fail(errorMessage, null);
    }

    private static void fail(String errorMessage, Throwable e) {
        UT2004VIPConsole.header();
        System.out.println("ERROR: " + errorMessage);
        System.out.println();
        if (e != null) {
            e.printStackTrace();
            System.out.println("");
        }
        System.out.println("Usage: java -jar ut2004-vip....jar ");
        System.out.println("                " + jsap.getUsage());
        System.out.println();
        System.out.println(jsap.getHelp());
        System.out.println();
        throw new RuntimeException("FAILURE: " + errorMessage);
    }

    private static void header() {
        if (headerOutput) {
            return;
        }
        System.out.println();
        System.out.println("=================================");
        System.out.println("Pogamut UT2004 VIP Match Executor");
        System.out.println("=================================");
        System.out.println();
        headerOutput = true;
    }

    private static void initJSAP() throws JSAPException {
        jsap = new JSAP();
        FlaggedOption opt1 = new FlaggedOption(ARG_UT2004_HOME_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('u').setLongFlag(ARG_UT2004_HOME_DIR_LONG);
        opt1.setHelp("UT2004 home directory containing GameBots2004 (System/GameBots2004.u) present.");
        jsap.registerParameter((Parameter)opt1);
        FlaggedOption opt2 = new FlaggedOption(ARG_BOT_JARs_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('a').setLongFlag(ARG_BOT_JARs_LONG);
        opt2.setHelp("Semicolon separated PATH/TO/JAR/file1;PATH/TO/JAR/file2 containing executable jars of bots.");
        jsap.registerParameter((Parameter)opt2);
        FlaggedOption opt3 = new FlaggedOption(ARG_BOT_NAMEs_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('b').setLongFlag(ARG_BOT_NAMEs_LONG);
        opt3.setHelp("Semicolon separated name1;name2;name3 (ids) that should be given to bots.");
        jsap.registerParameter((Parameter)opt3);
        FlaggedOption opt6 = new FlaggedOption(ARG_MAP_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('m').setLongFlag(ARG_MAP_NAME_LONG).setDefault("DM-TraningDay");
        opt6.setHelp("Map where the game should be played (e.g. DM-1on1-TagMap).");
        jsap.registerParameter((Parameter)opt6);
        FlaggedOption opt7 = new FlaggedOption(ARG_MATCH_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('n').setLongFlag(ARG_MATCH_NAME_LONG).setDefault("HideAndSeekGame");
        opt7.setHelp("Name of the match == output folder for the results.");
        jsap.registerParameter((Parameter)opt7);
        FlaggedOption opt8 = new FlaggedOption(ARG_RESULT_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('r').setLongFlag(ARG_RESULT_DIR_LONG).setDefault(".");
        opt8.setHelp("PATH/TO/directory where to output results (does not need to exist).");
        jsap.registerParameter((Parameter)opt8);
        FlaggedOption opt9 = new FlaggedOption(ARG_SERVER_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('s').setLongFlag(ARG_SERVER_NAME_LONG).setDefault("HideAndSeekGame");
        opt9.setHelp("Server name that should be advertised via LAN.");
        jsap.registerParameter((Parameter)opt9);
        Switch opt10 = new Switch(ARG_HUMAN_LIKE_LOG_LONG).setShortFlag('h').setLongFlag(ARG_HUMAN_LIKE_LOG_LONG).setDefault("false");
        opt10.setHelp("Whether to produce log for 'HumanLike Project' analysis.");
        jsap.registerParameter((Parameter)opt10);
        FlaggedOption opt11 = new FlaggedOption(ARG_UT2004_PORT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('p').setLongFlag(ARG_UT2004_PORT_LONG).setDefault("7777");
        opt11.setHelp("UT2004 port for the dedicated server (1-32000).");
        jsap.registerParameter((Parameter)opt11);
        FlaggedOption opt12 = new FlaggedOption(ARG_CT_SPAWN_AREAS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('i').setLongFlag(ARG_CT_SPAWN_AREAS_LONG).setDefault("[2000;-915;-50],[-1000;415;25]");
        opt12.setHelp("Area where counter-terrorist (blue) team may spawn, format [x;y;z](,[x;y;z]){0,}. If multiple locations are provided, they will be chosen from at random every round. Default is configured for DM-TraningDay map.");
        jsap.registerParameter((Parameter)opt12);
        FlaggedOption opt13 = new FlaggedOption(ARG_T_SPAWN_AREAS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('j').setLongFlag(ARG_T_SPAWN_AREAS_LONG).setDefault("[2000;-915;-50],[-1000;415;25]");
        opt13.setHelp("Area where terrorist (red) team may spawn, format [x;y;z](,[x;y;z]){0,}. If multiple locations are provided, they will be chosen from at random every round. Default is configured for DM-TraningDay map.");
        jsap.registerParameter((Parameter)opt13);
        FlaggedOption opt14 = new FlaggedOption(ARG_VIP_SAFE_AREAS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('k').setLongFlag(ARG_VIP_SAFE_AREAS_LONG).setDefault("[2000;-915;-50],[-1000;415;25]");
        opt14.setHelp("Safe area VIP needs to reach in order for counter-terrorist (blue) team to win, format [x;y;z](,[x;y;z]){0,}. If multiple locations are provided, they will be chosen from at random every round. Default is configured for DM-TraningDay map.");
        jsap.registerParameter((Parameter)opt14);
        FlaggedOption opt15 = new FlaggedOption(ARG_VIP_SAFE_AREA_RADIUS_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('l').setLongFlag(ARG_VIP_SAFE_AREA_RADIUS_LONG).setDefault("100");
        opt15.setHelp("How big is the safe area around the vip safe area point.");
        jsap.registerParameter((Parameter)opt15);
        FlaggedOption opt16 = new FlaggedOption(ARG_ROUND_COUNT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('d').setLongFlag(ARG_ROUND_COUNT_LONG).setDefault("10");
        opt16.setHelp("Number of VIP game rounds to be played.");
        jsap.registerParameter((Parameter)opt16);
        FlaggedOption opt17 = new FlaggedOption(ARG_ROUND_TIME_SECS_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('t').setLongFlag(ARG_ROUND_TIME_SECS_LONG).setDefault("300");
        opt17.setHelp("Total length of single VIP game round. If VIP does not reach safe area by this time, terrorist (red) team wins.");
        jsap.registerParameter((Parameter)opt17);
        FlaggedOption opt18 = new FlaggedOption(ARG_FIXED_VIP_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('x').setLongFlag(ARG_FIXED_VIP_NAME_LONG);
        opt18.setHelp("When specified, all VIP rounds will be played with fixed VIP; player in counter-terrorist (blue) team with the name that will begin with specified string will always be given a role of VIP.");
        jsap.registerParameter((Parameter)opt18);
        FlaggedOption opt20 = new FlaggedOption(ARG_SCORE_VIP_KILLED_CT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('1').setLongFlag(ARG_SCORE_VIP_KILLED_CT_LONG).setDefault("0");
        opt20.setHelp("Penalization-score for counter-terrorist (blue) team to be given to for losing the round.");
        jsap.registerParameter((Parameter)opt20);
        FlaggedOption opt21 = new FlaggedOption(ARG_SCORE_VIP_KILLED_T_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('2').setLongFlag(ARG_SCORE_VIP_KILLED_T_LONG).setDefault("100");
        opt21.setHelp("Score for terrorist (red) team to be awarded with for winning the round.");
        jsap.registerParameter((Parameter)opt21);
        FlaggedOption opt22 = new FlaggedOption(ARG_SCORE_VIP_KILLED_CT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('1').setLongFlag(ARG_SCORE_VIP_KILLED_CT_LONG).setDefault("100");
        opt22.setHelp("Score for counter-terrorist (blue) team to be awarded with for winning the round.");
        jsap.registerParameter((Parameter)opt22);
        FlaggedOption opt23 = new FlaggedOption(ARG_SCORE_VIP_KILLED_T_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('2').setLongFlag(ARG_SCORE_VIP_KILLED_T_LONG).setDefault("0");
        opt23.setHelp("Penalization-score for terrorist (red) team to be given to for losing the round.");
        jsap.registerParameter((Parameter)opt23);
    }

    /*
     * Unable to fully structure code
     */
    private static void readConfig(String[] args) {
        block17: {
            block18: {
                System.out.println("Parsing command arguments.");
                try {
                    UT2004VIPConsole.config = UT2004VIPConsole.jsap.parse(args);
                }
                catch (Exception e) {
                    UT2004VIPConsole.fail(e.getMessage());
                    System.out.println("");
                    e.printStackTrace();
                    throw new RuntimeException("FAILURE!");
                }
                if (UT2004VIPConsole.config.success()) break block17;
                error = "Invalid arguments specified.";
                errorIter = UT2004VIPConsole.config.getErrorMessageIterator();
                if (errorIter.hasNext()) ** GOTO lbl17
                error = String.valueOf(error) + "\n-- No details given.";
                break block18;
lbl-1000:
                // 1 sources

                {
                    error = String.valueOf(error) + "\n-- " + errorIter.next();
lbl17:
                    // 2 sources

                    ** while (errorIter.hasNext())
                }
            }
            UT2004VIPConsole.fail(error);
        }
        UT2004VIPConsole.ut2004HomeDir = UT2004VIPConsole.config.getString("ut2004-home-dir");
        UT2004VIPConsole.botJars = UT2004VIPConsole.config.getString("bot-jars");
        UT2004VIPConsole.botJarsSeparated = UT2004VIPConsole.botJars == null ? null : UT2004VIPConsole.botJars.split(";");
        UT2004VIPConsole.botNames = UT2004VIPConsole.config.getString("bot-names");
        UT2004VIPConsole.botNamesSeparated = UT2004VIPConsole.botNames == null ? null : UT2004VIPConsole.botNames.split(";");
        UT2004VIPConsole.botTeams = UT2004VIPConsole.config.getString("bot-teams");
        UT2004VIPConsole.botTeamsSeparated = UT2004VIPConsole.botTeams == null ? null : UT2004VIPConsole.botTeams.split(";");
        UT2004VIPConsole.ctSpawnAreas = UT2004VIPConsole.config.getString("ct-spawn-areas");
        UT2004VIPConsole.ctSpawnAreasSeparated = UT2004VIPConsole.ctSpawnAreas == null ? null : UT2004VIPConsole.tSpawnAreas.split(",");
        UT2004VIPConsole.tSpawnAreas = UT2004VIPConsole.config.getString("t-spawn-areas");
        UT2004VIPConsole.tSpawnAreasSeparated = UT2004VIPConsole.tSpawnAreas == null ? null : UT2004VIPConsole.tSpawnAreas.split(",");
        UT2004VIPConsole.vipSafeAreas = UT2004VIPConsole.config.getString("t-spawn-areas");
        UT2004VIPConsole.vipSafeAreasSeparated = UT2004VIPConsole.vipSafeAreas == null ? null : UT2004VIPConsole.vipSafeAreas.split(",");
        UT2004VIPConsole.map = UT2004VIPConsole.config.getString("map-name");
        UT2004VIPConsole.serverName = UT2004VIPConsole.config.getString("server-name");
        UT2004VIPConsole.resultDir = UT2004VIPConsole.config.getString("result-directory");
        UT2004VIPConsole.matchName = UT2004VIPConsole.config.getString("match-name");
        UT2004VIPConsole.humanLikeLog = UT2004VIPConsole.config.getBoolean("human-like-log");
        UT2004VIPConsole.ut2004Port = UT2004VIPConsole.config.getInt("ut2004-port");
        UT2004VIPConsole.gameConfig = new VIPGameConfig();
        UT2004VIPConsole.gameConfig.setTargetMap(UT2004VIPConsole.map);
        fixedVIP = UT2004VIPConsole.config.getString("fixed-vip-name-prefix");
        if (fixedVIP == null) {
            UT2004VIPConsole.gameConfig.setFixedVIP(false);
            UT2004VIPConsole.gameConfig.setFixedVIPNamePrefix(null);
        } else {
            UT2004VIPConsole.gameConfig.setFixedVIP(true);
            UT2004VIPConsole.gameConfig.setFixedVIPNamePrefix(fixedVIP);
        }
        UT2004VIPConsole.gameConfig.setRoundTimeUT(UT2004VIPConsole.config.getInt("round-time-secs"));
        UT2004VIPConsole.gameConfig.setRoundCount(UT2004VIPConsole.config.getInt("round-count"));
        if (UT2004VIPConsole.ctSpawnAreasSeparated != null) {
            areas = new ArrayList<Location>();
            var6_4 = UT2004VIPConsole.ctSpawnAreasSeparated;
            var5_5 = UT2004VIPConsole.ctSpawnAreasSeparated.length;
            var4_6 = 0;
            while (var4_6 < var5_5) {
                area = var6_4[var4_6];
                try {
                    loc = new Location(area.trim());
                    areas.add(loc);
                }
                catch (Exception e) {
                    UT2004VIPConsole.fail("Failed to parse '--ct-spawn-areas " + UT2004VIPConsole.config.getString("ct-spawn-areas") + "'; Required format [x;y;z], multiple locations must be ',' separated.");
                }
                ++var4_6;
            }
            UT2004VIPConsole.gameConfig.setCtsSpawnAreas(areas.toArray(new Location[0]));
        }
        if (UT2004VIPConsole.tSpawnAreasSeparated != null) {
            areas = new ArrayList<E>();
            var6_4 = UT2004VIPConsole.tSpawnAreasSeparated;
            var5_5 = UT2004VIPConsole.tSpawnAreasSeparated.length;
            var4_6 = 0;
            while (var4_6 < var5_5) {
                area = var6_4[var4_6];
                try {
                    loc = new Location(area.trim());
                    areas.add(loc);
                }
                catch (Exception e) {
                    UT2004VIPConsole.fail("Failed to parse '--t-spawn-areas " + UT2004VIPConsole.config.getString("t-spawn-areas") + "'; Required format [x;y;z], multiple locations must be ',' separated.");
                }
                ++var4_6;
            }
            UT2004VIPConsole.gameConfig.setTsSpawnAreas(areas.toArray(new Location[0]));
        }
        if (UT2004VIPConsole.vipSafeAreasSeparated != null) {
            areas = new ArrayList<E>();
            var6_4 = UT2004VIPConsole.vipSafeAreasSeparated;
            var5_5 = UT2004VIPConsole.vipSafeAreasSeparated.length;
            var4_6 = 0;
            while (var4_6 < var5_5) {
                area = var6_4[var4_6];
                try {
                    loc = new Location(area.trim());
                    areas.add(loc);
                }
                catch (Exception e) {
                    UT2004VIPConsole.fail("Failed to parse '--vip-safe-areas " + UT2004VIPConsole.config.getString("vip-safe-areas") + "'; Required format [x;y;z], multiple locations must be ',' separated.");
                }
                ++var4_6;
            }
            UT2004VIPConsole.gameConfig.setVipSafeAreas(areas.toArray(new Location[0]));
        }
        UT2004VIPConsole.gameConfig.setVipSafeAreaRadius(UT2004VIPConsole.config.getInt("vip-safe-area-radius"));
        UT2004VIPConsole.gameConfig.setVipKilledCTsScore(UT2004VIPConsole.config.getInt("score-vip-killed-counter-terrorists"));
        UT2004VIPConsole.gameConfig.setVipKilledTsScore(UT2004VIPConsole.config.getInt("score-vip-killed-terrorists"));
        UT2004VIPConsole.gameConfig.setVipSafeCTsScore(UT2004VIPConsole.config.getInt("score-vip-safe-counter-terrorists"));
        UT2004VIPConsole.gameConfig.setVipSafeTsScore(UT2004VIPConsole.config.getInt("score-vip-safe-terrorists"));
    }

    private static void sanityChecks() {
        System.out.println("Sanity checks...");
        if (botJarsSeparated == null) {
            UT2004VIPConsole.fail("Bot jar(s) was/were not specified correctly.");
        }
        if (botNamesSeparated == null) {
            UT2004VIPConsole.fail("Bot name(s) was/were not specified correctly.");
        }
        if (botTeamsSeparated == null) {
            UT2004VIPConsole.fail("Bot team(s) was/were not specified correctly.");
        }
        if (botJarsSeparated.length != botNamesSeparated.length) {
            UT2004VIPConsole.fail("Bot jar(s) and name(s) numbers mismatch. I've parsed " + botJarsSeparated.length + " bot jar files != " + botNamesSeparated.length + " of bot names.");
        }
        if (botJarsSeparated.length != botTeamsSeparated.length) {
            UT2004VIPConsole.fail("Bot jar(s) and team(s) numbers mismatch. I've parsed " + botJarsSeparated.length + " bot jar files != " + botTeamsSeparated.length + " of bot teams.");
        }
        if (!(ut2004HomeDirFile = new File(ut2004HomeDir)).exists() || !ut2004HomeDirFile.isDirectory()) {
            UT2004VIPConsole.fail("UT2004 directory was not found at '" + ut2004HomeDirFile.getAbsolutePath() + "', path resolved from configuration read as '" + ut2004HomeDir + "'.");
        }
        System.out.println("-- UT2004 directory found at '" + ut2004HomeDirFile.getAbsolutePath() + "'");
        ut2004SystemDirFile = new File(ut2004HomeDirFile, "System");
        if (!ut2004SystemDirFile.exists() || !ut2004SystemDirFile.isDirectory()) {
            UT2004VIPConsole.fail("UT2004/System directory was not found at '" + ut2004SystemDirFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/System directory found at '" + ut2004SystemDirFile.getAbsolutePath() + "'");
        ut2004IniFile = new File(ut2004SystemDirFile, "UT2004.ini");
        if (!ut2004IniFile.exists() || !ut2004IniFile.isFile()) {
            UT2004VIPConsole.fail("UT2004/System/UT2004.ini file was not found at '" + ut2004IniFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/System/UT2004.ini file found at '" + ut2004IniFile.getAbsolutePath() + "'");
        botJarFiles = new File[botJarsSeparated.length];
        int i = 0;
        while (i < botJarsSeparated.length) {
            UT2004VIPConsole.botJarFiles[i] = new File(botJarsSeparated[i]);
            if (!botJarFiles[i].exists() || !botJarFiles[i].isFile()) {
                UT2004VIPConsole.fail("Bot" + (i + 1) + " jar file was not found at '" + botJarFiles[i].getAbsolutePath() + "', path resolved from configuration read as '" + botJarsSeparated[i] + "'.");
            }
            System.out.println("-- Bot" + (i + 1) + " jar file found at '" + botJarFiles[i].getAbsolutePath() + "'");
            ++i;
        }
        System.out.println("-- Bot jars ok");
        i = 0;
        while (i < botNamesSeparated.length) {
            if (botNamesSeparated[i] == null || botNamesSeparated[i].isEmpty()) {
                UT2004VIPConsole.fail("Bot " + (i + 1) + " invalid name '" + botNamesSeparated[i] + "' specified.");
            }
            System.out.println("-- Bot" + (i + 1) + " name set as '" + botNamesSeparated[i] + "'");
            ++i;
        }
        System.out.println("-- Bot names ok");
        mapsDirFile = new File(ut2004HomeDirFile, "Maps");
        if (!mapsDirFile.exists() || !mapsDirFile.isDirectory()) {
            UT2004VIPConsole.fail("UT2004/Maps directory was not found at '" + mapsDirFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/Maps directory found at '" + mapsDirFile.getAbsolutePath() + "'");
        mapFile = new File(mapsDirFile, String.valueOf(map) + ".ut2");
        if (!mapFile.exists() || !mapFile.isFile()) {
            UT2004VIPConsole.fail("Specified map '" + map + "' was not found within UT2004/Maps dir at '" + mapFile.getAbsoluteFile() + "', could not execute the match.");
        }
        System.out.println("-- Map '" + map + "' found at '" + mapFile.getAbsolutePath() + "'");
        if (matchName == null || matchName.isEmpty()) {
            UT2004VIPConsole.fail("Invalid match name '" + matchName + "' specified.");
        }
        System.out.println("-- Match name set as '" + matchName + "'");
        if (serverName == null || serverName.isEmpty()) {
            UT2004VIPConsole.fail("Invalid server name '" + serverName + "' specified.");
        }
        System.out.println("-- Server name set as '" + serverName + "'");
        if (ut2004Port < 1 || ut2004Port > 32000) {
            UT2004VIPConsole.fail("Invalid UT2004 port specified '" + ut2004Port + "', must be 1 <= port <= 32000.");
        }
        System.out.println("-- UT2004 port set as '" + ut2004Port + "'");
        VIPGameConfig csConfig = gameConfig;
        if (csConfig.isFixedVIP() && (csConfig.getFixedVIPNamePrefix() == null || csConfig.getFixedVIPNamePrefix().isEmpty())) {
            UT2004VIPConsole.fail("Fixed VIP configured as TRUE, but no name specified.");
        }
        if (csConfig.getTargetMap() == null || csConfig.getTargetMap().isEmpty()) {
            UT2004VIPConsole.fail("No targetMap specified.");
        }
        if (csConfig.getRoundCount() <= 0) {
            UT2004VIPConsole.fail("RoundCount == " + csConfig.getRoundCount() + " <= 0, invalid. There must be at least 1 round to be played.");
        }
        if (csConfig.getCtsSpawnAreas() == null || csConfig.getCtsSpawnAreas().length <= 0) {
            UT2004VIPConsole.fail("Counter-terrorist (blue) team spawn area not specified correctly.");
        }
        if (csConfig.getTsSpawnAreas() == null || csConfig.getTsSpawnAreas().length <= 0) {
            UT2004VIPConsole.fail("Terrorist (red) team spawn area not specified correctly.");
        }
        if (csConfig.getVipSafeAreas() == null || csConfig.getVipSafeAreas().length <= 0) {
            UT2004VIPConsole.fail("VIP safe area not specified correctly.");
        }
        if (csConfig.getVipSafeAreaRadius() < 25) {
            UT2004VIPConsole.fail("VIP safe area radius == " + csConfig.getVipSafeAreaRadius() + " < 25, invalid, UT2004 sensor snapshots are not that precise to be able to handle small areas.");
        }
        System.out.println("Sanity checks OK!");
        System.out.println("Hide&Seek Game Configuration...");
        System.out.println("-- Map:                            " + csConfig.getTargetMap());
        System.out.println("-- Round count:                    " + csConfig.getRoundCount());
        System.out.println("-- Round time (secs):              " + csConfig.getRoundTimeUT());
        if (csConfig.isFixedVIP()) {
            System.out.println("-- Fixed VIP name prefix:          " + csConfig.getFixedVIPNamePrefix());
        } else {
            System.out.println("-- Random VIP every round");
        }
        System.out.println("-- CT (blue) team spawn areas:     " + ctSpawnAreas);
        System.out.println("-- T (red) team spawn areas:       " + tSpawnAreas);
        System.out.println("-- VIP safe areas:                 " + vipSafeAreas);
        System.out.println("-- VIP safe area radius:           " + csConfig.getVipSafeAreaRadius());
        System.out.println("VIP Scoring Configuration:");
        System.out.println("-- VIP safe => CT wins bonus:      " + csConfig.getVipSafeCTsScore());
        System.out.println("-- VIP safe => T loses penalty:    " + csConfig.getVipSafeTsScore());
        System.out.println("-- VIP killed => CT loses penalty: " + csConfig.getVipKilledCTsScore());
        System.out.println("-- VIP killed => T wins bonus:     " + csConfig.getVipKilledTsScore());
    }

    private static void setUT2004Ini() {
        List lines;
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        File ut2004IniBackup = new File(ut2004SystemDirFile, "UT2004.ini." + sdf.format(date) + ".bak");
        System.out.println("Backing up '" + ut2004IniFile.getAbsolutePath() + "' into '" + ut2004IniBackup.getAbsolutePath() + "' ...");
        try {
            FileUtils.copyFile((File)ut2004IniFile, (File)ut2004IniBackup);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to backup UT2004.ini", e);
        }
        System.out.println("Reading '" + ut2004IniFile.getAbsolutePath() + "' ...");
        try {
            lines = FileUtils.readLines((File)ut2004IniFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read UT2004.ini", e);
        }
        System.out.println("-- " + lines.size() + " lines read.");
        System.out.println("Searching for UT2004 Port and ServerName ...");
        int state = 0;
        Pattern patternSection = Pattern.compile("^\\s*\\[\\s*[^]]*\\s*\\]\\s*$");
        Pattern patternSectionURL = Pattern.compile("^\\s*\\[\\s*URL\\s*\\]\\s*$");
        Pattern patternSectionEngineGameReplicationInfo = Pattern.compile("^\\s*\\[\\s*Engine.GameReplicationInfo\\s*\\]\\s*$");
        Pattern patternPort = Pattern.compile("^\\s*Port\\s*=\\s*.*$");
        Pattern patternServerName = Pattern.compile("^\\s*ServerName\\s*=\\s*.*$");
        Pattern patternShortName = Pattern.compile("^\\s*ShortName\\s*=\\s*.*$");
        boolean portFound = false;
        boolean nameFound = false;
        boolean shortNameFound = false;
        int lineNum = 0;
        while (!(lineNum > lines.size() || portFound && nameFound && shortNameFound)) {
            String line;
            String string = line = lineNum < lines.size() ? ((String)lines.get(lineNum)).trim() : null;
            if (lineNum >= lines.size() || line != null) {
                if (lineNum == lines.size() || patternSection.matcher(line).matches()) {
                    switch (state) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (portFound) break;
                            lines.add(lineNum, "Port=" + ut2004Port);
                            portFound = true;
                            ++lineNum;
                            break;
                        }
                        case 2: {
                            if (!nameFound) {
                                lines.add(lineNum, "ServerName=" + serverName);
                                nameFound = true;
                                ++lineNum;
                            }
                            if (shortNameFound) break;
                            lines.add(lineNum, "ShortName=" + serverName);
                            shortNameFound = true;
                            ++lineNum;
                        }
                    }
                    if (lineNum == lines.size()) break;
                    if (line != null) {
                        state = patternSectionURL.matcher(line).matches() ? 1 : (patternSectionEngineGameReplicationInfo.matcher(line).matches() ? 2 : 0);
                    }
                } else {
                    switch (state) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (portFound || !patternPort.matcher(line).matches()) break;
                            lines.set(lineNum, "Port=" + ut2004Port);
                            portFound = true;
                            break;
                        }
                        case 2: {
                            if (!nameFound && patternServerName.matcher(line).matches()) {
                                lines.set(lineNum, "ServerName=" + serverName);
                                nameFound = true;
                                break;
                            }
                            if (shortNameFound || !patternShortName.matcher(line).matches()) break;
                            lines.set(lineNum, "ShortName=" + serverName);
                            shortNameFound = true;
                            break;
                        }
                    }
                }
            }
            ++lineNum;
        }
        if (!portFound) {
            throw new RuntimeException("Failed to set UT2004 port!");
        }
        if (!nameFound) {
            throw new RuntimeException("Failed to set UT2004 ServerName!");
        }
        System.out.println("UT2004 Port and ServerName set.");
        System.out.println("Rewriting '" + ut2004IniFile.getAbsolutePath() + "' ...");
        try {
            FileUtils.writeLines((File)ut2004IniFile, (Collection)lines);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write UT2004.ini", e);
        }
        System.out.println("UT2004 Port and ServerName set.");
    }

    private static void executeMatch() {
        UT2004VIPConfig config = new UT2004VIPConfig();
        UT2004BotConfig[] botConfigs = new UT2004BotConfig[botJarFiles.length];
        int i = 0;
        while (i < botJarFiles.length) {
            UT2004BotConfig botConfig = new UT2004BotConfig();
            botConfig.setBotId(botNamesSeparated[i]);
            botConfig.setPathToBotJar(botJarFiles[i].getAbsolutePath());
            botConfig.setRedirectStdErr(true);
            botConfig.setRedirectStdOut(true);
            botConfigs[i] = botConfig;
            ++i;
        }
        config.setBot(botConfigs);
        config.setHumanLikeLogEnabled(humanLikeLog);
        config.setMatchId(matchName);
        config.setOutputDirectory(new File(resultDir));
        config.setHsConfig(gameConfig);
        config.getUccConf().setGameType("BotDeathMatch");
        config.getUccConf().setMapName(map);
        config.getUccConf().setUnrealHome(ut2004HomeDir);
        LogCategory log = new LogCategory(matchName);
        UT2004VIP match = new UT2004VIP(config, log);
        match.getLog().setLevel(Level.ALL);
        match.getLog().addConsoleHandler();
        System.out.println("EXECUTING MATCH!");
        match.run();
    }

    public static void main(String[] args) throws JSAPException {
        UT2004VIPConsole.initJSAP();
        UT2004VIPConsole.header();
        UT2004VIPConsole.readConfig(args);
        UT2004VIPConsole.sanityChecks();
        UT2004VIPConsole.setUT2004Ini();
        UT2004VIPConsole.executeMatch();
    }
}

