/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.server;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.utils.UnrealUtils;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSBotRole;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSBotState;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.CSBotTeam;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameConfig;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.VIPGameResult;
import cz.cuni.amis.pogamut.ut2004.vip.protocol.messages.CSTeamScoreChanged;
import cz.cuni.amis.pogamut.ut2004.vip.server.CSTeamsRecord;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.maps.LazyMapMap;
import java.util.Map;

public class CSBotRecord<PLAYER_CONTAINER> {
    private boolean inited = false;
    private UnrealId botId;
    private long initTime;
    private long finishTime = -1L;
    private CSBotState botState = CSBotState.TERRORIST;
    private int vipCount = 0;
    private int terroristCount = 0;
    private int counterTerroristCount = 0;
    private boolean spawned = false;
    private CSTeamsRecord teamsRecord;
    private Map<UnrealId, Integer> vipSafe = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private Map<UnrealId, Integer> vipKilled = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private LazyMapMap<UnrealId, UnrealId, Integer> vipKilledBy = new LazyMapMap(){

        protected Integer create(Object key) {
            return 0;
        }
    };
    private boolean inGame = false;
    private PLAYER_CONTAINER player;

    public CSBotRecord() {
    }

    public CSBotRecord(UnrealId botId, VIPGameConfig config) {
        this.init(botId, config);
    }

    public void init(UnrealId botId, VIPGameConfig config) {
        if (this.inited) {
            throw new RuntimeException("Cannot initialize twice!");
        }
        this.inited = true;
        this.botId = botId;
        this.teamsRecord = new CSTeamsRecord(config);
    }

    public long getInitTime() {
        return this.initTime;
    }

    public void setInitTime(long initTime) {
        this.initTime = initTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public CSBotState getBotState() {
        return this.botState;
    }

    public CSBotRole getBotRole() {
        return this.botState.role;
    }

    public CSBotTeam getMyTeam() {
        return this.botState.role.team;
    }

    public CSBotTeam getEnemyTeam() {
        return this.botState.role.team.getEnemyTeam();
    }

    public void setBotState(CSBotState botState) {
        this.botState = botState;
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public UnrealId getBotId() {
        if (this.botId != null) {
            return this.botId;
        }
        if (this.player != null) {
            if (this.player instanceof PlayerMessage) {
                return ((PlayerMessage)this.player).getId();
            }
            if (this.player instanceof Player) {
                return ((Player)this.player).getId();
            }
        }
        return this.botId;
    }

    public boolean isBot() {
        return UnrealUtils.isBotId((UnrealId)this.botId);
    }

    public String getBotName() {
        if (this.player instanceof PlayerMessage) {
            return ((PlayerMessage)this.player).getName();
        }
        if (this.player instanceof Player) {
            return ((Player)this.player).getName();
        }
        return "?";
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    public void setSpawned(boolean spawned) {
        this.spawned = spawned;
    }

    public int getVIPCount() {
        return this.vipCount;
    }

    public int getTCount() {
        return this.terroristCount;
    }

    public int getCTCount() {
        return this.counterTerroristCount;
    }

    public int getMyTeamWins() {
        return this.teamsRecord.getWins(this.getMyTeam());
    }

    public int getMyEnemyWins() {
        return this.teamsRecord.getWins(this.getEnemyTeam());
    }

    public int getMyTeamScore() {
        return this.teamsRecord.getScore(this.getMyTeam());
    }

    public int getEnemyTeamScore() {
        return this.teamsRecord.getScore(this.getEnemyTeam());
    }

    public VIPGameResult getGameResult() {
        return this.teamsRecord.getResult();
    }

    public void setVIPForThisRound() {
        this.botState = CSBotState.VIP;
        ++this.vipCount;
    }

    public void setTerroristForThisRound() {
        this.botState = CSBotState.TERRORIST;
        ++this.terroristCount;
    }

    public void setCounterTerroristForThisRound() {
        this.botState = CSBotState.COUNTER_TERRORIST;
        ++this.terroristCount;
    }

    public void vipSafe(UnrealId botId) {
        this.vipSafe.put(botId, this.vipSafe.get(botId) + 1);
        if (this.getBotId() == botId) {
            switch (this.botState) {
                case VIP: {
                    this.botState = CSBotState.VIP_SAFE;
                }
            }
        }
    }

    public void botDied(UnrealId killedBy) {
        switch (this.botState) {
            case COUNTER_TERRORIST: {
                this.botState = CSBotState.COUNTER_TERRORIST_DEAD;
                break;
            }
            case TERRORIST: {
                this.botState = CSBotState.TERRORIST_DEAD;
                break;
            }
            case VIP: {
                this.botState = CSBotState.VIP_DEAD;
                this.vipKilled.put(this.getBotId(), this.vipKilled.get(this.getBotId()) + 1);
                if (killedBy == null) break;
                this.vipKilledBy.put((Object)killedBy, (Object)this.getBotId(), (Object)((Integer)this.vipKilledBy.get((Object)killedBy, (Object)this.getBotId()) + 1));
            }
        }
        this.setSpawned(false);
    }

    public void terroristsWin() {
        this.teamsRecord.terroristsWin();
    }

    public void counterTerroristsWin() {
        this.teamsRecord.counterTerroristsWin();
    }

    public void reset() {
        this.initTime = System.currentTimeMillis();
        this.finishTime = -1L;
        this.botState = CSBotState.TERRORIST;
        this.counterTerroristCount = 0;
        this.vipCount = 0;
        this.teamsRecord.clear();
        this.vipSafe.clear();
        this.vipKilled.clear();
        this.vipKilledBy.clear();
    }

    public PLAYER_CONTAINER getPlayer() {
        return this.player;
    }

    public void setPlayer(PLAYER_CONTAINER player) {
        this.player = player;
    }

    public void teamScoreChanged(CSTeamScoreChanged event) {
        this.teamsRecord.teamScoreChanged(event);
    }

    protected void setConfig(VIPGameConfig config) {
        this.teamsRecord.setConfig(config);
    }
}

