/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.playground;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004HumanConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.teamdeathmatch.UT2004TeamDeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.teamdeathmatch.UT2004TeamDeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.UT2004TournamentProperty;
import java.io.File;
import java.util.logging.Level;

public class Main {
    public static UT2004BotConfig holBot(int number, int skillLevel) {
        return Main.holBot(number, skillLevel, 255);
    }

    public static UT2004BotConfig holBot(int number, int skillLevel, int team) {
        UT2004BotConfig config = new UT2004BotConfig();
        config.setBotId("HolBot" + number);
        config.setPathToBotJar("d:/Workspaces/Pogamut-Competitions/2015/Matches/Bots-2015-Compiled/HolBot/pogamut-cup-2015-hol-bot-1.2-SNAPSHOT.one-jar.jar");
        config.setRedirectStdErr(true);
        config.setRedirectStdOut(true);
        config.setBotTeam(team);
        return config;
    }

    public static UT2004BotConfig gladiatorBot(int number, int skillLevel) {
        return Main.gladiatorBot(number, skillLevel, 255);
    }

    public static UT2004BotConfig gladiatorBot(int number, int skillLevel, int team) {
        UT2004BotConfig config = new UT2004BotConfig();
        config.setBotId("GladiatorBot" + number);
        config.setPathToBotJar("d:/Workspaces/Pogamut-Competitions/2015/Matches/Bots-2015-Compiled/GladiatorBot/pogamut-cup-2015-gladiator-bot-2-pri-3.7.1-SNAPSHOT.one-jar.jar");
        config.setRedirectStdErr(true);
        config.setRedirectStdOut(true);
        config.setBotTeam(team);
        return config;
    }

    public static UT2004HumanConfig human(int number, int team) {
        UT2004HumanConfig config = new UT2004HumanConfig();
        config.setHumanId("Human" + number);
        config.setTeamNumber(team);
        return config;
    }

    public static void main(String[] args) {
        UT2004TeamDeathMatchConfig config = new UT2004TeamDeathMatchConfig();
        config.getUT2004Ini().setServerName("TDM", "TDM");
        config.getUT2004Ini().setDemoSpectatorClass("GameBots2004.GBDemoRecSpectator");
        config.getUccConf().setStartOnUnusedPort(true);
        config.getUccConf().setUnrealHome(Pogamut.getPlatform().getProperty(UT2004TournamentProperty.UT2004_DIR.getKey()));
        config.getUccConf().setGameType("BotTeamGame");
        config.getUccConf().setMapName("DM-Rankin-FE");
        config.setOutputDirectory(new File("./results"));
        config.setMatchId("TDM");
        config.setHumanLikeLogEnabled(false);
        config.setStartTCServer(false);
        config.addBot(Main.holBot(1, 5, 1), Main.holBot(2, 5, 1));
        config.addHuman(Main.human(1, 0));
        config.setScoreLimit(10);
        config.setTimeLimit(10);
        System.out.println("EXECUTING TEAM DEATH MATCH!");
        LogCategory log = new LogCategory("TDM");
        UT2004TeamDeathMatch match = new UT2004TeamDeathMatch(config, log);
        match.getLog().setLevel(Level.INFO);
        match.getLog().addConsoleHandler();
        match.run();
    }
}

