/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.match;

import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.result.UT2004MatchResult;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004MatchExecutor<MATCH extends UT2004Match, RESULT extends UT2004MatchResult>
implements Callable<Map<IToken, RESULT>>,
Runnable {
    private MATCH[] matches;
    private Map<IToken, RESULT> results = new HashMap<IToken, RESULT>();
    private Map<IToken, Throwable> exceptions = new HashMap<IToken, Throwable>();
    private Logger log;

    public UT2004MatchExecutor(MATCH[] matches, Logger log) {
        this.log = log;
        this.matches = matches;
        NullCheck.check(this.matches, (String)"matches");
    }

    public Map<IToken, RESULT> getResults() {
        return Collections.unmodifiableMap(this.results);
    }

    public Map<IToken, Throwable> getExceptions() {
        return Collections.unmodifiableMap(this.exceptions);
    }

    @Override
    public Map<IToken, RESULT> call() throws Exception {
        this.run();
        return this.getResults();
    }

    @Override
    public void run() {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Executing " + this.matches.length + " matches!");
        }
        boolean exception = false;
        MATCH[] MATCHArray = this.matches;
        int n = this.matches.length;
        int n2 = 0;
        while (n2 < n) {
            MATCH match = MATCHArray[n2];
            try {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Executing match: " + ((UT2004Match)match).getMatchId().getToken());
                }
                Object result = ((UT2004Match)match).call();
                this.results.put(((UT2004Match)match).getMatchId(), result);
            }
            catch (Exception e) {
                if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                    this.log.severe(ExceptionToString.process((String)("Match[" + ((UT2004Match)match).getMatchId().getToken() + "] failed with exception."), (Throwable)e));
                }
                exception = true;
                this.exceptions.put(((UT2004Match)match).getMatchId(), e);
            }
            ++n2;
        }
        if (exception) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.warning("Execution finished... SOME MATCHES FAILED!!!");
            }
        } else if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Execution finished! ALL MATCHES FINISHED SUCCESSFULLY!");
        }
    }
}

