/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlag;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlagConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004HumanConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.teamdeathmatch.UT2004TeamDeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.teamdeathmatch.UT2004TeamDeathMatchConfig;
import java.io.File;
import java.util.logging.Level;

public class UT2004MatchConsole {
    private static final char ARG_MATCH_TYPE_SHORT = 'y';
    private static final String ARG_MATCH_TYPE_LONG = "match-type";
    private static final char ARG_UT2004_HOME_DIR_SHORT = 'u';
    private static final String ARG_UT2004_HOME_DIR_LONG = "ut2004-home-dir";
    private static final char ARG_NATIVE_COUNT_SHORT = 'c';
    private static final String ARG_NATIVE_COUNT_LONG = "native-count";
    private static final char ARG_NATIVE_NAMES_SHORT = 'd';
    private static final String ARG_NATIVE_NAMES_LONG = "native-names";
    private static final char ARG_NATIVE_SKILLS_SHORT = 'e';
    private static final String ARG_NATIVE_SKILLS_LONG = "native-skills";
    private static final char ARG_NATIVE_TEAMS_SHORT = 'g';
    private static final String ARG_NATIVE_TEAMS_LONG = "native-teams";
    private static final char ARG_HUMAN_COUNT_SHORT = 'x';
    private static final String ARG_HUMAN_COUNT_LONG = "human-count";
    private static final char ARG_HUMAN_TEAMS_SHORT = 'z';
    private static final String ARG_HUMAN_TEAMS_LONG = "human-teams";
    private static final char ARG_BOT_JARs_SHORT = 'a';
    private static final String ARG_BOT_JARs_LONG = "bot-jars";
    private static final char ARG_BOT_NAMES_SHORT = 'b';
    private static final String ARG_BOT_NAMES_LONG = "bot-names";
    private static final char ARG_BOT_SKINS_SHORT = 'k';
    private static final String ARG_BOT_SKINS_LONG = "bot-skins";
    private static final char ARG_BOT_SKILLS_SHORT = 'l';
    private static final String ARG_BOT_SKILLS_LONG = "bot-skills";
    private static final char ARG_BOT_TEAMS_SHORT = 'i';
    private static final String ARG_BOT_TEAMS_LONG = "bot-teams";
    private static final char ARG_MAP_NAME_SHORT = 'm';
    private static final String ARG_MAP_NAME_LONG = "map-name";
    private static final char ARG_MATCH_NAME_SHORT = 'n';
    private static final String ARG_MATCH_NAME_LONG = "match-name";
    private static final char ARG_RESULT_DIR_SHORT = 'r';
    private static final String ARG_RESULT_DIR_LONG = "result-directory";
    private static final char ARG_SERVER_NAME_SHORT = 's';
    private static final String ARG_SERVER_NAME_LONG = "server-name";
    private static final char ARG_SCORE_LIMIT_SHORT = 'f';
    private static final String ARG_SCORE_LIMIT_LONG = "score-limit";
    private static final char ARG_TIMEOUT_MINUTES_SHORT = 't';
    private static final String ARG_TIMEOUT_MINUTES_LONG = "timeout-minutes";
    private static final char ARG_HUMAN_LIKE_LOG_SHORT = 'h';
    private static final String ARG_HUMAN_LIKE_LOG_LONG = "human-like-log";
    private static final char ARG_UT2004_PORT_SHORT = 'p';
    private static final String ARG_UT2004_PORT_LONG = "ut2004-port";
    private static final char ARG_START_TC_SERVER_SHORT = 'q';
    private static final String ARG_START_TC_SERVER_LONG = "start-tc-server";
    private static JSAP jsap;
    private static boolean headerOutput;
    private static String ut2004HomeDir;
    private static int nativeCount;
    private static String matchTypeName;
    private static MatchType matchType;
    private static String nativeNames;
    private static String[] nativeNamesSeparated;
    private static String nativeSkills;
    private static String[] nativeSkillsSeparated;
    private static Integer[] nativeSkillsNumbers;
    private static String nativeTeams;
    private static String[] nativeTeamsSeparated;
    private static Integer[] nativeTeamsNumbers;
    public static int humanCount;
    private static String humanTeams;
    private static String[] humanTeamsSeparated;
    private static Integer[] humanTeamsNumbers;
    private static int botCount;
    private static String botJars;
    private static String[] botJarsSeparated;
    private static String botNames;
    private static String[] botNamesSeparated;
    private static String botSkills;
    private static String[] botSkillsSeparated;
    private static Integer[] botSkillsNumbers;
    private static String botTeams;
    private static String[] botTeamsSeparated;
    private static Integer[] botTeamsNumbers;
    private static String botSkins;
    private static String[] botSkinsSeparated;
    private static File[] botJarFiles;
    private static String map;
    private static String serverName;
    private static String resultDir;
    private static String matchName;
    private static int scoreLimit;
    private static int timeoutMinutes;
    private static JSAPResult config;
    private static File ut2004HomeDirFile;
    private static File bot1JarFile;
    private static File bot2JarFile;
    private static File mapsDirFile;
    private static File mapFile;
    private static File ut2004SystemDirFile;
    private static File ut2004IniFile;
    private static boolean humanLikeLog;
    private static boolean startTCServer;
    private static int ut2004Port;

    static {
        headerOutput = false;
    }

    private static void fail(String errorMessage) {
        UT2004MatchConsole.fail(errorMessage, null);
    }

    private static void fail(String errorMessage, Throwable e) {
        UT2004MatchConsole.header();
        System.out.println("ERROR: " + errorMessage);
        System.out.println();
        if (e != null) {
            e.printStackTrace();
            System.out.println("");
        }
        System.out.println("Usage: java -jar ut2004-tournament-1v1....jar ");
        System.out.println("                " + jsap.getUsage());
        System.out.println();
        System.out.println(jsap.getHelp());
        System.out.println();
        throw new RuntimeException("FAILURE: " + errorMessage);
    }

    private static void header() {
        if (headerOutput) {
            return;
        }
        System.out.println();
        System.out.println("=============================");
        System.out.println("Pogamut UT2004 Match Executor");
        System.out.println("=============================");
        System.out.println();
        headerOutput = true;
    }

    private static String getMatchTypes() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        MatchType[] matchTypeArray = MatchType.values();
        int n = matchTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchType matchType = matchTypeArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(String.valueOf(matchType.shortName) + " (" + matchType.name + ")");
            ++n2;
        }
        return sb.toString();
    }

    private static void initJSAP() throws JSAPException {
        jsap = new JSAP();
        FlaggedOption opt1 = new FlaggedOption(ARG_UT2004_HOME_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('u').setLongFlag(ARG_UT2004_HOME_DIR_LONG);
        opt1.setHelp("UT2004 home directory containing GameBots2004 (System/GameBots2004.u) present.");
        jsap.registerParameter((Parameter)opt1);
        FlaggedOption opt111 = new FlaggedOption(ARG_MATCH_TYPE_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('y').setLongFlag(ARG_MATCH_TYPE_LONG);
        opt111.setHelp("Type of the match to execute. Valid values: " + UT2004MatchConsole.getMatchTypes());
        jsap.registerParameter((Parameter)opt111);
        FlaggedOption opt2 = new FlaggedOption(ARG_BOT_JARs_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('a').setLongFlag(ARG_BOT_JARs_LONG);
        opt2.setHelp("Semicolon separated PATH/TO/JAR/file1;PATH/TO/JAR/file2 containing executable jars of bots.");
        jsap.registerParameter((Parameter)opt2);
        FlaggedOption opt3 = new FlaggedOption(ARG_BOT_NAMES_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('b').setLongFlag(ARG_BOT_NAMES_LONG);
        opt3.setHelp("Semicolon separated name1;name2;name3 (ids) that should be given to bots.");
        jsap.registerParameter((Parameter)opt3);
        FlaggedOption opt31 = new FlaggedOption(ARG_BOT_SKILLS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('l').setLongFlag(ARG_BOT_SKILLS_LONG);
        opt31.setHelp("Semicolon separated skill1;skill2;skill3 (desired skill levels) that should be given to bots. Can have 'empty space', e.g 1;;2, within to mark 'use bot supplied default value'.");
        jsap.registerParameter((Parameter)opt31);
        FlaggedOption opt32 = new FlaggedOption(ARG_BOT_SKINS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('k').setLongFlag(ARG_BOT_SKINS_LONG);
        opt32.setHelp("Semicolon separated skin1;skin2;skin3 (skins) that should be given to bots. Can have 'empty space', e.g skin1;;skin3, within to mark 'use bot supplied default value'.");
        jsap.registerParameter((Parameter)opt32);
        FlaggedOption opt33 = new FlaggedOption(ARG_BOT_TEAMS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('i').setLongFlag(ARG_BOT_TEAMS_LONG);
        opt33.setHelp("Semicolon separated team1;team2;team3 (desired teams) that should bots be in.");
        jsap.registerParameter((Parameter)opt33);
        FlaggedOption opt6 = new FlaggedOption(ARG_MAP_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('m').setLongFlag(ARG_MAP_NAME_LONG);
        opt6.setHelp("Map where the game should be played (e.g. DM-1on1-Albatross).");
        jsap.registerParameter((Parameter)opt6);
        FlaggedOption opt7 = new FlaggedOption(ARG_MATCH_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('n').setLongFlag(ARG_MATCH_NAME_LONG).setDefault("DMMatch1v1");
        opt7.setHelp("Name of the match == output folder for the results.");
        jsap.registerParameter((Parameter)opt7);
        FlaggedOption opt8 = new FlaggedOption(ARG_RESULT_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('r').setLongFlag(ARG_RESULT_DIR_LONG).setDefault(".");
        opt8.setHelp("PATH/TO/directory where to output results (does not need to exist).");
        jsap.registerParameter((Parameter)opt8);
        FlaggedOption opt9 = new FlaggedOption(ARG_SERVER_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('s').setLongFlag(ARG_SERVER_NAME_LONG).setDefault("DMMatch1v1");
        opt9.setHelp("Server name that should be advertised via LAN.");
        jsap.registerParameter((Parameter)opt9);
        FlaggedOption opt10 = new FlaggedOption(ARG_SCORE_LIMIT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('f').setLongFlag(ARG_SCORE_LIMIT_LONG).setDefault("20");
        opt10.setHelp("DeathMatch - frag limit, Capture The Flag - team score limit");
        jsap.registerParameter((Parameter)opt10);
        FlaggedOption opt11 = new FlaggedOption(ARG_TIMEOUT_MINUTES_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('t').setLongFlag(ARG_TIMEOUT_MINUTES_LONG).setDefault("20");
        opt11.setHelp("Match timeout in minutes.");
        jsap.registerParameter((Parameter)opt11);
        Switch opt12 = new Switch(ARG_HUMAN_LIKE_LOG_LONG).setShortFlag('h').setLongFlag(ARG_HUMAN_LIKE_LOG_LONG).setDefault("false");
        opt12.setHelp("Whether to produce log for 'HumanLike Project' analysis.");
        jsap.registerParameter((Parameter)opt12);
        FlaggedOption opt13 = new FlaggedOption(ARG_UT2004_PORT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('p').setLongFlag(ARG_UT2004_PORT_LONG).setDefault("7777");
        opt13.setHelp("UT2004 port for the dedicated server (1-32000).");
        jsap.registerParameter((Parameter)opt13);
        FlaggedOption opt14 = new FlaggedOption(ARG_NATIVE_COUNT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('c').setLongFlag(ARG_NATIVE_COUNT_LONG).setDefault("0");
        opt14.setHelp("Number of native bots to participate within the match.");
        jsap.registerParameter((Parameter)opt14);
        FlaggedOption opt15 = new FlaggedOption(ARG_NATIVE_NAMES_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('d').setLongFlag(ARG_NATIVE_NAMES_LONG);
        opt15.setHelp("Semicolon separated name1;name2;... of names to be given to native bots.");
        jsap.registerParameter((Parameter)opt15);
        FlaggedOption opt16 = new FlaggedOption(ARG_NATIVE_SKILLS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('e').setLongFlag(ARG_NATIVE_SKILLS_LONG);
        opt16.setHelp("Semicolon separated skill1;skill2;... of skill levels of native bots.");
        jsap.registerParameter((Parameter)opt16);
        FlaggedOption opt17 = new FlaggedOption(ARG_NATIVE_TEAMS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('g').setLongFlag(ARG_NATIVE_TEAMS_LONG);
        opt17.setHelp("Semicolon separated team1;team2;... of teams the native bots should be in.");
        jsap.registerParameter((Parameter)opt17);
        FlaggedOption opt20 = new FlaggedOption(ARG_HUMAN_COUNT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('x').setLongFlag(ARG_HUMAN_COUNT_LONG).setDefault("0");
        opt20.setHelp("Number of humans that should participate in the match.");
        jsap.registerParameter((Parameter)opt20);
        FlaggedOption opt21 = new FlaggedOption(ARG_HUMAN_TEAMS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('z').setLongFlag(ARG_HUMAN_TEAMS_LONG);
        opt21.setHelp("Semicolon separated team1;team2;... of teams humans should be in.");
        jsap.registerParameter((Parameter)opt21);
        Switch opt22 = new Switch(ARG_START_TC_SERVER_LONG).setShortFlag('q').setLongFlag(ARG_START_TC_SERVER_LONG);
        opt22.setHelp("Whether to start instance of UT2004TCServer to allow Java chat between bots.");
        jsap.registerParameter((Parameter)opt22);
    }

    /*
     * Unable to fully structure code
     */
    private static void readConfig(String[] args) {
        block3: {
            block4: {
                System.out.println("Parsing command arguments.");
                try {
                    UT2004MatchConsole.config = UT2004MatchConsole.jsap.parse(args);
                }
                catch (Exception e) {
                    UT2004MatchConsole.fail(e.getMessage());
                    System.out.println("");
                    e.printStackTrace();
                    throw new RuntimeException("FAILURE!");
                }
                if (UT2004MatchConsole.config.success()) break block3;
                error = "Invalid arguments specified.";
                errorIter = UT2004MatchConsole.config.getErrorMessageIterator();
                if (errorIter.hasNext()) ** GOTO lbl17
                error = String.valueOf(error) + "\n-- No details given.";
                break block4;
lbl-1000:
                // 1 sources

                {
                    error = String.valueOf(error) + "\n-- " + errorIter.next();
lbl17:
                    // 2 sources

                    ** while (errorIter.hasNext())
                }
            }
            UT2004MatchConsole.fail(error);
        }
        UT2004MatchConsole.ut2004HomeDir = UT2004MatchConsole.config.getString("ut2004-home-dir");
        UT2004MatchConsole.matchTypeName = UT2004MatchConsole.config.getString("match-type");
        UT2004MatchConsole.botJars = UT2004MatchConsole.config.getString("bot-jars");
        UT2004MatchConsole.botJarsSeparated = UT2004MatchConsole.botJars == null ? null : UT2004MatchConsole.botJars.split(";");
        UT2004MatchConsole.botCount = UT2004MatchConsole.botJarsSeparated == null ? 0 : UT2004MatchConsole.botJarsSeparated.length;
        UT2004MatchConsole.botNames = UT2004MatchConsole.config.getString("bot-names");
        UT2004MatchConsole.botNamesSeparated = UT2004MatchConsole.botNames == null ? null : UT2004MatchConsole.botNames.split(";");
        UT2004MatchConsole.botSkills = UT2004MatchConsole.config.getString("bot-skills");
        UT2004MatchConsole.botSkillsSeparated = UT2004MatchConsole.botSkills == null || UT2004MatchConsole.botSkills.length() == 0 ? null : UT2004MatchConsole.botSkills.split(";");
        UT2004MatchConsole.botSkins = UT2004MatchConsole.config.getString("bot-skins");
        UT2004MatchConsole.botSkinsSeparated = UT2004MatchConsole.botSkins == null || UT2004MatchConsole.botSkins.length() == 0 ? null : UT2004MatchConsole.botSkins.split(";");
        UT2004MatchConsole.botTeams = UT2004MatchConsole.config.getString("bot-teams");
        UT2004MatchConsole.botTeamsSeparated = UT2004MatchConsole.botTeams == null || UT2004MatchConsole.botTeams.length() == 0 ? null : UT2004MatchConsole.botTeams.split(";");
        UT2004MatchConsole.nativeCount = UT2004MatchConsole.config.getInt("native-count");
        UT2004MatchConsole.nativeNames = UT2004MatchConsole.config.getString("native-names");
        UT2004MatchConsole.nativeNamesSeparated = UT2004MatchConsole.nativeNames == null ? null : UT2004MatchConsole.nativeNames.split(";");
        UT2004MatchConsole.nativeSkills = UT2004MatchConsole.config.getString("native-skills");
        UT2004MatchConsole.nativeSkillsSeparated = UT2004MatchConsole.nativeSkills == null ? null : UT2004MatchConsole.nativeSkills.split(";");
        UT2004MatchConsole.nativeTeams = UT2004MatchConsole.config.getString("native-teams");
        UT2004MatchConsole.nativeTeamsSeparated = UT2004MatchConsole.nativeTeams == null ? null : UT2004MatchConsole.nativeTeams.split(";");
        UT2004MatchConsole.humanCount = UT2004MatchConsole.config.getInt("human-count");
        UT2004MatchConsole.humanTeams = UT2004MatchConsole.config.getString("human-teams");
        UT2004MatchConsole.humanTeamsSeparated = UT2004MatchConsole.humanTeams == null ? null : UT2004MatchConsole.humanTeams.split(";");
        UT2004MatchConsole.map = UT2004MatchConsole.config.getString("map-name");
        UT2004MatchConsole.serverName = UT2004MatchConsole.config.getString("server-name");
        UT2004MatchConsole.resultDir = UT2004MatchConsole.config.getString("result-directory");
        UT2004MatchConsole.matchName = UT2004MatchConsole.config.getString("match-name");
        UT2004MatchConsole.scoreLimit = UT2004MatchConsole.config.getInt("score-limit");
        UT2004MatchConsole.timeoutMinutes = UT2004MatchConsole.config.getInt("timeout-minutes");
        UT2004MatchConsole.humanLikeLog = UT2004MatchConsole.config.getBoolean("human-like-log");
        UT2004MatchConsole.startTCServer = UT2004MatchConsole.config.getBoolean("start-tc-server");
        UT2004MatchConsole.ut2004Port = UT2004MatchConsole.config.getInt("ut2004-port");
    }

    private static void sanityChecks() {
        System.out.println("Sanity checks...");
        ut2004HomeDirFile = new File(ut2004HomeDir);
        if (!ut2004HomeDirFile.exists() || !ut2004HomeDirFile.isDirectory()) {
            UT2004MatchConsole.fail("UT2004 directory was not found at '" + ut2004HomeDirFile.getAbsolutePath() + "', path resolved from configuration read as '" + ut2004HomeDir + "'.");
        }
        System.out.println("-- UT2004 directory found at '" + ut2004HomeDirFile.getAbsolutePath() + "'");
        ut2004SystemDirFile = new File(ut2004HomeDirFile, "System");
        if (!ut2004SystemDirFile.exists() || !ut2004SystemDirFile.isDirectory()) {
            UT2004MatchConsole.fail("UT2004/System directory was not found at '" + ut2004SystemDirFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/System directory found at '" + ut2004SystemDirFile.getAbsolutePath() + "'");
        ut2004IniFile = new File(ut2004SystemDirFile, "UT2004.ini");
        if (!ut2004IniFile.exists() || !ut2004IniFile.isFile()) {
            UT2004MatchConsole.fail("UT2004/System/UT2004.ini file was not found at '" + ut2004IniFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/System/UT2004.ini file found at '" + ut2004IniFile.getAbsolutePath() + "'");
        MatchType[] matchTypeArray = MatchType.values();
        int n = matchTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchType validMatchType = matchTypeArray[n2];
            if (validMatchType.shortName.equalsIgnoreCase(matchTypeName)) {
                matchType = validMatchType;
                break;
            }
            ++n2;
        }
        if (matchType == null) {
            UT2004MatchConsole.fail("Invalid match type specified '" + matchTypeName + "', valid values: " + UT2004MatchConsole.getMatchTypes());
        }
        System.out.println("-- Match type set as " + UT2004MatchConsole.matchType.name + " (" + UT2004MatchConsole.matchType.shortName + ")");
        if (botCount > 0) {
            System.out.println("-- Adding " + botCount + " custom bots into the match");
            if (botNamesSeparated == null) {
                UT2004MatchConsole.fail("Bot name(s) was/were not specified correctly.");
            }
            if (botJarsSeparated.length != botNamesSeparated.length) {
                UT2004MatchConsole.fail("Bot jar(s) and name(s) numbers mismatch. I've parsed " + botJarsSeparated.length + " bot jar files != " + botNamesSeparated.length + " of bot names.");
            }
            if (botSkillsSeparated != null && botSkillsSeparated.length != botJarsSeparated.length) {
                UT2004MatchConsole.fail("Bot jar(s) and skills(s) numbers mismatch. I've parsed " + botJarsSeparated.length + " bot jar files != " + botSkillsSeparated.length + " of bot skill levels.");
            }
            if (botSkinsSeparated != null && botSkinsSeparated.length != botJarsSeparated.length) {
                UT2004MatchConsole.fail("Bot jar(s) and skins(s) numbers mismatch. I've parsed " + botJarsSeparated.length + " bot jar files != " + botSkinsSeparated.length + " of bot skins.");
            }
            botJarFiles = new File[botJarsSeparated.length];
            int i = 0;
            while (i < botJarsSeparated.length) {
                UT2004MatchConsole.botJarFiles[i] = new File(botJarsSeparated[i]);
                if (!botJarFiles[i].exists() || !botJarFiles[i].isFile()) {
                    UT2004MatchConsole.fail("Bot" + (i + 1) + " jar file was not found at '" + botJarFiles[i].getAbsolutePath() + "', path resolved from configuration read as '" + botJarsSeparated[i] + "'.");
                }
                System.out.println("-- Bot" + (i + 1) + " jar file found at '" + botJarFiles[i].getAbsolutePath() + "'");
                ++i;
            }
            System.out.println("-- Bot jars ok");
            i = 0;
            while (i < botNamesSeparated.length) {
                if (botNamesSeparated[i] == null || botNamesSeparated[i].isEmpty()) {
                    UT2004MatchConsole.fail("Bot " + (i + 1) + " invalid name '" + botNamesSeparated[i] + "' specified.");
                }
                System.out.println("-- Bot" + (i + 1) + " name set as '" + botNamesSeparated[i] + "'");
                ++i;
            }
            System.out.println("-- Bot names ok");
            if (botSkillsSeparated != null) {
                botSkillsNumbers = new Integer[botSkillsSeparated.length];
                i = 0;
                while (i < botSkillsSeparated.length) {
                    if (botSkillsSeparated[i] == null || botSkillsSeparated[i].length() == 0) {
                        UT2004MatchConsole.botSkillsNumbers[i] = null;
                        System.out.println("-- Bot" + (i + 1) + " skill level will be set to default");
                    } else {
                        Integer number = null;
                        try {
                            number = Integer.parseInt(botSkillsSeparated[i]);
                        }
                        catch (Exception e) {
                            UT2004MatchConsole.fail("Bot " + (i + 1) + " skill level specified as '" + botSkillsSeparated[i] + "', which is not a number!");
                        }
                        if (number < 0 || number > 7) {
                            UT2004MatchConsole.fail("Bot " + (i + 1) + " skill level specified as '" + botSkillsSeparated[i] + "' and parsed as '" + number + "', which is of unsupported value, not from the range 0-7!");
                        }
                        UT2004MatchConsole.botSkillsNumbers[i] = number;
                        System.out.println("-- Bot" + (i + 1) + " skill level set to " + number);
                    }
                    ++i;
                }
                System.out.println("-- Bot skills ok");
            }
            if (botSkinsSeparated != null) {
                i = 0;
                while (i < botSkinsSeparated.length) {
                    if (botSkinsSeparated[i] == null || botSkinsSeparated[i].length() == 0) {
                        UT2004MatchConsole.botSkinsSeparated[i] = null;
                        System.out.println("-- Bot" + (i + 1) + " skin will be supplied by the bot itself");
                    } else {
                        System.out.println("-- Bot" + (i + 1) + " skin set to '" + botSkinsSeparated[i] + "'");
                    }
                    ++i;
                }
                System.out.println("-- Bot skins ok");
            }
            if (UT2004MatchConsole.matchType.teamGame) {
                if (botTeamsSeparated == null) {
                    UT2004MatchConsole.fail("Bot teams not specified, but a team game specified (" + UT2004MatchConsole.matchType.name + ").");
                }
                if (botTeamsSeparated.length != botJarsSeparated.length) {
                    UT2004MatchConsole.fail("Bot jar(s) and team(s) numbers mismatch. I've parsed " + botJarsSeparated.length + " bot jar files != " + botTeamsSeparated.length + " of bot teams.");
                }
                botTeamsNumbers = new Integer[botTeamsSeparated.length];
                i = 0;
                while (i < botTeamsSeparated.length) {
                    if (botTeamsSeparated[i] == null || botTeamsSeparated[i].length() == 0) {
                        UT2004MatchConsole.fail("Bot" + (i + 1) + " does not have a team number specified.");
                    } else {
                        Integer number = null;
                        try {
                            number = Integer.parseInt(botTeamsSeparated[i]);
                        }
                        catch (Exception e) {
                            UT2004MatchConsole.fail("Bot " + (i + 1) + " team number specified as '" + botTeamsSeparated[i] + "', which is not a number!");
                        }
                        if (number < 0 || number > 3) {
                            UT2004MatchConsole.fail("Bot " + (i + 1) + " team number specified as '" + botTeamsSeparated[i] + "' and parsed as '" + number + "', which is of unsupported value, not from the range 0-3!");
                        }
                        UT2004MatchConsole.botTeamsNumbers[i] = number;
                        System.out.println("-- Bot" + (i + 1) + " team number set to " + number);
                    }
                    ++i;
                }
                System.out.println("-- Bot teams ok");
            }
        }
        if (nativeCount > 0) {
            if (nativeCount < 1 || nativeCount > 16) {
                UT2004MatchConsole.fail("Could start match with 1-16 native bots at max!");
            }
            System.out.println("-- Adding " + nativeCount + " native bots into the match");
            if (nativeNamesSeparated == null) {
                UT2004MatchConsole.fail("Native bot name(s) was/were not specified correctly.");
            }
            if (nativeCount != nativeNamesSeparated.length) {
                UT2004MatchConsole.fail("Native bot name(s) numbers invalid. I've parsed " + nativeNamesSeparated.length + " native bot name != " + nativeCount + " of native bot count.");
            }
            if (nativeSkillsSeparated == null) {
                UT2004MatchConsole.fail("Native bot skill(s) not specified correctly.");
            }
            if (nativeSkillsSeparated.length != nativeCount) {
                UT2004MatchConsole.fail("Native bot skills(s) numbers mismatch. I've parsed " + nativeSkillsSeparated.length + " native bot skills != " + nativeCount + " of native bot count.");
            }
            int i = 0;
            while (i < nativeNamesSeparated.length) {
                if (nativeNamesSeparated[i] == null || nativeNamesSeparated[i].isEmpty()) {
                    UT2004MatchConsole.fail("Native bot " + (i + 1) + " invalid name '" + nativeNamesSeparated[i] + "' specified.");
                }
                System.out.println("-- Native bot " + (i + 1) + " name set as '" + nativeNamesSeparated[i] + "'");
                ++i;
            }
            System.out.println("-- Native names ok");
            nativeSkillsNumbers = new Integer[nativeSkillsSeparated.length];
            i = 0;
            while (i < nativeSkillsSeparated.length) {
                if (nativeSkillsSeparated[i] == null || nativeSkillsSeparated[i].length() == 0) {
                    UT2004MatchConsole.fail("Native bot " + (i + 1) + " invalid skill level '" + nativeNamesSeparated[i] + "' specified.");
                }
                Integer number = null;
                try {
                    number = Integer.parseInt(nativeSkillsSeparated[i]);
                }
                catch (Exception e) {
                    UT2004MatchConsole.fail("Native bot " + i + " skill level specified as '" + nativeSkillsSeparated[i] + "', which is not a number!");
                }
                if (number < 0 || number > 7) {
                    UT2004MatchConsole.fail("Native bot " + i + " skill level specified as '" + nativeSkillsSeparated[i] + "' and parsed as '" + number + "', which is of unsupported value, not from the range 0-7!");
                }
                UT2004MatchConsole.nativeSkillsNumbers[i] = number;
                System.out.println("-- Native bot " + (i + 1) + " skill level set to " + number);
                ++i;
            }
            System.out.println("-- Native bot skills OK");
            if (UT2004MatchConsole.matchType.teamGame) {
                if (nativeTeamsSeparated == null) {
                    UT2004MatchConsole.fail("Native bot teams not specified, but a team game specified (" + UT2004MatchConsole.matchType.name + ").");
                }
                if (nativeTeamsSeparated.length != nativeCount) {
                    UT2004MatchConsole.fail("Native bot team(s) and native count numbers mismatch. I've parsed " + nativeCount + " native count != " + nativeTeamsSeparated.length + " of native bot teams.");
                }
                nativeTeamsNumbers = new Integer[nativeTeamsSeparated.length];
                i = 0;
                while (i < nativeTeamsSeparated.length) {
                    if (nativeTeamsSeparated[i] == null || nativeTeamsSeparated[i].length() == 0) {
                        UT2004MatchConsole.fail("Native bot " + (i + 1) + " does not have team number specified.");
                    } else {
                        Integer number = null;
                        try {
                            number = Integer.parseInt(nativeTeamsSeparated[i]);
                        }
                        catch (Exception e) {
                            UT2004MatchConsole.fail("Native bot " + (i + 1) + " team number specified as '" + nativeTeamsSeparated[i] + "', which is not a number!");
                        }
                        if (number < 0 || number > 3) {
                            UT2004MatchConsole.fail("Native bot " + (i + 1) + " team number specified as '" + nativeTeamsSeparated[i] + "' and parsed as '" + number + "', which is of unsupported value, not from the range 0-3!");
                        }
                        UT2004MatchConsole.nativeTeamsNumbers[i] = number;
                        System.out.println("-- Native bot " + (i + 1) + " team number set to " + number);
                    }
                    ++i;
                }
                System.out.println("-- Native bot teams ok");
            }
        }
        if (humanCount > 0) {
            if (humanCount < 1 || humanCount > 16) {
                UT2004MatchConsole.fail("Could start match with 1-16 humans at max!");
            }
            System.out.println("-- Expect " + humanCount + " humans to participate in the match");
            if (UT2004MatchConsole.matchType.teamGame) {
                if (humanTeamsSeparated == null) {
                    UT2004MatchConsole.fail("Teams for humans not specified, but a team game specified (" + UT2004MatchConsole.matchType.name + ").");
                }
                if (humanTeamsSeparated.length != humanCount) {
                    UT2004MatchConsole.fail("Human team(s) and human count numbers mismatch. I've parsed " + humanCount + " human count != " + humanTeamsSeparated.length + " of human bot teams.");
                }
                humanTeamsNumbers = new Integer[humanTeamsSeparated.length];
                int i = 0;
                while (i < humanTeamsSeparated.length) {
                    if (humanTeamsSeparated[i] == null || humanTeamsSeparated[i].length() == 0) {
                        UT2004MatchConsole.fail("Human " + (i + 1) + " does not have a team number specified.");
                    } else {
                        Integer number = null;
                        try {
                            number = Integer.parseInt(humanTeamsSeparated[i]);
                        }
                        catch (Exception e) {
                            UT2004MatchConsole.fail("Human " + (i + 1) + " team number specified as '" + humanTeamsSeparated[i] + "', which is not a number!");
                        }
                        if (number < 0 || number > 3) {
                            UT2004MatchConsole.fail("Human " + (i + 1) + " team number specified as '" + humanTeamsSeparated[i] + "' and parsed as '" + number + "', which is of unsupported value, not from the range 0-3!");
                        }
                        UT2004MatchConsole.humanTeamsNumbers[i] = number;
                        System.out.println("-- Human " + (i + 1) + " is expected to belong to the team number" + number);
                    }
                    ++i;
                }
                System.out.println("-- Human teams ok");
            }
        }
        if (botCount + nativeCount + humanCount < 2) {
            UT2004MatchConsole.fail("There must be at least 2 participants specified, custom + natives + humans = " + botCount + " + " + nativeCount + " + " + humanCount + " = " + (botCount + nativeCount + humanCount) + " < 2.");
        }
        if (!(mapsDirFile = new File(ut2004HomeDirFile, "Maps")).exists() || !mapsDirFile.isDirectory()) {
            UT2004MatchConsole.fail("UT2004/Maps directory was not found at '" + mapsDirFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/Maps directory found at '" + mapsDirFile.getAbsolutePath() + "'");
        mapFile = new File(mapsDirFile, String.valueOf(map) + ".ut2");
        if (!mapFile.exists() || !mapFile.isFile()) {
            UT2004MatchConsole.fail("Specified map '" + map + "' was not found within UT2004/Maps dir at '" + mapFile.getAbsoluteFile() + "', could not execute the match.");
        }
        System.out.println("-- Map '" + map + "' found at '" + mapFile.getAbsolutePath() + "'");
        if (matchName == null || matchName.isEmpty()) {
            UT2004MatchConsole.fail("Invalid match name '" + matchName + "' specified.");
        }
        System.out.println("-- Match name set as '" + matchName + "'");
        if (serverName == null || serverName.isEmpty()) {
            UT2004MatchConsole.fail("Invalid server name '" + serverName + "' specified.");
        }
        System.out.println("-- Server name set as '" + serverName + "'");
        if (scoreLimit < 1) {
            UT2004MatchConsole.fail("Invalid frag/score limit '" + scoreLimit + "' specified, must be >= 1.");
        }
        System.out.println("-- Frag limit set as '" + scoreLimit + "'");
        if (timeoutMinutes < 1) {
            UT2004MatchConsole.fail("Invalid time limit '" + timeoutMinutes + "' specified, must be >= 1.");
        }
        System.out.println("-- Timeout set as '" + timeoutMinutes + "' minutes.");
        if (ut2004Port < 1 || ut2004Port > 32000) {
            UT2004MatchConsole.fail("Invalid UT2004 port specified '" + ut2004Port + "', must be 1 <= port <= 32000.");
        }
        System.out.println("-- UT2004 port set as '" + ut2004Port + "'");
        System.out.println("Sanity checks OK!");
    }

    private static void setGenericMatchConfigs(UT2004MatchConfig config) {
        config.getUT2004Ini().setPort(ut2004Port);
        config.getUT2004Ini().setServerName(serverName, serverName);
        config.getUT2004Ini().setDemoSpectatorClass("GameBots2004.GBDemoRecSpectator");
        config.getUccConf().setStartOnUnusedPort(true);
        config.getUccConf().setUnrealHome(ut2004HomeDir);
        config.getUccConf().setGameType(UT2004MatchConsole.matchType.uccGameType);
        config.getUccConf().setMapName(map);
        config.setOutputDirectory(new File(resultDir));
        config.setMatchId(matchName);
        config.setHumanLikeLogEnabled(humanLikeLog);
        config.setStartTCServer(startTCServer);
    }

    private static UT2004BotConfig[] createBotConfigs() {
        if (botCount <= 0) {
            return null;
        }
        UT2004BotConfig[] botConfigs = new UT2004BotConfig[botJarFiles.length];
        int i = 0;
        while (i < botJarFiles.length) {
            UT2004BotConfig botConfig = new UT2004BotConfig();
            botConfig.setBotId(botNamesSeparated[i]);
            botConfig.setPathToBotJar(botJarFiles[i].getAbsolutePath());
            if (botSkillsNumbers != null && botSkillsNumbers[i] != null) {
                botConfig.setBotSkill(botSkillsNumbers[i]);
            }
            if (botSkinsSeparated != null && botSkinsSeparated[i] != null) {
                botConfig.setBotSkin(botSkinsSeparated[i]);
            }
            if (UT2004MatchConsole.matchType.teamGame) {
                botConfig.setBotTeam(botTeamsNumbers[i]);
            }
            botConfig.setRedirectStdErr(true);
            botConfig.setRedirectStdOut(true);
            botConfigs[i] = botConfig;
            ++i;
        }
        return botConfigs;
    }

    private static UT2004NativeBotConfig[] createNativeBotConfig() {
        if (nativeCount <= 0) {
            return null;
        }
        UT2004NativeBotConfig[] nativeConfigs = new UT2004NativeBotConfig[nativeCount];
        int i = 0;
        while (i < nativeCount) {
            UT2004NativeBotConfig nativeConfig = new UT2004NativeBotConfig();
            nativeConfig.setBotId(nativeNamesSeparated[i]);
            nativeConfig.setDesiredSkill(nativeSkillsNumbers[i]);
            if (UT2004MatchConsole.matchType.teamGame) {
                nativeConfig.setTeamNumber(nativeTeamsNumbers[i]);
            }
            nativeConfigs[i] = nativeConfig;
            ++i;
        }
        return nativeConfigs;
    }

    private static UT2004HumanConfig[] createHumanConfig() {
        if (humanCount <= 0) {
            return null;
        }
        UT2004HumanConfig[] humanConfigs = new UT2004HumanConfig[humanCount];
        int i = 0;
        while (i < humanCount) {
            UT2004HumanConfig humanConfig = new UT2004HumanConfig();
            humanConfig.setHumanId("Human" + i);
            if (UT2004MatchConsole.matchType.teamGame) {
                humanConfig.setTeamNumber(humanTeamsNumbers[i]);
            }
            humanConfigs[i] = humanConfig;
            ++i;
        }
        return humanConfigs;
    }

    private static void executeDeathMatch() {
        UT2004DeathMatchConfig config = new UT2004DeathMatchConfig();
        UT2004MatchConsole.setGenericMatchConfigs(config);
        if (botCount > 0) {
            config.setBot(UT2004MatchConsole.createBotConfigs());
        }
        if (nativeCount > 0) {
            config.setNativeBot(UT2004MatchConsole.createNativeBotConfig());
        }
        if (humanCount > 0) {
            config.setHuman(UT2004MatchConsole.createHumanConfig());
        }
        config.setFragLimit(scoreLimit);
        config.setTimeLimit(timeoutMinutes);
        System.out.println("EXECUTING DEATH MATCH!");
        LogCategory log = new LogCategory(matchName);
        UT2004DeathMatch match = new UT2004DeathMatch(config, log);
        match.getLog().setLevel(Level.INFO);
        match.getLog().addConsoleHandler();
        match.run();
    }

    public static void executeTeamDeathMatch() {
        UT2004TeamDeathMatchConfig config = new UT2004TeamDeathMatchConfig();
        UT2004MatchConsole.setGenericMatchConfigs(config);
        if (botCount > 0) {
            config.setBot(UT2004MatchConsole.createBotConfigs());
        }
        if (nativeCount > 0) {
            config.setNativeBot(UT2004MatchConsole.createNativeBotConfig());
        }
        if (humanCount > 0) {
            config.setHuman(UT2004MatchConsole.createHumanConfig());
        }
        config.setScoreLimit(scoreLimit);
        config.setTimeLimit(timeoutMinutes);
        System.out.println("EXECUTING TEAM DEATH MATCH!");
        LogCategory log = new LogCategory(matchName);
        UT2004TeamDeathMatch match = new UT2004TeamDeathMatch(config, log);
        match.getLog().setLevel(Level.INFO);
        match.getLog().addConsoleHandler();
        match.run();
    }

    public static void executeCaptureTheFlag() {
        UT2004CaptureTheFlagConfig config = new UT2004CaptureTheFlagConfig();
        UT2004MatchConsole.setGenericMatchConfigs(config);
        if (botCount > 0) {
            config.setBot(UT2004MatchConsole.createBotConfigs());
        }
        if (nativeCount > 0) {
            config.setNativeBot(UT2004MatchConsole.createNativeBotConfig());
        }
        if (humanCount > 0) {
            config.setHuman(UT2004MatchConsole.createHumanConfig());
        }
        config.setScoreLimit(scoreLimit);
        config.setTimeLimit(timeoutMinutes);
        System.out.println("EXECUTING CAPTURE THE FLAG!");
        LogCategory log = new LogCategory(matchName);
        UT2004CaptureTheFlag match = new UT2004CaptureTheFlag(config, log);
        match.getLog().setLevel(Level.INFO);
        match.getLog().addConsoleHandler();
        match.run();
    }

    public static void executeDoubleDomination() {
        UT2004MatchConsole.fail("DOUBLE DOMINATION NOT SUPPORTED YET!");
    }

    public static String[] getArgs_DM_2v2v1() {
        return new String[]{"-y", "DM", "-u", "D:\\Games\\UT2004-Devel", "-h", "-r", "./results", "-n", "Test-DM-2v2v1", "-s", "DMServer", "-a", "D:\\Workspaces\\Pogamut-Trunk\\Main\\PogamutUT2004Examples\\04-HunterBot\\target\\ut2004-04-hunter-bot-3.6.2-SNAPSHOT.one-jar.jar;D:\\Workspaces\\Pogamut-Trunk\\Main\\PogamutUT2004Examples\\04-HunterBot\\target\\ut2004-04-hunter-bot-3.6.2-SNAPSHOT.one-jar.jar", "-b", "HunterBot1;HunterBot2", "-l", "1;5", "-k", "HumanFemaleA.NightFemaleA;Aliens.AlienMaleB", "-c", "2", "-d", "Native1;Native2", "-e", "2;3", "-x", "1", "-m", "DM-TrainingDay", "-f", "5", "-t", "5"};
    }

    public static String[] getArgs_TDM_2v2v1() {
        return new String[]{"-y", "TDM", "-u", "D:\\Games\\UT2004-Devel", "-h", "-r", "./results", "-n", "Test-CTF-2v2v1", "-s", "CTFServer", "-a", "D:\\Workspaces\\Pogamut-Trunk\\Main\\PogamutUT2004Examples\\04-HunterBot\\target\\ut2004-04-hunter-bot-3.7.1-SNAPSHOT.one-jar.jar;D:\\Workspaces\\Pogamut-Trunk\\Main\\PogamutUT2004Examples\\04-HunterBot\\target\\ut2004-04-hunter-bot-3.7.1-SNAPSHOT.one-jar.jar", "-b", "TDMBot1;TDMBot2", "-l", "3;4", "-k", "HumanFemaleA.NightFemaleA;HumanFemaleA.NightFemaleA", "-i", "0;1", "-c", "2", "-d", "Native1;Native2", "-e", "2;1", "-g", "0;1", "-x", "1", "-z", "1", "-m", "DM-Flux2", "-f", "5", "-t", "5"};
    }

    public static String[] getArgs_CTF_2v2v1() {
        return new String[]{"-y", "CTF", "-u", "D:\\Games\\UT2004-Devel", "-h", "-r", "./results", "-n", "Test-TDM-2v2v1", "-s", "TDMServer", "-a", "D:\\Workspaces\\Pogamut-Trunk\\Main\\PogamutUT2004Examples\\09-CTFBot\\target\\ut2004-09-ctf-bot-3.6.2-SNAPSHOT.one-jar.jar;D:\\Workspaces\\Pogamut-Trunk\\Main\\PogamutUT2004Examples\\09-CTFBot\\target\\ut2004-09-ctf-bot-3.6.2-SNAPSHOT.one-jar.jar", "-b", "CTFBot1;CTFBot2", "-l", "1;2", "-k", "HumanFemaleA.NightFemaleA;HumanFemaleA.NightFemaleA", "-i", "0;1", "-c", "2", "-d", "Native1;Native2", "-e", "5;6", "-g", "0;1", "-x", "1", "-z", "1", "-m", "CTF-LostFaith", "-f", "1", "-t", "5"};
    }

    public static void main(String[] args) throws JSAPException {
        UT2004MatchConsole.initJSAP();
        UT2004MatchConsole.header();
        UT2004MatchConsole.readConfig(args);
        UT2004MatchConsole.sanityChecks();
        switch (matchType) {
            case DM: {
                UT2004MatchConsole.executeDeathMatch();
                break;
            }
            case TDM: {
                UT2004MatchConsole.executeTeamDeathMatch();
                break;
            }
            case CTF: {
                UT2004MatchConsole.executeCaptureTheFlag();
                break;
            }
            case DD: {
                UT2004MatchConsole.executeDoubleDomination();
                break;
            }
            default: {
                UT2004MatchConsole.fail("Unsupported match type specified " + matchTypeName + " recognized as " + UT2004MatchConsole.matchType.shortName + "[" + UT2004MatchConsole.matchType.name + "].");
            }
        }
    }

    public static enum MatchType {
        DM("DM", "Death Match", false, "BotDeathMatch"),
        TDM("TDM", "Team Death Match", true, "BotTeamGame"),
        CTF("CTF", "Capture the flag", true, "BotCTFGame"),
        DD("DD", "Double Domination", true, "BotDoubleDomination");

        String shortName;
        String name;
        boolean teamGame;
        String uccGameType;

        private MatchType(String shortName, String name, boolean teamGame, String uccGameType) {
            this.shortName = shortName;
            this.name = name;
            this.teamGame = teamGame;
            this.uccGameType = uccGameType;
        }
    }
}

