/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UT2004DMTableGenerator {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    String map = "DM-1on1-Roughinery-FPS";
    String ut2004HomeDir = "d:\\Games\\UT2004-Devel";
    int fragLimit = 10;
    int timeLimitMins = 10;
    String resultDir = "..\\Round-01-Results";
    String executor = "../ut2004-tournament-3.5.2-SNAPSHOT.one-jar.jar";
    String sourceDir = "D:/Workspaces/Pogamut-Trunk/Competitions/PogamutCup/2013/Tournament/Bots/";
    String targetDir = "D:/Workspaces/Pogamut-Trunk/Competitions/PogamutCup/2013/Tournament/Round-01";

    private String removeImplicitDirs(String dir) {
        StringBuffer result = new StringBuffer(dir.length());
        for (int i = 0; i < dir.length(); ++i) {
            String c1 = String.valueOf(dir.charAt(i));
            if (c1.equals(FILE_SEPARATOR) && i + 2 < dir.length()) {
                String c2 = String.valueOf(dir.charAt(i + 1));
                String c3 = String.valueOf(dir.charAt(i + 2));
                if (c2.equals(".") && c3.equals(FILE_SEPARATOR)) {
                    result.append(FILE_SEPARATOR);
                    ++i;
                    ++i;
                    continue;
                }
            }
            result.append(c1);
        }
        return result.toString();
    }

    private String relativePath(File directory, File findRelative) {
        String result = null;
        if (findRelative.getAbsolutePath().contains(directory.getAbsolutePath())) {
            result = ".";
            while (!directory.getAbsolutePath().equals(findRelative.getAbsolutePath())) {
                String lastDir = findRelative.getAbsolutePath().substring(findRelative.getAbsolutePath().lastIndexOf(FILE_SEPARATOR) + 1);
                findRelative = findRelative.getParentFile();
                result = result + lastDir + FILE_SEPARATOR + result;
            }
            if ((result = result + "." + FILE_SEPARATOR + result).equals("." + FILE_SEPARATOR + ".")) {
                return ".";
            }
        } else if (directory.getAbsolutePath().contains(findRelative.getAbsolutePath())) {
            while (!findRelative.getAbsolutePath().equals(directory.getAbsolutePath())) {
                directory = findRelative.getParentFile();
                result = result + ".." + FILE_SEPARATOR + result;
            }
            result = result + "." + FILE_SEPARATOR + result;
        } else {
            File commonParent = findRelative.getParentFile();
            if (commonParent == null) {
                return null;
            }
            while (!directory.getAbsolutePath().contains(commonParent.getAbsolutePath())) {
                commonParent = findRelative.getParentFile();
                if (commonParent != null) continue;
                return null;
            }
            result = ".";
            while (!commonParent.getAbsolutePath().equals(directory.getAbsolutePath())) {
                directory = directory.getParentFile();
                result = ".." + FILE_SEPARATOR + result;
            }
            String resultRest = ".";
            while (!commonParent.getAbsolutePath().equals(findRelative.getAbsolutePath())) {
                String lastDir = findRelative.getAbsolutePath().substring(findRelative.getAbsolutePath().lastIndexOf(FILE_SEPARATOR) + 1);
                findRelative = findRelative.getParentFile();
                resultRest = lastDir + FILE_SEPARATOR + resultRest;
            }
            result = result + FILE_SEPARATOR + resultRest;
        }
        if (result.equals("." + FILE_SEPARATOR + ".")) {
            return ".";
        }
        result = this.removeImplicitDirs(result);
        return result;
    }

    public void generate() {
        String strMatchNum;
        String botId2;
        File sourceDirFile = new File(this.sourceDir);
        File targetDirFile = new File(this.targetDir);
        if (!targetDirFile.exists() && !targetDirFile.mkdirs()) {
            throw new RuntimeException("Failed to create directory chain towards: " + targetDirFile.getAbsolutePath());
        }
        String sourceDirRelative = this.relativePath(targetDirFile, sourceDirFile);
        if (sourceDirRelative == null) {
            sourceDirRelative = sourceDirFile.getAbsolutePath();
        }
        try {
            FileWriter writer = new FileWriter(new File(targetDirFile, "const.bat"));
            PrintWriter print = new PrintWriter(writer);
            print.println("REM All match-batch-files uses following constants");
            print.println("");
            print.println("REM Unreal Tournament 2004 home directory");
            print.println("SET UT2004_HOME=" + this.ut2004HomeDir);
            print.println("");
            print.println("REM UT2004DeathMatchConsole executable jar");
            print.println("SET MATCH_EXECUTOR_JAR=" + this.executor);
            print.println("");
            print.println("REM Directory where to output match results");
            print.println("SET MATCH_RESULT_DIR=" + this.resultDir);
            print.println("");
            print.println("REM Name of the UT2004 map to be played");
            print.println("SET MATCH_MAP=" + this.map);
            print.println("");
            print.println("REM Target frag limit for the match");
            print.println("SET MATCH_FRAG_LIMIT=" + this.fragLimit);
            print.println("");
            print.println("REM Time limit for the match in minutes");
            print.println("SET MATCH_TIME_LIMIT=" + this.timeLimitMins);
            print.println("");
            print.close();
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<File> jars = this.gatherJarFiles(sourceDirFile);
        Collections.sort(jars, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
            }
        });
        List<String> botIds = this.extractBotIds(jars);
        ArrayList<String> jarsRelative = new ArrayList<String>(jars.size());
        for (File jar : jars) {
            String file = jar.getAbsolutePath().substring(jar.getAbsolutePath().lastIndexOf(FILE_SEPARATOR) + 1);
            String relative = sourceDirRelative + FILE_SEPARATOR + file;
            relative = this.removeImplicitDirs(relative);
            jarsRelative.add(relative);
        }
        int maxMatchNum = botIds.size() * (botIds.size() - 1) / 2;
        int matchNum = 0;
        for (int i = 0; i < botIds.size(); ++i) {
            String jar1 = (String)jarsRelative.get(i);
            String botId1 = botIds.get(i);
            for (int j = i + 1; j < jarsRelative.size(); ++j) {
                String jar2 = (String)jarsRelative.get(j);
                botId2 = botIds.get(j);
                strMatchNum = this.prefixNum(++matchNum, maxMatchNum);
                try {
                    FileWriter writer = new FileWriter(new File(targetDirFile, "match-" + strMatchNum + "-" + botId1 + "-vs-" + botId2 + ".bat"));
                    PrintWriter print = new PrintWriter(writer);
                    print.println("call const.bat");
                    print.println("");
                    print.println("java -jar %MATCH_EXECUTOR_JAR% ^");
                    print.println("-u %UT2004_HOME% ^");
                    print.println("-a " + jar1 + ";" + jar2 + " ^");
                    print.println("-b " + botId1 + ";" + botId2 + " ^");
                    print.println("-m %MATCH_MAP% ^");
                    print.println("-r %MATCH_RESULT_DIR% ^");
                    print.println("-n Match" + strMatchNum + "-" + botId1 + "-vs-" + botId2 + " ^");
                    print.println("-s DMServer-" + strMatchNum + " ^");
                    print.println("-f %MATCH_FRAG_LIMIT% ^");
                    print.println("-t %MATCH_TIME_LIMIT%");
                    print.close();
                    writer.close();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            FileWriter writer = new FileWriter(new File(targetDirFile, "execute-all.bat"));
            PrintWriter print = new PrintWriter(writer);
            matchNum = 0;
            for (int i = 0; i < jars.size(); ++i) {
                String botId1 = botIds.get(i);
                for (int j = i + 1; j < jars.size(); ++j) {
                    botId2 = botIds.get(j);
                    strMatchNum = this.prefixNum(++matchNum, maxMatchNum);
                    print.println("call match-" + strMatchNum + "-" + botId1 + "-vs-" + botId2 + ".bat");
                }
            }
            print.close();
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("MATCH BATCH FILES GENERATED!");
    }

    private String prefixNum(int num, int maxNum) {
        String strNum = String.valueOf(num);
        String strMaxNum = String.valueOf(maxNum);
        while (strNum.length() < strMaxNum.length()) {
            strNum = "0" + strNum;
        }
        return strNum;
    }

    private List<String> extractBotIds(List<File> jars) {
        ArrayList<String> result = new ArrayList<String>(jars.size());
        for (File jar : jars) {
            String file = jar.getAbsolutePath().substring(jar.getAbsolutePath().lastIndexOf(FILE_SEPARATOR) + 1);
            String id = file.substring(0, file.lastIndexOf("."));
            result.add(id);
        }
        return result;
    }

    private List<File> gatherJarFiles(File sourceDirFile) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : sourceDirFile.listFiles()) {
            if (!file.getAbsolutePath().toLowerCase().endsWith(".jar")) continue;
            result.add(file);
        }
        return result;
    }

    public static void main(String[] args) {
        UT2004DMTableGenerator generator = new UT2004DMTableGenerator();
        generator.generate();
    }
}

