/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.botexecution;

import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class UT2004BotExecutionConfig {
    private IToken botId;
    private String pathToBotJar = null;
    private boolean redirectStdErr = true;
    private boolean redirectStdOut = true;
    private File fileToJar;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public IToken getBotId() {
        return this.botId;
    }

    public UT2004BotExecutionConfig() {
    }

    public UT2004BotExecutionConfig(UT2004BotConfig value) {
        this.botId = value.getBotId();
        this.setPathToBotJar(value.getPathToBotJar());
        this.redirectStdErr = value.isRedirectStdErr();
        this.redirectStdOut = value.isRedirectStdOut();
    }

    public UT2004BotExecutionConfig setBotId(String botId) {
        NullCheck.check((Object)botId, (String)"botId");
        this.botId = Tokens.get((String)botId);
        return this;
    }

    public UT2004BotExecutionConfig setBotId(IToken botId) {
        NullCheck.check((Object)botId, (String)"botId");
        this.botId = botId;
        return this;
    }

    public String getPathToBotJar() {
        return this.pathToBotJar;
    }

    public UT2004BotExecutionConfig setPathToBotJar(String pathToBotJar) {
        this.fileToJar = pathToBotJar != null ? new File(pathToBotJar) : null;
        this.pathToBotJar = pathToBotJar;
        return this;
    }

    public boolean isBotJarExist() {
        if (this.pathToBotJar == null) {
            return false;
        }
        File file = this.getJarFile();
        return file.exists() && file.isFile();
    }

    public File getJarFile() {
        return this.fileToJar;
    }

    public boolean isRedirectStdErr() {
        return this.redirectStdErr;
    }

    public UT2004BotExecutionConfig setRedirectStdErr(boolean redirectStdErr) {
        this.redirectStdErr = redirectStdErr;
        return this;
    }

    public boolean isRedirectStdOut() {
        return this.redirectStdOut;
    }

    public UT2004BotExecutionConfig setRedirectStdOut(boolean redirectStdOut) {
        this.redirectStdOut = redirectStdOut;
        return this;
    }

    public Object addParameter(String key, Object value) {
        return this.parameters.put(key, value);
    }

    public Object removeParameter(String key) {
        return this.parameters.remove(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, ?> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        return "UT2004BotExecutionConfig[botId=" + this.botId.getToken() + ", jar=" + this.pathToBotJar + "]";
    }
}

