/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament;

import cz.cuni.amis.utils.IniFile;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.io.InputStream;

public class UT2004Ini
extends IniFile {
    public static final String Section_URL = "URL";
    public static final String Section_Engine_GameReplicationInfo = "Engine.GameReplicationInfo";
    public static final String Key_Port = "Port";
    public static final String Key_ServerName = "ServerName";
    public static final String Key_ShortName = "ShortName";

    public UT2004Ini() {
        InputStream defaults = UT2004Ini.class.getResourceAsStream("/cz/cuni/amis/pogamut/ut2004/tournament/UT2004.ini");
        this.load(defaults);
    }

    public UT2004Ini(File source) {
        if (!source.exists()) {
            throw new PogamutException("File with defaults for UT2004.ini does not exist at: " + source.getAbsolutePath() + ".", (Object)this);
        }
        this.load(source);
    }

    public UT2004Ini(UT2004Ini ut2004Ini) {
        super((IniFile)ut2004Ini);
    }

    public String getServerName() {
        return this.getSection(Section_Engine_GameReplicationInfo).get(Key_ServerName);
    }

    public String getServerShortName() {
        return this.getSection(Section_Engine_GameReplicationInfo).get(Key_ShortName);
    }

    public void setServerName(String serverName, String shortName) {
        this.getSection(Section_Engine_GameReplicationInfo).set(Key_ServerName, serverName);
        this.getSection(Section_Engine_GameReplicationInfo).set(Key_ShortName, shortName);
    }

    public int getPort() {
        String port = this.getSection(Section_URL).get(Key_Port);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setPort(int port) {
        this.getSection(Section_URL).set(Key_Port, String.valueOf(port));
    }
}

