/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.ut2004.tournament.GameBots2004Ini;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.util.Map;

public class UT2004DeathMatchConfig
extends UT2004MatchConfig {
    protected int fragLimit = 20;
    protected int timeLimitInMin = 20;

    public UT2004DeathMatchConfig() {
        this.getGb2004Ini().setDMFragLimit(this.fragLimit);
        this.getGb2004Ini().setDMTimeLimit(this.timeLimitInMin);
        this.getUccConf().setGameType("BotDeathMatch");
    }

    public UT2004DeathMatchConfig(UT2004DeathMatchConfig orig) {
        super(orig);
        this.setFragLimit(orig.getFragLimit());
        this.setTimeLimit(orig.getTimeLimit());
    }

    public int getFragLimit() {
        return this.fragLimit;
    }

    public int getTimeLimit() {
        return this.timeLimitInMin;
    }

    @Override
    public UT2004DeathMatchConfig clearBots() {
        super.clearBots();
        return this;
    }

    @Override
    public UT2004DeathMatchConfig clearNativeBots() {
        super.clearNativeBots();
        return this;
    }

    @Override
    public UT2004DeathMatchConfig setOutputDirectory(File outputDirectory) {
        super.setOutputDirectory(outputDirectory);
        return this;
    }

    public UT2004DeathMatchConfig setFragLimit(int fragLimit) {
        if (fragLimit <= 0) {
            throw new PogamutException("Frag limit can't be " + fragLimit + " <= 0.", (Object)this);
        }
        this.fragLimit = fragLimit;
        this.getGb2004Ini().setDMFragLimit(fragLimit);
        return this;
    }

    public UT2004DeathMatchConfig setTimeLimit(int timeLimitInMinutes) {
        if (timeLimitInMinutes < 1) {
            throw new PogamutException("Time limit can't be " + timeLimitInMinutes + " < 1 min.", (Object)this);
        }
        this.timeLimitInMin = timeLimitInMinutes;
        this.getGb2004Ini().setDMTimeLimit(timeLimitInMinutes);
        return this;
    }

    @Override
    public UT2004DeathMatchConfig setUccConf(UCCWrapper.UCCWrapperConf uccConf) {
        super.setUccConf(uccConf);
        return this;
    }

    @Override
    public UT2004DeathMatchConfig setGb2004Ini(GameBots2004Ini gb2004Ini) {
        super.setGb2004Ini(gb2004Ini);
        if (this.getGb2004Ini() != null) {
            if (this.getGb2004Ini().getDMFragLimit() != null) {
                this.fragLimit = this.getGb2004Ini().getDMFragLimit();
            } else {
                this.getGb2004Ini().setDMFragLimit(this.fragLimit);
            }
            if (this.getGb2004Ini().getDMTimeLimit() != null) {
                this.timeLimitInMin = this.getGb2004Ini().getDMTimeLimit();
            } else {
                this.getGb2004Ini().setDMTimeLimit(this.timeLimitInMin);
            }
        }
        return this;
    }

    @Override
    public UT2004DeathMatchConfig setBots(Map<IToken, UT2004BotConfig> bots) {
        super.setBots(bots);
        return this;
    }

    @Override
    public UT2004DeathMatchConfig setNativeBots(Map<IToken, UT2004NativeBotConfig> nativeBots) {
        super.setNativeBots(nativeBots);
        return this;
    }

    @Override
    public UT2004DeathMatchConfig addBot(UT2004BotConfig ... bots) {
        super.addBot(bots);
        return this;
    }

    @Override
    public UT2004MatchConfig setBot(UT2004BotConfig ... bots) {
        super.setBot(bots);
        return this;
    }

    @Override
    public UT2004DeathMatchConfig addNativeBot(UT2004NativeBotConfig ... bots) {
        super.addNativeBot(bots);
        return this;
    }

    @Override
    public UT2004MatchConfig setNativeBot(UT2004NativeBotConfig ... bots) {
        super.setNativeBot(bots);
        return this;
    }

    @Override
    protected void validateInner() {
        super.validateInner();
        if (this.fragLimit <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("FragLimit = " + this.fragLimit + " <= 0");
        }
        if (this.timeLimitInMin < 1) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("TimeLimit = " + this.timeLimitInMin + " < 1 min.");
        }
        if (this.getGb2004Ini().getDMFragLimit() <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("GameBots2004.ini FragLimit = " + this.getGb2004Ini().getDMFragLimit() + " <= 0.");
        }
        if (this.getGb2004Ini().getDMTimeLimit() < 1) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("GameBots2004.ini TimeLimit = " + this.getGb2004Ini().getDMTimeLimit() + " < 1 min.");
        }
    }
}

