/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.IUT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class UT2004DeathMatchTournamentConfig {
    protected int numBotsInOneMatch = 2;
    protected IToken tournamentId;
    protected int fragLimit;
    protected int timeLimitInMinutes;
    protected UCCWrapper.UCCWrapperConf uccConf = new UCCWrapper.UCCWrapperConf();
    protected String outputDir;
    protected Map<IToken, UT2004BotConfig> bots = new HashMap<IToken, UT2004BotConfig>();
    protected Map<IToken, UT2004NativeBotConfig> nativeBots = new HashMap<IToken, UT2004NativeBotConfig>();

    public UT2004DeathMatchTournamentConfig() {
        this.uccConf.setGameType("BotDeathMatch");
        this.uccConf.setStartOnUnusedPort(true);
    }

    public int getNumBotsInOneMatch() {
        return this.numBotsInOneMatch;
    }

    public int getFragLimit() {
        return this.fragLimit;
    }

    public int getTimeLimitInMinutes() {
        return this.timeLimitInMinutes;
    }

    public IToken getTournamentId() {
        return this.tournamentId;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public UCCWrapper.UCCWrapperConf getUccConf() {
        return this.uccConf;
    }

    public Map<IToken, UT2004BotConfig> getBots() {
        return this.bots;
    }

    public Map<IToken, UT2004NativeBotConfig> getNativeBots() {
        return this.nativeBots;
    }

    public void setNumBotsInOneMatch(int numBotsInOneMatch) {
        this.numBotsInOneMatch = numBotsInOneMatch;
    }

    public UT2004DeathMatchTournamentConfig setTournamentId(IToken id) {
        this.tournamentId = id;
        return this;
    }

    public UT2004DeathMatchTournamentConfig setTournamentId(String id) {
        this.tournamentId = Tokens.get((String)id);
        return this;
    }

    public UT2004DeathMatchTournamentConfig setFragLimit(int fragLimit) {
        this.fragLimit = fragLimit;
        return this;
    }

    public UT2004DeathMatchTournamentConfig setTimeLimitInMinutes(int timeLimitInMinutes) {
        this.timeLimitInMinutes = timeLimitInMinutes;
        return this;
    }

    public UT2004DeathMatchTournamentConfig setUnrealHome(String unrealHome) {
        this.uccConf.setUnrealHome(unrealHome);
        return this;
    }

    public UT2004DeathMatchTournamentConfig setMapName(String mapName) {
        this.uccConf.setMapName(mapName);
        return this;
    }

    public UT2004DeathMatchTournamentConfig setOutputDir(String outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public void setUccConf(UCCWrapper.UCCWrapperConf uccConf) {
        this.uccConf = uccConf;
    }

    public UT2004DeathMatchTournamentConfig setBots(Map<IToken, UT2004BotConfig> bots) {
        this.bots = bots;
        return this;
    }

    public UT2004DeathMatchTournamentConfig setNativeBots(Map<IToken, UT2004NativeBotConfig> nativeBots) {
        this.nativeBots = nativeBots;
        return this;
    }

    public UT2004DeathMatchTournamentConfig clearBots() {
        this.bots.clear();
        return this;
    }

    public UT2004DeathMatchTournamentConfig clearNativeBots() {
        this.nativeBots.clear();
        return this;
    }

    public UT2004DeathMatchTournamentConfig addBot(UT2004BotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004BotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.bots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing custom bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            if (this.nativeBots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing native bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            this.bots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public UT2004DeathMatchTournamentConfig setBot(UT2004BotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004BotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.nativeBots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing native bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            this.bots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public UT2004DeathMatchTournamentConfig addNativeBot(UT2004NativeBotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004NativeBotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.bots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing custom bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            if (this.nativeBots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing native bot configuration under this ID. If you need to override it, use setNativeBot().", (Object)this);
            }
            this.nativeBots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public UT2004DeathMatchTournamentConfig setNativeBot(UT2004NativeBotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004NativeBotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.bots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing custom bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            this.nativeBots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public boolean isNativeBot(IToken botId) {
        return this.nativeBots.containsKey(botId);
    }

    public IUT2004BotConfig getBotConfig(IToken botId) {
        UT2004BotConfig config = this.bots.get(botId);
        if (config != null) {
            return config;
        }
        return this.nativeBots.get(botId);
    }

    public void cleanUp() {
        try {
            FileUtils.deleteQuietly((File)new File(this.outputDir));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UT2004DeathMatchConfig createConfiguration(List<IToken> chosenBots) {
        UT2004DeathMatchConfig matchConfig = new UT2004DeathMatchConfig();
        StringBuffer matchId = new StringBuffer();
        boolean first = true;
        for (IToken token : chosenBots) {
            if (first) {
                first = false;
            } else {
                matchId.append("-vs-");
            }
            matchId.append(token.getToken());
        }
        matchConfig.setMatchId(matchId.toString());
        matchConfig.setOutputDirectory(new File(this.outputDir));
        matchConfig.setFragLimit(this.getFragLimit());
        matchConfig.setTimeLimit(this.getTimeLimitInMinutes());
        matchConfig.setUccConf(new UCCWrapper.UCCWrapperConf(this.uccConf));
        for (IToken botId : chosenBots) {
            if (this.isNativeBot(botId)) {
                matchConfig.addNativeBot(new UT2004NativeBotConfig(this.nativeBots.get(botId)));
                continue;
            }
            matchConfig.addBot(new UT2004BotConfig(this.bots.get(botId)));
        }
        return matchConfig;
    }

    protected void generate(List<UT2004DeathMatchConfig> result, int numBots, List<IToken> botIds, int startFrom, List<IToken> chosenBots) {
        if (startFrom >= botIds.size()) {
            return;
        }
        if (chosenBots.size() + (botIds.size() - startFrom) < numBots) {
            return;
        }
        chosenBots.add(botIds.get(startFrom));
        if (chosenBots.size() == numBots) {
            result.add(this.createConfiguration(chosenBots));
        } else {
            for (int i = startFrom + 1; i < botIds.size(); ++i) {
                this.generate(result, numBots, botIds, i, chosenBots);
            }
        }
        chosenBots.remove(chosenBots.size() - 1);
    }

    protected UT2004DeathMatchConfig[] generateMatches(int numBots) {
        ArrayList<IToken> botIds = new ArrayList<IToken>(this.bots.size() + this.nativeBots.size());
        botIds.addAll(this.bots.keySet());
        Collections.sort(botIds, new Comparator<IToken>(){

            @Override
            public int compare(IToken o1, IToken o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getToken().compareTo(o2.getToken());
            }
        });
        ArrayList<IToken> nativeBotIds = new ArrayList<IToken>(this.nativeBots.keySet());
        Collections.sort(nativeBotIds, new Comparator<IToken>(){

            @Override
            public int compare(IToken o1, IToken o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getToken().compareTo(o2.getToken());
            }
        });
        botIds.addAll(nativeBotIds);
        ArrayList<IToken> chosenBots = new ArrayList<IToken>();
        ArrayList<UT2004DeathMatchConfig> result = new ArrayList<UT2004DeathMatchConfig>();
        for (int i = 0; i < this.bots.size(); ++i) {
            this.generate(result, numBots, botIds, i, chosenBots);
        }
        return result.toArray(new UT2004DeathMatchConfig[result.size()]);
    }

    public UT2004DeathMatchConfig[] createMatcheConfigs(int numBotsInOneMatch) {
        if (numBotsInOneMatch < 2) {
            throw new IllegalArgumentException("numBotsInOneMatch = " + numBotsInOneMatch + " < 2 !!!");
        }
        if (numBotsInOneMatch > this.bots.size() + this.nativeBots.size()) {
            throw new IllegalArgumentException("numBotsInOneMatch = " + numBotsInOneMatch + " > " + (this.bots.size() + this.nativeBots.size()) + " = number of all (custom+native) enlisted bots");
        }
        if (this.bots.size() == 0) {
            throw new PogamutException("No custom (Pogamut) bots enlisted to the tournament!", (Object)this);
        }
        return this.generateMatches(numBotsInOneMatch);
    }

    public UT2004DeathMatchConfig[] createMatcheConfigs() {
        return this.createMatcheConfigs(this.getNumBotsInOneMatch());
    }
}

