/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStats;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.tournament.botexecution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004DeathMatch
extends UT2004Match<UT2004DeathMatchConfig, UT2004DeathMatchResult> {
    public UT2004DeathMatch(UT2004DeathMatchConfig config, LogCategory log) {
        super(false, config, log);
    }

    @Override
    protected UT2004MatchResult waitMatchFinish(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, long timeoutInMillis) {
        UT2004DeathMatchResult uT2004DeathMatchResult;
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Waiting for the match to finish...");
        }
        if ((long)(((UT2004DeathMatchConfig)this.config).getTimeLimit() * 60 * 1000 + 300000) > timeoutInMillis) {
            timeoutInMillis = ((UT2004DeathMatchConfig)this.config).getTimeLimit() * 60 * 1000 + 300000;
        }
        HashMap<IToken, 2> customBotObservers = new HashMap<IToken, 2>(((UT2004DeathMatchConfig)this.config).getBots().size());
        FlagListener<IAgentState> serverObs = null;
        IWorldEventListener<PlayerScore> scoresListener = null;
        final CountDownLatch waitLatch = new CountDownLatch(1);
        final AdaptableProvider oneOfBotsDiedOut = new AdaptableProvider((Object)false);
        final AdaptableProvider serverDiedOut = new AdaptableProvider((Object)false);
        final HashMap<UnrealId, PlayerScore> scores = new HashMap<UnrealId, PlayerScore>();
        boolean exception = false;
        try {
            PlayerScore playerScore;
            scoresListener = new IWorldEventListener<PlayerScore>(){

                public void notify(PlayerScore event) {
                    scores.put(event.getId(), event);
                }
            };
            ((UT2004WorldView)server.getWorldView()).addEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
            for (UT2004BotConfig botConfig : ((UT2004DeathMatchConfig)this.config).getBots().values()) {
                FlagListener<Boolean> obs = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (!changedValue.booleanValue()) {
                            oneOfBotsDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                bots.bots.get(botConfig.getBotId()).getRunning().addListener((FlagListener)obs);
                customBotObservers.put(botConfig.getBotId(), obs);
                if (((Boolean)bots.bots.get(botConfig.getBotId()).getRunning().getFlag()).booleanValue()) continue;
                oneOfBotsDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("One of custom bots died out from the start, failure!", (Logger)this.log, (Object)this);
            }
            serverObs = new FlagListener<IAgentState>(){

                public void flagChanged(IAgentState changedValue) {
                    if (changedValue instanceof IAgentStateDown) {
                        serverDiedOut.set((Object)true);
                        waitLatch.countDown();
                    }
                }
            };
            server.getState().addListener((FlagListener)serverObs);
            if (server.notInState(new Class[]{IAgentStateUp.class})) {
                serverDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("Server is dead from the start, failure!", (Logger)this.log, (Object)this);
            }
            waitLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
            if (waitLatch.getCount() > 0L) {
                throw new PogamutException("TIMEOUT! The match did not end in " + timeoutInMillis / 1000L + " secs.", (Logger)this.log, (Object)this);
            }
            bots.matchEnd = System.currentTimeMillis();
            if (((Boolean)oneOfBotsDiedOut.get()).booleanValue()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while giving GB2004 time to tear down its connection.", (Logger)this.log, (Object)this);
                }
                try {
                    server.getAct().act((CommandMessage)new StartPlayers());
                }
                catch (Exception e) {
                    serverDiedOut.set((Object)true);
                }
            }
            if (!((Boolean)serverDiedOut.get()).booleanValue() && server.inState(new Class[]{IAgentStateUp.class})) {
                throw new PogamutException("Match was not terminated correctly, something bad has happenned... some custom bot died out?", (Logger)this.log, (Object)this);
            }
            ArrayList<UnrealId> winners = new ArrayList<UnrealId>(1);
            int maxFrags = 0;
            for (Map.Entry<UnrealId, IToken> entry : bots.unrealId2BotId.entrySet()) {
                playerScore = (PlayerScore)scores.get(entry.getKey());
                if (playerScore == null) {
                    throw new PogamutException("Can't resolve the match result. One of the bot with botId '" + entry.getValue().getToken() + "' and corresponding unrealId '" + entry.getKey().getStringId() + "' has no score entry!", (Logger)this.log, (Object)this);
                }
                if (playerScore.getScore() == maxFrags) {
                    winners.add(entry.getKey());
                    continue;
                }
                if (playerScore.getScore() <= maxFrags) continue;
                maxFrags = playerScore.getScore();
                winners.clear();
                winners.add(entry.getKey());
            }
            for (Map.Entry<UnrealId, IToken> entry : bots.nativeUnrealId2BotId.entrySet()) {
                playerScore = (PlayerScore)scores.get(entry.getKey());
                if (playerScore == null) {
                    throw new PogamutException("Can't resolve the match result. One of the bot with botId '" + entry.getValue().getToken() + "' and corresponding unrealId '" + entry.getKey().getStringId() + "' has no score entry!", (Logger)this.log, (Object)this);
                }
                if (playerScore.getScore() == maxFrags) {
                    winners.add(entry.getKey());
                    continue;
                }
                if (playerScore.getScore() <= maxFrags) continue;
                maxFrags = playerScore.getScore();
                winners.clear();
                winners.add(entry.getKey());
            }
            if (winners.size() == 0) {
                throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
            }
            if (winners.size() > 1) {
                StringBuffer sb = new StringBuffer();
                sb.append("There is more than one bot with highest score == " + maxFrags + ": ");
                boolean first = true;
                for (UnrealId id : winners) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("Bot[botId=" + bots.getBotId(id) + ", unrealId=" + id.getStringId() + ", score=" + ((PlayerScore)scores.get(id)).getScore() + "]");
                }
                sb.append(".");
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(sb.toString());
                }
                throw new PogamutException(sb.toString(), (Logger)this.log, (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": MATCH FINISHED!");
            }
            uT2004DeathMatchResult = this.processResults(ucc, server, analyzer, bots, winners, scores);
        }
        catch (Exception e) {
            try {
                exception = true;
                throw new PogamutException("Failed to perform the match!", (Throwable)e, (Logger)this.log, (Object)this);
            }
            catch (Throwable throwable) {
                for (Map.Entry entry : customBotObservers.entrySet()) {
                    bots.bots.get(entry.getKey()).getRunning().removeListener((FlagListener)entry.getValue());
                }
                server.getState().removeListener(serverObs);
                ((UT2004WorldView)server.getWorldView()).removeEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
                throw throwable;
            }
        }
        for (Map.Entry entry : customBotObservers.entrySet()) {
            bots.bots.get(entry.getKey()).getRunning().removeListener((FlagListener)entry.getValue());
        }
        server.getState().removeListener((FlagListener)serverObs);
        ((UT2004WorldView)server.getWorldView()).removeEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
        return uT2004DeathMatchResult;
    }

    protected UT2004DeathMatchResult processResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, List<UnrealId> winners, Map<UnrealId, PlayerScore> finalScores) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Processing results...");
        }
        UT2004DeathMatchResult result = new UT2004DeathMatchResult();
        result.setMatchTimeEnd(((double)bots.matchEnd - (double)bots.matchStart) / 1000.0);
        for (Map.Entry<UnrealId, PlayerScore> entry : finalScores.entrySet()) {
            result.getFinalScores().put(bots.getBotId(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<UnrealId, PlayerScore> entry : bots.botObservers.entrySet()) {
            if (!(entry.getValue() instanceof UT2004AnalyzerObsStats)) {
                throw new PogamutException("There is an observer of wrong class, expecting UT2004AnalyzerObsStats, got " + ((IUT2004AnalyzerObserver)entry.getValue()).getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
            }
            result.getBotObservers().put((IToken)entry.getKey(), (UT2004AnalyzerObsStats)entry.getValue());
        }
        List<IToken> botIds = ((UT2004DeathMatchConfig)this.config).getAllBotIds();
        for (IToken iToken : botIds) {
            result.getTotalKills().put(iToken, 0);
            result.getWasKilled().put(iToken, 0);
            result.getSuicides().put(iToken, 0);
            for (IToken botId2 : botIds) {
                result.getKillCounts().put((Object)iToken, (Object)botId2, (Object)0);
            }
        }
        for (Map.Entry<IToken, UT2004AnalyzerObsStats> entry : result.getBotObservers().entrySet()) {
            IToken botId = entry.getKey();
            UT2004AnalyzerObsStats obs = entry.getValue();
            AgentStats stats = obs.getStats();
            for (Map.Entry killed : stats.getKilled().entrySet()) {
                result.getKillCounts().get((Object)botId).put(bots.getBotId((UnrealId)killed.getKey()), killed.getValue());
            }
            for (Map.Entry killedBy : stats.getKilledBy().entrySet()) {
                if (!bots.isNativeBot((UnrealId)killedBy.getKey())) continue;
                result.getKillCounts().get((Object)bots.getBotId((UnrealId)killedBy.getKey())).put(botId, killedBy.getValue());
            }
            result.getSuicides().put(botId, stats.getSuicides());
            result.getKillCounts().put((Object)botId, (Object)botId, (Object)stats.getSuicides());
        }
        for (IToken iToken : ((UT2004DeathMatchConfig)this.config).getNativeBots().keySet()) {
            for (IToken nativeBotId2 : ((UT2004DeathMatchConfig)this.config).getNativeBots().keySet()) {
                if (iToken == nativeBotId2) continue;
                result.getKillCounts().get((Object)iToken).put(nativeBotId2, 0);
            }
            result.getSuicides().put(iToken, 0);
        }
        for (IToken iToken : botIds) {
            int totalKills = 0;
            int totalKilled = 0;
            for (IToken other : botIds) {
                if (iToken == other) continue;
                totalKills += ((Integer)result.getKillCounts().get((Object)iToken, (Object)other)).intValue();
                totalKilled += ((Integer)result.getKillCounts().get((Object)other, (Object)iToken)).intValue();
            }
            result.getTotalKills().put(iToken, totalKills);
            result.getWasKilled().put(iToken, totalKilled);
            if (!((UT2004DeathMatchConfig)this.config).isNativeBot(iToken)) continue;
            result.getSuicides().put(iToken, result.getFinalScores().get(iToken).getDeaths() - totalKilled);
        }
        if (winners.size() <= 0) {
            throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
        }
        if (winners.size() == 1) {
            result.setWinnerBot(bots.getBotId(winners.get(0)));
        } else {
            result.setDraw(true);
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Results processed, " + (result.isDraw() ? "DRAW!" : "winner is Bot[botId=" + result.getWinnerBot().getToken() + ", unrealId=" + bots.getUnrealId(result.getWinnerBot()).getStringId() + "]."));
        }
        return result;
    }

    protected void outputResults_step1(UT2004DeathMatchResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Outputting match result into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-result.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            writer.format("MatchId;FragLimit;TimeLimit;TimeEnd;Winner\n", new Object[0]);
            writer.format("%s;%d;%d;%.3f;%s", ((UT2004DeathMatchConfig)this.config).getMatchId().getToken(), ((UT2004DeathMatchConfig)this.config).getFragLimit(), ((UT2004DeathMatchConfig)this.config).getTimeLimit(), result.getMatchTimeEnd(), result.isDraw() ? "DRAW" : String.valueOf(result.getWinnerBot().getToken()));
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Match result output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults_step2(UT2004DeathMatchResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Outputting match scores into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-bot-scores.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            ArrayList<IToken> bots = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getBots().keySet());
            ArrayList<IToken> nativeBots = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getNativeBots().keySet());
            Collections.sort(bots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            Collections.sort(nativeBots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            result.setBots(bots);
            result.setNativeBots(nativeBots);
            writer.format("botId", new Object[0]);
            writer.format(";score;kills;killedByOthers;deaths;suicides", new Object[0]);
            for (IToken token : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                writer.format(";", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
            }
            for (IToken token : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                writer.format("\n", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
                writer.format(";%d", result.getFinalScores().get(token).getScore());
                writer.format(";%d", result.getTotalKills().get(token));
                writer.format(";%d", result.getWasKilled().get(token));
                writer.format(";%d", result.getFinalScores().get(token).getDeaths());
                writer.format(";%d", result.getSuicides().get(token));
                for (IToken token2 : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                    writer.format(";%d", result.getKillCounts().get((Object)token).get(token2));
                }
            }
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Match scores output into " + file.getAbsolutePath() + ".");
        }
    }

    @Override
    protected void outputResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, UT2004MatchResult result, File outputDirectory) {
        if (!(result instanceof UT2004DeathMatchResult)) {
            throw new PogamutException("Can't out results! Expected results of class UT2004DeathMatchResult and got " + result.getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
        }
        this.outputResults_step1((UT2004DeathMatchResult)result, outputDirectory);
        this.outputResults_step2((UT2004DeathMatchResult)result, outputDirectory);
    }

    @Override
    public UT2004DeathMatchResult execute() {
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Executing!");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UCCWrapper ucc = null;
        UT2004Server server = null;
        UT2004Match.Bots bots = null;
        UT2004Analyzer analyzer = null;
        String recordFileName = ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-replay-" + UT2004Match.getCurrentDate();
        boolean exception = false;
        try {
            this.setupLogger();
            this.validate();
            this.createGB2004Ini();
            ucc = this.startUCC();
            server = this.startControlServer(ucc);
            bots = this.startBots(ucc, server);
            analyzer = this.startAnalyzer(ucc, bots, this.getOutputPath("bots"));
            this.matchIsAboutToBegin(ucc, server, analyzer, bots);
            this.restartMatch(server, bots);
            this.recordReplay(server, recordFileName);
            UT2004DeathMatchResult result = (UT2004DeathMatchResult)this.waitMatchFinish(ucc, server, analyzer, bots, ((UT2004DeathMatchConfig)this.config).getTimeLimit() * 1000 + 60000);
            this.copyReplay(ucc, recordFileName, this.getOutputPath());
            this.outputResults(ucc, server, analyzer, bots, result, this.getOutputPath());
            this.shutdownAll(ucc, server, analyzer, bots);
            ucc = null;
            server = null;
            analyzer = null;
            bots = null;
            UT2004DeathMatchResult uT2004DeathMatchResult = result;
            return uT2004DeathMatchResult;
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": EXCEPTION!"), (Throwable)e));
            }
            exception = true;
            if (e instanceof PogamutException) {
                throw (PogamutException)e;
            }
            throw new PogamutException((Throwable)e, (Logger)this.log, (Object)this);
        }
        finally {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Cleaning up...");
                }
            }
            catch (Exception e) {}
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                    }
                }
                catch (Exception e) {}
                try {
                    ucc.stop();
                }
                catch (Exception e) {}
            }
            if (server != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing UT2004Server...");
                    }
                }
                catch (Exception e) {}
                try {
                    server.kill();
                }
                catch (Exception e) {}
            }
            if (bots != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing Custom bots...");
                    }
                }
                catch (Exception e) {}
                for (UT2004BotExecution exec : bots.bots.values()) {
                    try {
                        exec.stop();
                    }
                    catch (Exception e) {}
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing Custom bot observers...");
                    }
                }
                catch (Exception e) {}
                for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                    try {
                        obs.kill();
                    }
                    catch (Exception e) {}
                }
            }
            if (analyzer != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing UT2004Analyzer...");
                    }
                }
                catch (Exception e) {}
                try {
                    analyzer.kill();
                }
                catch (Exception e) {}
            }
            try {
                this.restoreGB2004IniBackup();
            }
            catch (Exception e) {}
            try {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    if (exception) {
                        this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Cleaned up, MATCH FAILED!");
                    } else {
                        this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Cleaned up, match finished successfully.");
                    }
                }
            }
            catch (Exception e) {}
            try {
                this.closeLogger();
            }
            catch (Exception e) {}
        }
    }
}

