/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchTournamentConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchExecutor;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class UT2004DeathMatchTournament
implements Callable<Map<IToken, UT2004DeathMatchResult>>,
Runnable {
    private LogCategory log;
    private UT2004DeathMatchTournamentConfig config;
    private UT2004MatchExecutor<UT2004DeathMatch, UT2004DeathMatchResult> executor;

    public UT2004DeathMatchTournament(UT2004DeathMatchTournamentConfig config, LogCategory log) {
        this.log = log;
        this.config = config;
        NullCheck.check((Object)this.config, (String)"config");
    }

    public Map<IToken, UT2004DeathMatchResult> getResults() {
        if (this.executor == null) {
            throw new PogamutException("There are no results available, you have to run tournament first!", (Object)this);
        }
        return this.executor.getResults();
    }

    public Map<IToken, Throwable> getExceptions() {
        if (this.executor == null) {
            throw new PogamutException("There are no results available, you have to run tournament first!", (Object)this);
        }
        return this.executor.getExceptions();
    }

    @Override
    public Map<IToken, UT2004DeathMatchResult> call() throws Exception {
        return this.executor.getResults();
    }

    @Override
    public synchronized void run() {
        UT2004DeathMatchConfig[] configs = this.config.createMatcheConfigs();
        UT2004Match[] matches = new UT2004DeathMatch[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            matches[i] = new UT2004DeathMatch(configs[i], new LogCategory(configs[i].getMatchId().getToken()));
            matches[i].getLog().addHandler(new ILogPublisher(){

                public void close() throws SecurityException {
                }

                public void flush() {
                }

                public void publish(LogRecord record) {
                    if (UT2004DeathMatchTournament.this.log != null) {
                        UT2004DeathMatchTournament.this.log.log(record);
                    }
                }
            });
        }
        this.executor = new UT2004MatchExecutor(matches, (Logger)this.log);
        this.executor.run();
    }

    public void cleanUp() {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Cleaning up! Deleting: " + this.getOutputPath().getAbsolutePath());
        }
        FileUtils.deleteQuietly((File)this.getOutputPath());
    }

    public File getOutputPath() {
        return new File(this.config.getOutputDir());
    }
}

