/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw.config;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlag;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlagConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import java.io.File;
import java.util.Map;

/**
 *
 * @author tommasino
 */
public class MatchConfig {

    /**
     * @parameter
     */
    private int fragLimit;
    /**
     * @parameter
     */
    private String gameType;
    /**
     * @parameter
     */
    private String id;
    /**
     * @parameter
     */
    private String map;
    /**
     * @parameter
     */
    private int runs;
    /**
     * @parameter
     */
    private ParticipantConfig[] participants;

    /**
     *
     * @return
     */
    public String getMap() {
        return map;
    }

    /**
     *
     * @return
     */
    public int getFragLimit() {
        return fragLimit;
    }

    /**
     *
     * @return
     */
    public int getRuns() {
        return runs;
    }

    /**
     *
     * @return
     */
    public String getHash() {
        return id;
    }

    /**
     *
     * @return
     */
    public String getId() {
        return id;
    }

    /**
     *
     * @param utPath
     * @param bots
     * @return
     */
    public UT2004Match createMatch(String utPath, Map<String, BotTemplate> bots) {
        if (gameType.equals("deathmatch")) {
            return createDeathMatch(utPath, bots);
        } else if (gameType.equals("ctf")) {
            return createCTFMatch(utPath, bots);
        } else {
            throw new IllegalArgumentException("Game type is not valid");
        }
    }

    /**
     *
     * @param utPath
     * @param bots
     * @return
     */
    private UT2004Match createDeathMatch(String utPath, Map<String, BotTemplate> bots) {
        UT2004DeathMatchConfig matchConfig = new UT2004DeathMatchConfig();

        matchConfig.setMatchId("TestingMatch");
        matchConfig.setOutputDirectory(new File("target" + File.separator + "matches"));

        matchConfig.setFragLimit(fragLimit);
        matchConfig.setTimeLimit(fragLimit + 1); // startup takes ~ 1 minute

        matchConfig.getUccConf().setStartOnUnusedPort(true);
        matchConfig.getUccConf().setUnrealHome(utPath);
        matchConfig.getUccConf().setGameType("BotDeathMatch");
        matchConfig.getUccConf().setMapName(map);

        for (ParticipantConfig participant : participants) {
            participant.addParticipants(matchConfig, bots);
        }

        return new UT2004DeathMatch(matchConfig, new LogCategory("DM"));
    }

    /**
     *
     * @param utPath
     * @param bots
     * @return
     */
    private UT2004Match createCTFMatch(String utPath, Map<String, BotTemplate> bots) {
        UT2004CaptureTheFlagConfig matchConfig = new UT2004CaptureTheFlagConfig();

        matchConfig.setMatchId("TestingMatch");
        matchConfig.setOutputDirectory(new File("target" + File.separator + "matches"));

        matchConfig.setScoreLimit(fragLimit);
        matchConfig.setTimeLimit(fragLimit + 1); // startup takes ~ 1 minute

        matchConfig.getUccConf().setStartOnUnusedPort(true);
        matchConfig.getUccConf().setUnrealHome(utPath);
        matchConfig.getUccConf().setMapName(map);

        for (ParticipantConfig participant : participants) {
            participant.addParticipants(matchConfig, bots);
        }

        return new UT2004CaptureTheFlag(matchConfig, new LogCategory("CTFMatch"));
    }
}
