/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCRecipient;
import cz.cuni.amis.utils.SafeEquals;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TCMessage
implements IWorldChangeEvent,
IWorldEvent,
Serializable {
    private static final long serialVersionUID = 1656106303299952920L;
    private long simTime;
    private IToken messageType;
    private byte[] messageData;
    private UnrealId source;
    private TCRecipient target;
    private boolean excludeMyselfIfApplicable;
    private int channelId;
    private UnrealId targetId;
    private transient boolean resolved = false;
    private transient Serializable message = null;

    public TCMessage(UnrealId source, TCRecipient target, boolean excludeMyselfIfApplicable, IToken messageType, Serializable message, long simTime) {
        this.source = source;
        this.target = target;
        this.excludeMyselfIfApplicable = excludeMyselfIfApplicable;
        this.messageType = messageType;
        this.message = message;
        if (message == null) {
            this.messageData = null;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(bos);
                    out.writeObject(message);
                    this.messageData = bos.toByteArray();
                }
                catch (IOException e) {
                    throw new PogamutException("Failed to serialize: " + message, (Throwable)e, (Object)this);
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                out = null;
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                    bos = null;
                }
            }
        }
        this.simTime = simTime;
    }

    private void readObject(ObjectInputStream ois) {
        try {
            ois.defaultReadObject();
            if (this.messageType != null) {
                this.messageType = Tokens.get((String)this.messageType.getToken());
            }
            if (this.source != null) {
                this.source = UnrealId.get((String)this.source.getStringId());
            }
            this.resolved = false;
            this.message = null;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize the object.", e);
        }
    }

    public IToken getMessageType() {
        return this.messageType;
    }

    public boolean isMessageType(String type) {
        return SafeEquals.equals((Object)this.messageType, (Object)Tokens.get((String)type));
    }

    public boolean isMessageType(IToken type) {
        return SafeEquals.equals((Object)this.messageType, (Object)type);
    }

    public Serializable getMessage() throws PogamutException {
        if (this.messageData == null) {
            return null;
        }
        if (this.message == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.messageData);
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(bis);
                    this.message = (Serializable)in.readObject();
                }
                catch (Exception e) {
                    throw new PogamutException("Failed to deserialize TCMessage of type " + this.messageType.getToken() + "...", (Throwable)e, (Object)this);
                }
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                    bis = null;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    Object var2_2 = null;
                }
            }
        }
        return this.message;
    }

    public Serializable getData() {
        return this.messageData;
    }

    public TCRecipient getTarget() {
        return this.target;
    }

    public boolean isTarget(TCRecipient target) {
        return SafeEquals.equals((Object)((Object)this.target), (Object)((Object)target));
    }

    public boolean isExcludeMyselfIfApplicable() {
        return this.excludeMyselfIfApplicable;
    }

    public UnrealId getSource() {
        return this.source;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public UnrealId getTargetId() {
        return this.targetId;
    }

    public void setTargetId(UnrealId targetId) {
        this.targetId = targetId;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void markResolved() {
        this.resolved = true;
    }

    public long getSimTime() {
        return this.simTime;
    }

    public String toString() {
        return "TCMessage[from=" + (this.source == null ? "NULL" : this.source.getStringId()) + ", messageType=" + (this.messageType == null ? "NULL" : this.messageType.getToken()) + ", target=" + (Object)((Object)this.target) + "]";
    }
}

