/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.observer;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometryModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.RayCastResult;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSGameConfig;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.HSBotRecord;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HSObserverGeom {
    private LevelGeometryModule level;
    private HSGameConfig config;
    private List<HSBotRecord<PlayerMessage>> players;
    private HSBotRecord<PlayerMessage> seeker;
    private Map<PlayerMessage, Double> visibleTimes = new LazyMap<PlayerMessage, Double>(){

        protected Double create(PlayerMessage key) {
            return 0.0;
        }
    };
    private Set<HSBotRecord<PlayerMessage>> spotted = new HashSet<HSBotRecord<PlayerMessage>>();

    public HSObserverGeom(LevelGeometryModule level, HSGameConfig config) {
        this.level = level;
        this.config = config;
    }

    public void setPlayers(List<HSBotRecord<PlayerMessage>> players) {
        this.players = players;
    }

    public void setSeeker(HSBotRecord<PlayerMessage> seeker) {
        this.seeker = seeker;
    }

    public void tick(double timeDeltaSecs) {
        PlayerMessage seeker = this.seeker.getPlayer();
        System.out.println("================================");
        System.out.println("SEEKER: " + seeker.getLocation());
        System.out.println("  +-- EYE " + seeker.getRotation().toLocation().setZ(0.0).getNormalized());
        for (HSBotRecord<PlayerMessage> record : this.players) {
            if (record == this.seeker) continue;
            PlayerMessage player = record.getPlayer();
            if (player.getLocation().getDistance(seeker.getLocation()) < 100.0) {
                System.out.println("NEAR: " + player.getId().getStringId() + " at " + player.getLocation());
                this.visible(record, timeDeltaSecs);
                continue;
            }
            RayCastResult raycast = this.level.getLevelGeometry().rayCast(seeker.getLocation(), player.getLocation());
            if (raycast.isHit()) {
                this.notVisible(record, timeDeltaSecs);
                continue;
            }
            System.out.println("POSSIBLE: " + player.getId().getStringId() + " at " + player.getLocation());
            Location seekerEye = seeker.getRotation().toLocation().setZ(0.0).getNormalized();
            Location toPlayer = player.getLocation().sub(seeker.getLocation()).setZ(0.0).getNormalized();
            System.out.println("  +-- toPlayer " + toPlayer);
            double angle = Math.acos(seekerEye.dot(toPlayer));
            double angleDeg = angle / Math.PI * 180.0;
            System.out.println("  +-- ANGLE: " + angleDeg);
            if (angleDeg >= -85.0 && angleDeg <= 85.0) {
                this.visible(record, timeDeltaSecs);
                continue;
            }
            System.out.println(" +-- NOT IN FOV");
            this.notVisible(record, timeDeltaSecs);
        }
    }

    private void visible(HSBotRecord<PlayerMessage> record, double timeDeltaSecs) {
        double time = 0.0;
        if (this.visibleTimes.containsKey(record.getPlayer())) {
            time = this.visibleTimes.get(record.getPlayer()) + timeDeltaSecs;
            time = this.visibleTimes.put(record.getPlayer(), time);
        } else {
            this.visibleTimes.put(record.getPlayer(), 0.0);
        }
        System.out.println("  +-- VISIBLE " + time + " sec");
        if (time * 1000.0 >= (double)this.config.getSpotTimeMillis()) {
            System.out.println("  +-- SPOTTED!!!");
            this.spotted.add(record);
        }
    }

    private void notVisible(HSBotRecord<PlayerMessage> record, double timeDeltaSecs) {
        double time = 0.0;
        if (!this.visibleTimes.containsKey(record.getPlayer())) {
            return;
        }
        time = this.visibleTimes.get(record.getPlayer()) - timeDeltaSecs;
        if (time < 0.0) {
            this.visibleTimes.remove(record.getPlayer());
            System.out.println("  +-- NOT VISIBLE (removed)");
        } else {
            this.visibleTimes.put(record.getPlayer(), time);
            System.out.println("  +-- NOT VISIBLE (left " + time + " sec)");
        }
    }

    public Set<HSBotRecord<PlayerMessage>> getSpotted() {
        return this.spotted;
    }
}

