/*
 * Decompiled with CFR 0.152.
 */
package SteeringStuff;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class SteeringTools {
    public static Vector2d getIntersection(Vector2d sA, Vector2d dA, Vector2d sB, Vector2d dB, LineType typeA, LineType typeB) {
        Vector2d result = null;
        double lengthA = dA.length();
        double lengthB = dB.length();
        dA.normalize();
        dB.normalize();
        if (!dA.equals((Tuple2d)dB)) {
            if (dA.x == 0.0) {
                dA.x = 0.001;
            }
            if (dB.x == 0.0) {
                dB.x = 0.001;
            }
            if (dA.y == 0.0) {
                dA.y = 0.001;
            }
            if (dB.y == 0.0) {
                dB.y = 0.001;
            }
            double tB = (sA.y - sB.y) / dB.y + dA.y * (sB.x - sA.x) / (dA.x * dB.y);
            double tA = sB.x - sA.x + (tB /= 1.0 - dB.x * dA.y / (dA.x * dB.y)) * dB.x;
            double pointX = sA.x + (tA /= dA.x) * dA.x;
            double pointY = sA.y + tA * dA.y;
            result = new Vector2d(pointX, pointY);
            switch (typeA) {
                case HALF_LINE: {
                    if (!(tA < 0.0)) break;
                    result = null;
                    break;
                }
                case ABSCISSA: {
                    if (!(tA < 0.0) && !(tA > lengthA)) break;
                    result = null;
                }
            }
            switch (typeB) {
                case HALF_LINE: {
                    if (!(tB < 0.0)) break;
                    result = null;
                    break;
                }
                case ABSCISSA: {
                    if (!(tB < 0.0) && !(tB > lengthB)) break;
                    result = null;
                }
            }
        }
        return result;
    }

    public static Vector2d getIntersectionOld(Vector2d sA, Vector2d dA, Vector2d sB, Vector2d dB) {
        Vector2d result = null;
        dA.normalize();
        dB.normalize();
        if (!dA.equals((Tuple2d)dB)) {
            if (dA.x == 0.0) {
                dA.x = 0.001;
            }
            if (dB.x == 0.0) {
                dB.x = 0.001;
            }
            if (dA.y == 0.0) {
                dA.y = 0.001;
            }
            if (dB.y == 0.0) {
                dB.y = 0.001;
            }
            double tB = (sA.y - sB.y) / dB.y + dA.y * (sB.x - sA.x) / (dA.x * dB.y);
            double tA = sB.x - sA.x + (tB /= 1.0 - dB.x * dA.y / (dA.x * dB.y)) * dB.x;
            double pointX = sA.x + (tA /= dA.x) * dA.x;
            double pointY = sA.y + tA * dA.y;
            if (tA >= 0.0 && tB >= 0.0) {
                result = new Vector2d(pointX, pointY);
            }
        }
        return result;
    }

    public static boolean haveSameDirection(Vector2d sA, Vector2d dA, Vector2d sB, Vector2d dB) {
        dA.normalize();
        dB.normalize();
        return dA.equals((Tuple2d)dB);
    }

    public static Vector2d getNearestPoint(Vector2d start, Vector2d end, Vector2d pointP, boolean justAbscissa) {
        Vector2d abscissa = new Vector2d(end.x - start.x, end.y - start.y);
        double a = abscissa.y;
        double b = -abscissa.x;
        double c = -a * start.x - b * start.y;
        if (a == 0.0) {
            a = 0.001;
        }
        if (a * a + b * b == 0.0) {
            a += 0.001;
        }
        double d = b * pointP.x - a * pointP.y;
        double footXCor = (b * ((a * d + b * c) / (a * a + b * b)) - c) / a;
        double footYCor = (-a * d - b * c) / (a * a + b * b);
        Vector2d foot = new Vector2d(footXCor, footYCor);
        Vector2d middlePoint = new Vector2d((start.x + end.x) / 2.0, (start.y + end.y) / 2.0);
        Vector2d footToMiddlePoint = new Vector2d(foot.x - middlePoint.x, foot.y - middlePoint.y);
        Vector2d nearestPoint = new Vector2d(foot.x, foot.y);
        if (justAbscissa && footToMiddlePoint.length() > abscissa.length()) {
            Vector2d startToPointP = new Vector2d(start.x - pointP.x, start.y - pointP.y);
            Vector2d endToPointP = new Vector2d(end.x - pointP.x, end.y - pointP.y);
            nearestPoint = startToPointP.length() < endToPointP.length() ? start : end;
        }
        return nearestPoint;
    }

    public static boolean pointIsLeftFromTheVector(Vector3d vector, Vector3d point) {
        double b = vector.y;
        double a = vector.x;
        return b * point.x - a * point.y >= 0.0;
    }

    public static Vector3d getTurningVector(Vector3d actualVelocity, boolean left) {
        Vector3d turningVector = left ? new Vector3d(actualVelocity.y, -actualVelocity.x, 0.0) : new Vector3d(-actualVelocity.y, actualVelocity.x, 0.0);
        turningVector.scale(1.0 / Math.sqrt(2.0));
        Vector3d negativeVector = new Vector3d(-actualVelocity.x, -actualVelocity.y, 0.0);
        negativeVector.scale(1.0 - 1.0 / Math.sqrt(2.0));
        turningVector.add((Tuple3d)negativeVector);
        return turningVector;
    }

    public static Vector3d getTurningVector2(Vector3d actualVelocity, boolean left) {
        Vector3d turningVector = left ? new Vector3d(actualVelocity.y, -actualVelocity.x, 0.0) : new Vector3d(-actualVelocity.y, actualVelocity.x, 0.0);
        return turningVector;
    }

    public static double radiansToDegrees(double rad) {
        return 180.0 * rad / Math.PI % 360.0;
    }

    public static double degreesToRadians(double deg) {
        return Math.PI * deg / 180.0;
    }

    public static Location[] commonPoints(Location P0, double r0, Location P1, double r1) {
        Location[] result = new Location[]{null, null};
        int d = (int)P1.getDistance2D(P0);
        if ((double)d > r0 + r1 || (double)d < Math.abs(r0 - r1)) {
            return result;
        }
        double a = (r0 * r0 - r1 * r1 + (double)(d * d)) / (double)(2 * d);
        Location P2 = P0.add(P1.sub(P0).scale(a / (double)d));
        double h = Math.sqrt(r0 * r0 - a * a);
        int x3 = (int)(P2.x - h * (P1.y - P0.y) / (double)d);
        int y3 = (int)(P2.y + h * (P1.x - P0.x) / (double)d);
        int x32 = (int)(P2.x + h * (P1.y - P0.y) / (double)d);
        int y32 = (int)(P2.y - h * (P1.x - P0.x) / (double)d);
        result[0] = new Location((double)x3, (double)y3);
        result[1] = new Location((double)x32, (double)y32);
        return result;
    }

    @Deprecated
    public static double getAngleOld(Location botLocation, Location focus, Location point) {
        Vector2d foot = SteeringTools.getNearestPoint(new Vector2d(botLocation.x, botLocation.y), new Vector2d(focus.x, focus.y), new Vector2d(point.x, point.y), false);
        Location footL = new Location(foot.x, foot.y, botLocation.z);
        Location pointZ = new Location(point.x, point.y, botLocation.z);
        return Math.asin(pointZ.sub(footL).getLength() / pointZ.sub(botLocation).getLength());
    }

    public static double getAngle(Location botLocation, Rotation botRotation, Location point) {
        Location moveVec = point.sub(botLocation).getNormalized();
        return Math.acos(botRotation.toLocation().getNormalized().dot2D(moveVec));
    }

    public static enum LineType {
        STRAIGHT_LINE,
        HALF_LINE,
        ABSCISSA;

    }
}

