/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SocialSteeringsBeta.RefLocation;
import SteeringProperties.SteeringProperties;
import SteeringProperties.StickToPathProperties;
import SteeringStuff.ISteering;
import SteeringStuff.RefBoolean;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphHelper;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.Tuple3;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;

public class StickToPathSteer
implements ISteering {
    private UT2004Bot bot;
    private static int NEARLY_THERE_DISTANCE = 150;
    private static double NAVPOINT_MAX_DISTANCE = 100.0;
    private StickToPathProperties properties;
    private IPathFuture<ILocated> pathFuture;
    private List<ILocated> pathLocations;
    private List<NavPoint> pathNavPoints;
    private List<NavPointNeighbourLink> pathLinks;

    public StickToPathSteer(UT2004Bot bot) {
        this.bot = bot;
    }

    @Override
    public Vector3d run(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, RefLocation focus) {
        this.ensurePath();
        if (!this.hasPath()) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        Tuple3<NavPointNeighbourLink, NavPointNeighbourLink, NavPointNeighbourLink> links = this.getCurrentLinks();
        if (links == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        NavPointNeighbourLink prevLink = (NavPointNeighbourLink)links.getFirst();
        NavPointNeighbourLink currLink = (NavPointNeighbourLink)links.getSecond();
        NavPointNeighbourLink nextLink = (NavPointNeighbourLink)links.getThird();
        if (currLink != null) {
            return this.steerCurrLink(currLink, nextLink);
        }
        if (nextLink != null) {
            return this.steerNextLink(nextLink);
        }
        return new Vector3d(0.0, 0.0, 0.0);
    }

    private Vector3d steerCurrLink(NavPointNeighbourLink currLink, NavPointNeighbourLink nextLink) {
        Location projection = NavigationGraphHelper.projectPointToLinkLine((NavPointNeighbourLink)currLink, (ILocated)this.bot.getLocation());
        double distance = NavigationGraphHelper.NAV_LINK_GET_DISTANCE.getDistance((Object)currLink, (ILocated)this.bot.getLocation());
        double ratio = currLink.getCollisionR() <= 0 ? 0.0 : distance / (double)currLink.getCollisionR();
        Location result = projection.sub(this.bot.getLocation()).scale(ratio).setZ(0.0);
        return result.asVector3d();
    }

    private Vector3d steerNextLink(NavPointNeighbourLink nextLink) {
        Location projection = nextLink.getFromNavPoint().getLocation();
        Location result = projection.sub(this.bot.getLocation()).getNormalized().scale(50.0).setZ(0.0);
        return result.asVector3d();
    }

    private void reset() {
        this.pathFuture = null;
        this.pathLocations = null;
        this.pathNavPoints = null;
        this.pathLinks = null;
    }

    private boolean hasPath() {
        return this.pathFuture != null && this.pathLocations != null && this.pathNavPoints != null && this.pathLinks != null && this.pathLocations.size() > 0 && this.pathNavPoints.size() > 0;
    }

    private void ensurePath() {
        if (this.pathFuture == this.properties.getPath()) {
            return;
        }
        if (this.properties.getPath() == null) {
            System.out.println("PATH IS NULL! Use stickToPathProperties.setPath() to provide a path before you use the steering!");
            this.reset();
            return;
        }
        if (!this.properties.getPath().isDone()) {
            System.out.println("Waiting for the path...");
            this.reset();
            return;
        }
        if (this.properties.getPath().get() == null) {
            System.out.println("Provided PATH is null, path does not exist? Or incorrect path future provided?");
            this.reset();
            return;
        }
        if (this.properties.getPath().get().size() == 0) {
            System.out.println("Provided PATH is 0-sized! Path does not exist? Or incorrect path future provided?");
            this.reset();
            return;
        }
        this.pathFuture = this.properties.getPath();
        this.pathLocations = this.getPath(this.pathFuture);
        this.pathNavPoints = this.getNavPoints(this.pathLocations);
        this.pathLinks = this.getLinks(this.pathNavPoints);
    }

    private List<NavPoint> getNavPoints(List<ILocated> pathLocations) {
        if (pathLocations == null) {
            return null;
        }
        ArrayList<NavPoint> result = new ArrayList<NavPoint>(pathLocations.size());
        for (ILocated location : pathLocations) {
            result.add(this.getNearestNavPoint(location, NAVPOINT_MAX_DISTANCE));
        }
        return result;
    }

    private List<NavPointNeighbourLink> getLinks(List<NavPoint> pathNavPoints) {
        if (pathNavPoints == null) {
            return null;
        }
        if (pathNavPoints.size() == 1) {
            ArrayList<NavPointNeighbourLink> result = new ArrayList<NavPointNeighbourLink>(1);
            result.add(null);
            return result;
        }
        ArrayList<NavPointNeighbourLink> result = new ArrayList<NavPointNeighbourLink>();
        NavPoint previous = pathNavPoints.get(0);
        for (int i = 1; i < pathNavPoints.size(); ++i) {
            NavPoint curr = pathNavPoints.get(i);
            if (previous != null && curr != null) {
                result.add((NavPointNeighbourLink)previous.getOutgoingEdges().get(curr.getId()));
            } else {
                result.add(null);
            }
            previous = curr;
        }
        return result;
    }

    public NavPoint getNearestNavPoint(ILocated target, double maxDistance) {
        if (target == null || target.getLocation() == null) {
            return null;
        }
        NavPoint result = (NavPoint)DistanceUtils.getNearest(this.bot.getWorldView().getAll(NavPoint.class).values(), (ILocated)target);
        if (result == null) {
            return null;
        }
        if (target.getLocation().getDistance(result.getLocation()) > maxDistance) {
            return null;
        }
        return result;
    }

    private Tuple3<NavPointNeighbourLink, NavPointNeighbourLink, NavPointNeighbourLink> getCurrentLinks() {
        if (!this.hasPath()) {
            return null;
        }
        NavPointNeighbourLink nearest = (NavPointNeighbourLink)DistanceUtils.getNearest(this.pathLinks, (ILocated)this.bot.getLocation(), (DistanceUtils.IGetDistance)NavigationGraphHelper.NAV_LINK_GET_DISTANCE);
        if (nearest == null) {
            return null;
        }
        int index = this.pathLinks.indexOf(nearest);
        if (NavigationGraphHelper.isPointProjectionOnLinkSegment((NavPointNeighbourLink)nearest, (ILocated)this.bot.getLocation()).booleanValue()) {
            return new Tuple3((Object)this.getPathLink(index - 1), (Object)this.getPathLink(index), (Object)this.getPathLink(index + 1));
        }
        if (NavigationGraphHelper.isPointProjectionBeforeLinkSegment((NavPointNeighbourLink)nearest, (ILocated)this.bot.getLocation()).booleanValue()) {
            return new Tuple3((Object)this.getPathLink(index - 2), (Object)this.getPathLink(index - 1), (Object)this.getPathLink(index));
        }
        return new Tuple3((Object)this.getPathLink(index), (Object)this.getPathLink(index + 1), (Object)this.getPathLink(index + 2));
    }

    private NavPointNeighbourLink getPathLink(int index) {
        if (this.pathLinks == null) {
            return null;
        }
        if (index < 0 || index >= this.pathLinks.size()) {
            return null;
        }
        return this.pathLinks.get(index);
    }

    private List<ILocated> getPath(IPathFuture<ILocated> path) {
        List locations = path.get();
        if (locations == null) {
            System.out.println("Provided PATH is null, have you provided correct path via stickToPathProperties.setPath() ?");
            return null;
        }
        if (locations.size() == 0) {
            System.out.println("Provided PATH has no elements, have you provided correct path via stickToPathProperties.setPath() ?");
            return null;
        }
        return locations;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        if (!(newProperties instanceof StickToPathProperties)) {
            throw new RuntimeException("newProperties is not of class StickToPathProperties, but " + newProperties.getClass());
        }
        this.properties = new StickToPathProperties((StickToPathProperties)newProperties);
    }

    public StickToPathProperties getProperties() {
        return new StickToPathProperties(this.properties);
    }
}

