/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.SteeringProperties;
import SteeringStuff.SteeringType;
import XMLSteeringProperties.XMLPeopleAvoidanceProperties;

public class PeopleAvoidanceProperties
extends SteeringProperties {
    private int repulsiveForce;
    private int distance;
    private boolean circumvention;
    private boolean deceleration;
    private boolean acceleration;
    private double projection;

    public PeopleAvoidanceProperties() {
        super(SteeringType.PEOPLE_AVOIDANCE);
        this.repulsiveForce = 200;
        this.distance = 300;
        this.circumvention = false;
        this.deceleration = false;
        this.acceleration = false;
        this.projection = 16.0;
    }

    public PeopleAvoidanceProperties(SteeringProperties.BehaviorType behaviorType) {
        super(SteeringType.PEOPLE_AVOIDANCE, behaviorType);
        this.repulsiveForce = 200;
        this.distance = 300;
        this.circumvention = false;
        this.deceleration = false;
        this.acceleration = false;
        this.projection = 16.0;
        this.setNewBehaviorType(behaviorType);
    }

    public PeopleAvoidanceProperties(XMLPeopleAvoidanceProperties xml) {
        super(SteeringType.PEOPLE_AVOIDANCE, xml.active, xml.weight, xml.behavior);
        this.repulsiveForce = xml.repulsiveForce;
        this.distance = xml.distance;
        this.circumvention = xml.circumvention;
        this.deceleration = xml.deceleration;
        this.acceleration = xml.acceleration;
        this.projection = xml.projection;
    }

    public PeopleAvoidanceProperties(int forceFromOtherPeople, int distanceFromOtherPeople, boolean goRoundPartner, boolean deceleration, boolean acceleration, double visionInTicks) {
        super(SteeringType.PEOPLE_AVOIDANCE);
        this.repulsiveForce = forceFromOtherPeople;
        this.distance = distanceFromOtherPeople;
        this.circumvention = goRoundPartner;
        this.deceleration = false;
        this.acceleration = false;
        this.projection = visionInTicks;
    }

    @Override
    protected void setNewBehaviorType(SteeringProperties.BehaviorType behaviorType) {
        if (behaviorType.equals((Object)SteeringProperties.BehaviorType.BASIC)) {
            this.circumvention = false;
            this.deceleration = false;
            this.acceleration = false;
            this.projection = 0.0;
        } else if (behaviorType.equals((Object)SteeringProperties.BehaviorType.ADVANCED)) {
            this.circumvention = true;
            this.deceleration = true;
            this.acceleration = true;
            this.projection = 16.0;
        }
    }

    public int getRepulsiveForce() {
        return this.repulsiveForce;
    }

    public void setRepulsiveForce(int orderOfTheForce) {
        this.repulsiveForce = orderOfTheForce;
    }

    public int getDistanceFromOtherPeople() {
        return this.distance;
    }

    public void setDistanceFromOtherPeople(int distanceFromOtherPeople) {
        this.distance = distanceFromOtherPeople;
    }

    public boolean isCircumvention() {
        return this.circumvention;
    }

    public void setCircumvention(boolean goRoundPartner) {
        this.circumvention = goRoundPartner;
    }

    public double getProjection() {
        return this.projection;
    }

    public void setProjection(double projection) {
        this.projection = projection;
    }

    public boolean isAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(boolean acceleration) {
        this.acceleration = acceleration;
    }

    public boolean isDeceleration() {
        return this.deceleration;
    }

    public void setDeceleration(boolean deceleration) {
        this.deceleration = deceleration;
    }

    @Override
    public String getSpecialText() {
        String text = "";
        text = text + "  * Repulsive Force: " + this.repulsiveForce + "\n";
        text = text + "  * Distance: " + this.distance + "\n";
        text = text + "  * Circumvention: " + this.circumvention + "\n";
        text = text + "  * Deceleration: " + this.deceleration + "\n";
        text = text + "  * Acceleration: " + this.deceleration + "\n";
        text = text + "  * Projection: " + this.projection + "\n";
        return text;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.repulsiveForce = ((PeopleAvoidanceProperties)newProperties).getRepulsiveForce();
        this.distance = ((PeopleAvoidanceProperties)newProperties).getDistanceFromOtherPeople();
        this.circumvention = ((PeopleAvoidanceProperties)newProperties).isCircumvention();
        this.deceleration = ((PeopleAvoidanceProperties)newProperties).isDeceleration();
        this.acceleration = ((PeopleAvoidanceProperties)newProperties).isAcceleration();
        this.projection = ((PeopleAvoidanceProperties)newProperties).getProjection();
    }

    public XMLPeopleAvoidanceProperties getXMLProperties() {
        XMLPeopleAvoidanceProperties xmlProp = new XMLPeopleAvoidanceProperties();
        xmlProp.repulsiveForce = this.repulsiveForce;
        xmlProp.distance = this.distance;
        xmlProp.circumvention = this.circumvention;
        xmlProp.deceleration = this.deceleration;
        xmlProp.acceleration = this.acceleration;
        xmlProp.projection = this.projection;
        xmlProp.active = this.active;
        xmlProp.weight = this.weight;
        xmlProp.behavior = this.behaviorType;
        return xmlProp;
    }
}

